/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.FTMatches;
import org.basex.data.MetaData;
import org.basex.index.ft.FTIndexIterator;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTTokenizer;
import org.basex.query.ft.FTTokens;
import org.basex.query.item.FTNode;
import org.basex.query.item.Item;
import org.basex.query.item.Str;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public final class FTWords
extends FTExpr {
    FTTokenizer ftt;
    Data data;
    TokenList txt;
    FTMatches matches = new FTMatches(0);
    boolean first;
    FTMode mode = FTMode.M_ANY;
    Expr query;
    private Expr[] occ;
    private int tokNum;
    private boolean fast;

    public FTWords(InputInfo ii, Expr e, FTMode m, Expr[] o) {
        super(ii, new FTExpr[0]);
        this.query = e;
        this.mode = m;
        this.occ = o;
    }

    public FTWords(InputInfo ii, Data d, Item str, QueryContext ctx) throws QueryException {
        super(ii, new FTExpr[0]);
        this.query = str;
        this.data = d;
        this.comp(ctx);
    }

    @Override
    public FTExpr comp(QueryContext ctx) throws QueryException {
        if (this.ftt == null) {
            if (this.occ != null) {
                int o = 0;
                while (o < this.occ.length) {
                    this.occ[o] = this.occ[o].comp(ctx);
                    ++o;
                }
            }
            this.query = this.query.comp(ctx);
            if (this.query.value()) {
                this.txt = this.tokens(ctx);
            }
            this.fast = this.mode == FTMode.M_ANY && this.txt != null && this.occ == null;
            this.ftt = new FTTokenizer(this, ctx.ftopt, ctx.context.prop);
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        if (this.tokNum == 0) {
            ctx.ftoknum = (byte)(ctx.ftoknum + 1);
            this.tokNum = ctx.ftoknum;
        }
        this.matches.reset(this.tokNum);
        int c = this.contains(ctx);
        if (c == 0) {
            this.matches.size = 0;
        }
        return new FTNode(this.matches, c == 0 ? 0.0 : Scoring.word(c, ctx.fttoken.count()));
    }

    @Override
    public FTIter iter(final QueryContext ctx) {
        return new FTIter(){
            FTIndexIterator iat;
            int len;

            @Override
            public FTNode next() throws QueryException {
                if (this.iat == null) {
                    FTLexer lex = new FTLexer(FTWords.this.ftt.opt);
                    FTIndexIterator ia = null;
                    int t = 0;
                    TokenSet ts = FTWords.this.tokens(FTWords.this.txt != null ? FTWords.this.txt : FTWords.this.tokens(ctx), FTWords.this.ftt.opt);
                    for (byte[] k : ts) {
                        lex.init(k);
                        ia = null;
                        int d = 0;
                        if (!lex.hasNext()) {
                            return null;
                        }
                        do {
                            FTIndexIterator ir;
                            byte[] tok = lex.nextToken();
                            t += tok.length;
                            if (FTWords.this.ftt.opt.sw != null && FTWords.this.ftt.opt.sw.id(tok) != 0) {
                                ++d;
                                continue;
                            }
                            FTIndexIterator fTIndexIterator = ir = lex.get().length > 96 ? FTWords.this.scan(lex) : (FTIndexIterator)FTWords.this.data.ids(lex);
                            if (ia == null) {
                                ia = ir;
                                continue;
                            }
                            ia = FTIndexIterator.intersect(ia, ir, ++d);
                            d = 0;
                        } while (lex.hasNext());
                        if (this.iat == null) {
                            this.len = t;
                            this.iat = ia;
                        } else if (FTWords.this.mode == FTMode.M_ALL || FTWords.this.mode == FTMode.M_ALLWORDS) {
                            if (ia.indexSize() == 0) {
                                return null;
                            }
                            this.len += t;
                            this.iat = FTIndexIterator.intersect(ia, this.iat, 0);
                        } else {
                            if (ia.indexSize() == 0) continue;
                            this.len = Math.max(t, this.len);
                            this.iat = FTIndexIterator.union(ia, this.iat);
                        }
                        ctx.ftoknum = (byte)(ctx.ftoknum + 1);
                        this.iat.tokenNum(ctx.ftoknum);
                    }
                }
                return this.iat != null && this.iat.more() ? new FTNode(this.iat.matches(), FTWords.this.data, this.iat.next(), this.len, this.iat.indexSize(), this.iat.score()) : null;
            }
        };
    }

    FTIndexIterator scan(FTLexer lex) throws QueryException {
        final FTLexer intok = new FTLexer(this.ftt.opt);
        final FTTokens qtok = this.ftt.cache(lex.get());
        return new FTIndexIterator(){
            int pre = -1;

            @Override
            public int next() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < FTWords.this.data.meta.size) {
                    if (FTWords.this.data.kind(this.pre) != 2) continue;
                    intok.init(FTWords.this.data.text(this.pre, true));
                    FTWords.this.matches.reset(0);
                    try {
                        if (FTWords.this.ftt.contains(qtok, intok) == 0) continue;
                        return true;
                    }
                    catch (QueryException queryException) {
                        // empty catch block
                    }
                }
                return false;
            }

            @Override
            public double score() {
                return -1.0;
            }

            @Override
            public FTMatches matches() {
                return FTWords.this.matches;
            }

            @Override
            public int indexSize() {
                return 1;
            }
        };
    }

    TokenList tokens(QueryContext ctx) throws QueryException {
        byte[] qu;
        TokenList tl = new TokenList();
        Iter ir = ctx.iter(this.query);
        while ((qu = this.nextToken(ir)) != null) {
            if (qu.length == 0 && this.mode != FTMode.M_ALL && this.mode != FTMode.M_ALLWORDS) continue;
            tl.add(qu);
        }
        return tl;
    }

    private int contains(QueryContext ctx) throws QueryException {
        long mx;
        this.first = true;
        FTLexer intok = this.ftt.copy(ctx.fttoken);
        int num = 0;
        if (this.fast) {
            for (byte[] t : this.txt) {
                FTTokens qtok = this.ftt.cache(t);
                num = Math.max(num, this.ftt.contains(qtok, intok) * qtok.length());
            }
            return num;
        }
        TokenList tl = this.tokens(ctx);
        TokenSet ts = this.tokens(tl, intok.ftOpt());
        boolean all = this.mode == FTMode.M_ALL || this.mode == FTMode.M_ALLWORDS;
        int oc = 0;
        for (byte[] k : ts) {
            FTTokens qtok = this.ftt.cache(k);
            int o = this.ftt.contains(qtok, intok);
            if (all && o == 0) {
                return 0;
            }
            num = Math.max(num, o * qtok.length());
            oc += o;
        }
        long mn = this.occ != null ? this.checkItr(this.occ[0], ctx) : 1L;
        long l = mx = this.occ != null ? this.checkItr(this.occ[1], ctx) : Long.MAX_VALUE;
        if (mn == 0L && oc == 0) {
            this.matches = FTNot.not(this.matches);
        }
        return (long)oc >= mn && (long)oc <= mx ? Math.max(1, num) : 0;
    }

    TokenSet tokens(TokenList list, FTOpt ftopt) {
        TokenSet ts = new TokenSet();
        switch (this.mode) {
            case M_ALL: 
            case M_ANY: {
                for (byte[] t : list) {
                    ts.add(t);
                }
                break;
            }
            case M_ALLWORDS: 
            case M_ANYWORD: {
                FTLexer l = new FTLexer(ftopt);
                for (byte[] t : list) {
                    l.init(t);
                    while (l.hasNext()) {
                        ts.add(l.nextToken());
                    }
                }
                break;
            }
            case M_PHRASE: {
                TokenBuilder tb = new TokenBuilder();
                for (byte[] t : list) {
                    tb.add(t).add(32);
                }
                ts.add(tb.trim().finish());
            }
        }
        return ts;
    }

    byte[] nextToken(Iter iter) throws QueryException {
        Item it = iter.next();
        return it == null ? null : this.checkEStr(it);
    }

    void add(int s, int e) {
        if (!(this.first || this.mode != FTMode.M_ALL && this.mode != FTMode.M_ALLWORDS)) {
            this.matches.and(s, e);
        } else {
            this.matches.or(s, e);
        }
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        MetaData md = ic.data.meta;
        FTOpt fto = this.ftt.opt;
        boolean wc = fto.is(FTFlag.WC);
        if (wc && !md.wildcards) {
            return false;
        }
        if (fto.isSet(FTFlag.CS) && md.casesens != fto.is(FTFlag.CS) || fto.isSet(FTFlag.DC) && md.diacritics != fto.is(FTFlag.DC) || fto.isSet(FTFlag.ST) && md.stemming != fto.is(FTFlag.ST) || fto.ln != null && md.language != fto.ln || this.occ != null) {
            return false;
        }
        if (this.txt == null) {
            ic.costs(Math.max(1, ic.data.meta.size / 20));
            return true;
        }
        fto.set(FTFlag.CS, md.casesens);
        fto.set(FTFlag.DC, md.diacritics);
        fto.set(FTFlag.ST, md.stemming);
        fto.ln = md.language;
        FTLexer ft = new FTLexer(fto);
        ic.costs(0);
        for (byte[] t : this.txt) {
            ft.init(t);
            while (ft.hasNext()) {
                byte[] tok = ft.nextToken();
                if (fto.sw != null && fto.sw.id(tok) != 0) continue;
                if (wc) {
                    t = ft.get();
                    if (t[0] == 46) {
                        return false;
                    }
                    int d = 0;
                    byte[] byArray = t;
                    int n = t.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte w = byArray[n2];
                        if (w == 123 || w == 92 || w == 46 && ++d > 1) {
                            return false;
                        }
                        ++n2;
                    }
                }
                ic.addCosts(Math.max(1, ic.data.nrIDs(ft) >> 2));
            }
        }
        return true;
    }

    @Override
    public FTExpr indexEquivalent(IndexContext ic) {
        this.data = ic.data;
        return this;
    }

    @Override
    public boolean usesExclude() {
        return this.occ != null;
    }

    @Override
    public boolean uses(Expr.Use u) {
        if (this.occ != null) {
            Expr[] exprArray = this.occ;
            int n = this.occ.length;
            int n2 = 0;
            while (n2 < n) {
                Expr o = exprArray[n2];
                if (o.uses(u)) {
                    return true;
                }
                ++n2;
            }
        }
        return this.query.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        if (this.occ != null) {
            Expr[] exprArray = this.occ;
            int n = this.occ.length;
            int n2 = 0;
            while (n2 < n) {
                Expr o = exprArray[n2];
                c += o.count(v);
                ++n2;
            }
        }
        return c + this.query.count(v);
    }

    @Override
    public boolean removable(Var v) {
        if (this.occ != null) {
            Expr[] exprArray = this.occ;
            int n = this.occ.length;
            int n2 = 0;
            while (n2 < n) {
                Expr o = exprArray[n2];
                if (!o.removable(v)) {
                    return false;
                }
                ++n2;
            }
        }
        return this.query.removable(v);
    }

    @Override
    public FTExpr remove(Var v) {
        if (this.occ != null) {
            int o = 0;
            while (o < this.occ.length) {
                this.occ[o] = this.occ[o].remove(v);
                ++o;
            }
        }
        this.query = this.query.remove(v);
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        if (this.occ != null) {
            this.occ[0].plan(ser);
            this.occ[1].plan(ser);
        }
        this.query.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!(this.query instanceof Str)) {
            sb.append("{ ");
        }
        sb.append(this.query);
        if (!(this.query instanceof Str)) {
            sb.append(" }");
        }
        switch (this.mode) {
            case M_ALL: {
                sb.append(" all");
                break;
            }
            case M_ALLWORDS: {
                sb.append(" all words");
                break;
            }
            case M_ANYWORD: {
                sb.append(" any word");
                break;
            }
            case M_PHRASE: {
                sb.append(" phrase");
            }
        }
        if (this.occ != null) {
            sb.append("occurs " + this.occ[0] + " " + "to" + " " + this.occ[1] + " " + "times");
        }
        return sb.toString();
    }

    public static enum FTMode {
        M_ALL,
        M_ALLWORDS,
        M_ANY,
        M_ANYWORD,
        M_PHRASE;

    }
}

