/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Pos;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class CmpV
extends Cmp {
    private Op op;

    public CmpV(InputInfo ii, Expr e1, Expr e2, Op o) {
        super(ii, e1, e2);
        this.op = o;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        if (this.swap()) {
            this.op = this.op.swap();
            ctx.compInfo("operands swapped: %", this);
        }
        int e = 0;
        while (e != this.expr.length) {
            this.expr[e] = this.expr[e].addText(ctx);
            ++e;
        }
        Expr e1 = this.expr[0];
        Expr e2 = this.expr[1];
        this.type = SeqType.get((Type)AtomType.BLN, e1.size() == 1L && e2.size() == 1L ? SeqType.Occ.O : SeqType.Occ.ZO);
        Expr e3 = this;
        if (this.oneEmpty()) {
            e3 = this.optPre(null, ctx);
        } else if (this.values()) {
            e3 = this.preEval(ctx);
        } else if (e1.isFun(Function.COUNT)) {
            e3 = this.compCount(this.op);
            if (e3 != this) {
                ctx.compInfo(e3 instanceof Bln ? "pre-evaluating %" : "rewriting %", this);
            }
        } else if (e1.isFun(Function.POS)) {
            if ((e3 = Pos.get(this.op, e2, e3, this.input)) != this) {
                ctx.compInfo("rewriting %", this);
            }
        } else if (e1.type().eq(SeqType.BLN) && (this.op == Op.EQ && e2 == Bln.FALSE || this.op == Op.NE && e2 == Bln.TRUE)) {
            e3 = Function.NOT.get(this.input, e1);
        }
        return e3;
    }

    @Override
    public Expr compEbv(QueryContext ctx) {
        return (this.op == Op.EQ && this.expr[1] == Bln.TRUE || this.op == Op.NE && this.expr[1] == Bln.FALSE) && this.expr[0].type().eq(SeqType.BLN) ? this.expr[0] : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item a = this.expr[0].item(ctx, this.input);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.input);
        if (b == null) {
            return null;
        }
        if (!a.comparable(b)) {
            Err.XPTYPECMP.thrw(this.input, a.type, b.type);
        }
        return Bln.get(this.op.e(this.input, a, b));
    }

    @Override
    public CmpV invert() {
        return this.expr[0].size() != 1L || this.expr[1].size() != 1L ? this : new CmpV(this.input, this.expr[0], this.expr[1], this.op.invert());
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.OP, Token.token(this.op.name)});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            e.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return "'" + (Object)((Object)this.op) + "' expression";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + " ");
    }

    public static enum Op {
        LE("le"){

            @Override
            public boolean e(InputInfo ii, Item a, Item b) throws QueryException {
                int v = a.diff(ii, b);
                return v != Integer.MIN_VALUE && v <= 0;
            }

            @Override
            public Op swap() {
                return GE;
            }

            @Override
            public Op invert() {
                return GT;
            }
        }
        ,
        LT("lt"){

            @Override
            public boolean e(InputInfo ii, Item a, Item b) throws QueryException {
                int v = a.diff(ii, b);
                return v != Integer.MIN_VALUE && v < 0;
            }

            @Override
            public Op swap() {
                return GT;
            }

            @Override
            public Op invert() {
                return GE;
            }
        }
        ,
        GE("ge"){

            @Override
            public boolean e(InputInfo ii, Item a, Item b) throws QueryException {
                int v = a.diff(ii, b);
                return v != Integer.MIN_VALUE && v >= 0;
            }

            @Override
            public Op swap() {
                return LE;
            }

            @Override
            public Op invert() {
                return LT;
            }
        }
        ,
        GT("gt"){

            @Override
            public boolean e(InputInfo ii, Item a, Item b) throws QueryException {
                int v = a.diff(ii, b);
                return v != Integer.MIN_VALUE && v > 0;
            }

            @Override
            public Op swap() {
                return LT;
            }

            @Override
            public Op invert() {
                return LE;
            }
        }
        ,
        EQ("eq"){

            @Override
            public boolean e(InputInfo ii, Item a, Item b) throws QueryException {
                return a.eq(ii, b);
            }

            @Override
            public Op swap() {
                return EQ;
            }

            @Override
            public Op invert() {
                return NE;
            }
        }
        ,
        NE("ne"){

            @Override
            public boolean e(InputInfo ii, Item a, Item b) throws QueryException {
                return !a.eq(ii, b);
            }

            @Override
            public Op swap() {
                return NE;
            }

            @Override
            public Op invert() {
                return EQ;
            }
        };

        public final String name;

        private Op(String n2) {
            this.name = n2;
        }

        public abstract boolean e(InputInfo var1, Item var2, Item var3) throws QueryException;

        public abstract Op swap();

        public abstract Op invert();

        public String toString() {
            return this.name;
        }
    }
}

