/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Scanner;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunc;
import org.basex.query.item.Atm;
import org.basex.query.item.QNm;
import org.basex.query.item.Type;
import org.basex.query.item.Types;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.util.Token;

public final class QueryProcessor
extends Progress {
    public final QueryContext ctx;
    private String query;
    private boolean parsed;
    private boolean compiled;

    public QueryProcessor(String qu, Context cx) {
        this(qu, cx.current, cx);
    }

    public QueryProcessor(String qu, Nodes nodes, Context cx) {
        this.query = qu;
        this.ctx = new QueryContext(cx);
        this.ctx.nodes = nodes;
        this.progress(this.ctx);
    }

    public void parse() throws QueryException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        String bind = this.ctx.context.prop.get(Prop.BINDINGS);
        if (!bind.isEmpty()) {
            Scanner sc = new Scanner(bind);
            sc.useDelimiter(",");
            while (sc.hasNext()) {
                String[] sp = sc.next().split("=", 2);
                this.bind(sp[0], new Atm(Token.token(sp.length > 1 ? sp[1] : "")));
            }
        }
        this.ctx.parse(this.query);
    }

    public void compile() throws QueryException {
        this.parse();
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.ctx.compile();
    }

    public Iter iter() throws QueryException {
        this.compile();
        return this.ctx.iter();
    }

    public Value value() throws QueryException {
        this.compile();
        return this.ctx.value();
    }

    public Result execute() throws QueryException {
        this.compile();
        return this.ctx.eval();
    }

    public void bind(String n, String o, String t) throws QueryException {
        Object obj = o;
        if (t != null && !t.isEmpty()) {
            Type typ;
            QNm type = new QNm(Token.token(t));
            if (type.ns()) {
                type.uri(this.ctx.ns.uri(type.pref(), false, null));
            }
            if ((typ = Types.find(type, true)) != null) {
                obj = typ.e(o, null);
            } else {
                Err.NOTYPE.thrw(null, type);
            }
        }
        this.bind(n, obj);
    }

    public void bind(String n, Object o) throws QueryException {
        Expr ex = o instanceof Expr ? (Expr)o : JavaFunc.type(o).e(o, null);
        QNm nm = new QNm(Token.token(n.indexOf(36) == 0 ? n.substring(1) : n));
        this.ctx.ns.uri(nm);
        Var gl = this.ctx.vars.global().get(nm);
        if (gl == null) {
            this.ctx.vars.setGlobal(Var.create(this.ctx, null, nm).bind(ex, this.ctx));
        } else {
            gl.declared = false;
            gl.bind(gl.type != null ? gl.type.type.e(ex.item(this.ctx, null), this.ctx, null) : ex, this.ctx);
        }
    }

    public void context(Object o) throws QueryException {
        this.ctx.initExpr = o instanceof Expr ? (Expr)o : JavaFunc.type(o).e(o, null);
    }

    public XMLSerializer getSerializer(OutputStream os) throws IOException, QueryException {
        this.compile();
        try {
            return new XMLSerializer(os, this.ctx.serProp(true));
        }
        catch (SerializerException ex) {
            throw new QueryException(null, ex);
        }
    }

    public Nodes queryNodes() throws QueryException {
        Result res = this.execute();
        if (!(res instanceof Nodes)) {
            if (res.size() == 0L) {
                return new Nodes(this.ctx.nodes.data);
            }
            Err.QUERYNODES.thrw(null, new Object[0]);
        }
        return (Nodes)res;
    }

    public void module(String file, String uri) {
        this.ctx.modDeclared.add(Token.token(file), Token.token(uri));
    }

    public void query(String qu) {
        this.query = qu;
        this.parsed = false;
        this.compiled = false;
    }

    public void close() throws IOException {
        this.ctx.resource.close();
        if (this.ctx.props != null) {
            for (Map.Entry<String, Object> e : this.ctx.props.entrySet()) {
                this.ctx.context.prop.set(e.getKey(), e.getValue());
            }
            this.ctx.props = null;
        }
    }

    public int updates() {
        return this.ctx.updates.size();
    }

    public String info() {
        return this.ctx.info();
    }

    public static boolean updating(Context ctx, String qu) {
        try {
            QueryProcessor qp = new QueryProcessor(qu, ctx);
            qp.parse();
            return qp.ctx.updating;
        }
        catch (QueryException ex) {
            return true;
        }
    }

    public static String removeComments(String qu, int max) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        boolean s = false;
        int cl = qu.length();
        int c = 0;
        while (c < cl && sb.length() < max) {
            char ch = qu.charAt(c);
            if (ch != '\r') {
                if (ch == '(' && c + 1 < cl && qu.charAt(c + 1) == ':') {
                    if (m == 0 && !s) {
                        sb.append(' ');
                        s = true;
                    }
                    ++m;
                    ++c;
                } else if (m != 0 && ch == ':' && c + 1 < cl && qu.charAt(c + 1) == ')') {
                    --m;
                    ++c;
                } else if (m == 0) {
                    if (ch > ' ') {
                        sb.append(ch);
                    } else if (!s) {
                        sb.append(' ');
                    }
                    s = ch <= ' ';
                }
            }
            ++c;
        }
        if (sb.length() >= max) {
            sb.append("...");
        }
        return sb.toString().trim();
    }

    public void plan(Serializer ser) throws IOException {
        this.ctx.plan(ser);
    }

    @Override
    public String tit() {
        return Text.QUERYEVAL;
    }

    @Override
    public String det() {
        return Text.QUERYEVAL;
    }
}

