/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.IOException;
import java.util.Arrays;
import org.basex.data.MetaData;
import org.basex.io.random.TableAccess;

public final class TableMemAccess
extends TableAccess {
    private long[] buf1 = new long[16];
    private long[] buf2 = new long[16];

    public TableMemAccess(MetaData md) {
        super(md);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read1(int p, int o) {
        return (int)((o < 8 ? this.buf1 : this.buf2)[p] >> ((o < 8 ? 7 : 15) - o << 3) & 0xFFL);
    }

    @Override
    public int read2(int p, int o) {
        return (int)((o < 8 ? this.buf1 : this.buf2)[p] >> ((o < 8 ? 6 : 14) - o << 3) & 0xFFFFL);
    }

    @Override
    public int read4(int p, int o) {
        return (int)((o < 8 ? this.buf1 : this.buf2)[p] >> ((o < 8 ? 4 : 12) - o << 3));
    }

    @Override
    public long read5(int p, int o) {
        return (o < 8 ? this.buf1 : this.buf2)[p] >> ((o < 8 ? 3 : 11) - o << 3) & 0xFFFFFFFFFFL;
    }

    @Override
    public void write1(int p, int o, int v) {
        this.dirty = true;
        long[] buf = o < 8 ? this.buf1 : this.buf2;
        long d = (o < 8 ? 7 : 15) - o << 3;
        buf[p] = buf[p] & (255L << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)v << (int)d;
    }

    @Override
    public void write2(int p, int o, int v) {
        this.dirty = true;
        long[] buf = o < 8 ? this.buf1 : this.buf2;
        long d = (o < 8 ? 6 : 14) - o << 3;
        buf[p] = buf[p] & (65535L << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)v << (int)d;
    }

    @Override
    public void write4(int p, int o, int v) {
        this.dirty = true;
        long[] buf = o < 8 ? this.buf1 : this.buf2;
        long d = (o < 8 ? 4 : 12) - o << 3;
        buf[p] = buf[p] & (0xFFFFFFFFL << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | (long)v << (int)d;
    }

    @Override
    public void write5(int p, int o, long v) {
        this.dirty = true;
        long[] buf = o < 8 ? this.buf1 : this.buf2;
        long d = (o < 8 ? 3 : 11) - o << 3;
        buf[p] = buf[p] & (0xFFFFFFFFFFL << (int)d ^ 0xFFFFFFFFFFFFFFFFL) | v << (int)d;
    }

    @Override
    protected void copy(byte[] entries, int pre, int last) {
        int o = 0;
        int i = pre;
        while (i < last) {
            this.buf1[i] = this.getLong(entries, o);
            this.buf2[i] = this.getLong(entries, o + 8);
            ++i;
            o += 16;
        }
        this.dirty = true;
    }

    @Override
    public void delete(int pre, int nr) {
        if (nr == 0) {
            return;
        }
        this.move(pre + nr, pre);
    }

    @Override
    public void insert(int pre, byte[] entries) {
        if (entries.length == 0) {
            return;
        }
        this.move(pre, pre + (entries.length >>> 4));
        this.set(pre, entries);
    }

    private void move(int op, int np) {
        this.dirty = true;
        int l = this.meta.size - op;
        while (l + np >= this.buf1.length) {
            int s = this.buf1.length << 1;
            this.buf1 = Arrays.copyOf(this.buf1, s);
            this.buf2 = Arrays.copyOf(this.buf2, s);
        }
        System.arraycopy(this.buf1, op, this.buf1, np, l);
        System.arraycopy(this.buf2, op, this.buf2, np, l);
        this.meta.size += np - op;
    }

    private long getLong(byte[] v, int i) {
        return ((long)v[i] & 0xFFL) << 56 | ((long)v[i + 1] & 0xFFL) << 48 | ((long)v[i + 2] & 0xFFL) << 40 | ((long)v[i + 3] & 0xFFL) << 32 | ((long)v[i + 4] & 0xFFL) << 24 | ((long)v[i + 5] & 0xFFL) << 16 | ((long)v[i + 6] & 0xFFL) << 8 | (long)v[i + 7] & 0xFFL;
    }
}

