/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class IndexStats {
    private final int max;
    private final int[] occMin;
    private final int[] occMax;
    private final byte[][] txtMin;
    private final byte[][] txtMax;
    private int size;
    private int co;

    public IndexStats(Data d) {
        this.max = d.meta.prop.num(Prop.MAXSTAT);
        this.occMin = new int[this.max];
        this.occMax = new int[this.max];
        this.txtMin = new byte[this.max][];
        this.txtMax = new byte[this.max][];
        int o = 0;
        while (o < this.txtMin.length) {
            this.txtMin[o] = Token.EMPTY;
            this.txtMax[o] = Token.EMPTY;
            this.occMin[o] = Integer.MAX_VALUE;
            ++o;
        }
    }

    public boolean adding(int oc) {
        this.co = oc;
        ++this.size;
        return oc > this.occMax[this.max - 1] || oc < this.occMin[this.max - 1];
    }

    public void add(byte[] tx) {
        boolean dsc = this.co > this.occMax[this.max - 1];
        byte[][] txt = dsc ? this.txtMax : this.txtMin;
        int[] ocs = dsc ? this.occMax : this.occMin;
        int a = this.max - 1;
        while (a >= 0) {
            if (a == 0 || dsc && this.co < ocs[a - 1] || !dsc && this.co > ocs[a - 1]) {
                txt[a] = tx;
                ocs[a] = this.co;
                break;
            }
            txt[a] = txt[a - 1];
            ocs[a] = ocs[a - 1];
            --a;
        }
    }

    public void print(TokenBuilder tb) {
        tb.add("- Entries: " + this.size + Text.NL);
        int m = 0;
        int c = 0;
        int o = 0;
        while (o < this.max) {
            int tl = this.txtMin[o].length;
            if (tl == 0) {
                ++c;
            } else if (m < tl) {
                m = tl;
            }
            tl = this.txtMax[o].length;
            if (tl == 0) {
                ++c;
            } else if (m < tl) {
                m = tl;
            }
            ++o;
        }
        this.print(tb, this.txtMax, this.occMax, m + 2);
        if (c == 0) {
            tb.add("  ..." + Text.NL);
        }
        this.print(tb, this.txtMin, this.occMin, m + 2);
    }

    private void print(TokenBuilder tb, byte[][] txt, int[] ocs, int len) {
        int o = 0;
        while (o < ocs.length) {
            if (txt[o].length != 0) {
                tb.add("  ").add(txt[o]);
                int j = 0;
                while (j < len - txt[o].length) {
                    tb.add(32);
                    ++j;
                }
                tb.addLong(ocs[o]).add(120).add(Text.NL);
            }
            ++o;
        }
    }
}

