/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.explore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.explore.ExploreArea;

public final class ExploreView
extends View {
    private final BaseXLabel header;
    private final ExploreArea search;
    private final BaseXButton filter;

    public ExploreView(ViewNotifier man) {
        super("explore", Text.HELPEXPLORE, man);
        this.layout(new BorderLayout(0, 4)).border(6, 6, 6, 6).setFocusable(false);
        this.header = new BaseXLabel(Text.EXPLORETIT, true, false);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        b.add((Component)this.header, "Center");
        this.filter = BaseXButton.command(GUICommands.FILTER, this.gui);
        this.filter.addKeyListener(this);
        b.add((Component)this.filter, "East");
        this.add((Component)b, "North");
        this.search = new ExploreArea(this);
        this.add((Component)this.search, "Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
        this.search.init();
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        Nodes marked = this.gui.context.marked;
        this.filter.setEnabled(!this.gui.gprop.is(GUIProp.FILTERRT) && marked != null && marked.size() != 0L);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        this.refreshMark();
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWEXPLORE);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWEXPLORE, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }
}

