/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.io.IOException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Restore;
import org.basex.data.MetaData;
import org.basex.gui.GUI;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXList;
import org.basex.io.in.BufferInput;
import org.basex.io.in.DataInput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ObjList;
import org.basex.util.list.StringList;

public final class DialogOpen
extends Dialog {
    private final BaseXList choice;
    private final BaseXLabel doc;
    private final BaseXEditor detail;
    private final BaseXBack buttons;
    private final BaseXButton rename;
    private final BaseXButton drop;
    private final BaseXButton open;
    private final BaseXButton backup;
    private final BaseXButton restore;
    private final BaseXButton copy;
    private final boolean manage;
    private boolean refresh;

    public DialogOpen(GUI main, boolean m) {
        super(main, m ? Text.MANAGETITLE : Text.OPENTITLE);
        this.manage = m;
        StringList db = List.list(main.context);
        this.choice = new BaseXList(db.toArray(), this, !m);
        this.set(this.choice, "Center");
        this.choice.setSize(160, 440);
        BaseXBack info = new BaseXBack(new BorderLayout());
        info.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
        Font f = this.choice.getFont();
        this.doc = new BaseXLabel(Text.DIALOGINFO).border(0, 0, 5, 0);
        this.doc.setFont(f.deriveFont(f.getSize2D() + 7.0f));
        info.add((Component)this.doc, "North");
        this.detail = new BaseXEditor(false, (Window)this);
        this.detail.border(5, 5, 5, 5).setFont(f);
        BaseXLayout.setWidth(this.detail, 400);
        info.add((Component)this.detail, "Center");
        BaseXBack pp = new BaseXBack(new BorderLayout()).border(0, 12, 0, 0);
        pp.add((Component)info, "Center");
        BaseXBack p = new BaseXBack(new BorderLayout());
        this.backup = new BaseXButton(Text.BUTTONBACKUP, this);
        this.restore = new BaseXButton(Text.BUTTONRESTORE, this);
        this.copy = new BaseXButton(Text.BUTTONCOPY, this);
        this.rename = new BaseXButton(Text.BUTTONRENAME, this);
        this.open = new BaseXButton(Text.BUTTONOPEN, this);
        this.drop = new BaseXButton(Text.BUTTONDROP, this);
        this.buttons = this.manage ? DialogOpen.newButtons(this, this.drop, this.rename, this.copy, this.backup, this.restore, Text.BUTTONOK) : DialogOpen.newButtons(this, this.open, Text.BUTTONCANCEL);
        p.add((Component)this.buttons, "East");
        pp.add((Component)p, "South");
        this.set(pp, "East");
        this.action(null);
        if (db.size() == 0) {
            return;
        }
        this.finish(null);
    }

    public String db() {
        return this.choice.getValue();
    }

    public boolean nodb() {
        return this.choice.getList().length == 0;
    }

    @Override
    public void action(Object cmp) {
        Context ctx = this.gui.context;
        if (this.refresh) {
            this.choice.setData(List.list(ctx).toArray());
            this.choice.requestFocusInWindow();
            this.refresh = false;
        }
        StringList dbs = this.choice.getValues();
        String db = this.choice.getValue().trim();
        ObjList<Command> cmds = new ObjList<Command>();
        boolean o = dbs.size() > 0;
        boolean bl = this.ok = this.manage || o;
        if (cmp == this.open) {
            this.close();
        } else if (cmp == this.drop) {
            if (!Dialog.confirm(this.gui, Util.info(Text.DROPCONF, dbs.size()))) {
                return;
            }
            this.refresh = true;
            for (String s : dbs) {
                cmds.add(new DropDB(s));
            }
        } else if (cmp == this.rename) {
            DialogInput dr = new DialogInput(db, Text.RENAMETITLE, this.gui, 1);
            if (!dr.ok() || dr.input().equals(db)) {
                return;
            }
            this.refresh = true;
            cmds.add(new AlterDB(db, dr.input()));
        } else if (cmp == this.copy) {
            DialogInput dc = new DialogInput(db, Text.COPYTITLE, this.gui, 2);
            if (!dc.ok() || dc.input().equals(db)) {
                return;
            }
            this.refresh = true;
            cmds.add(new Copy(db, dc.input()));
        } else if (cmp == this.backup) {
            for (String s : dbs) {
                cmds.add(new CreateBackup(s));
            }
        } else if (cmp == this.restore) {
            for (String s : dbs) {
                cmds.add(new Restore(s));
            }
        } else {
            block36: {
                DialogOpen.enableOK(this.buttons, Text.BUTTONOPEN, o);
                DialogOpen.enableOK(this.buttons, Text.BUTTONBACKUP, o);
                DialogOpen.enableOK(this.buttons, Text.BUTTONDROP, o);
                o = ctx.mprop.dbexists(db);
                if (o) {
                    BufferInput in = null;
                    MetaData meta = new MetaData(db, ctx);
                    try {
                        try {
                            in = new DataInput(meta.dbfile("inf"));
                            meta.read((DataInput)in);
                            this.detail.setText(InfoDB.db(meta, true, true, true));
                        }
                        catch (IOException ex) {
                            this.detail.setText(Token.token(ex.getMessage()));
                            o = this.manage;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block36;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            DialogOpen.enableOK(this.buttons, Text.BUTTONRENAME, o);
            DialogOpen.enableOK(this.buttons, Text.BUTTONCOPY, o);
            o = true;
            for (String s : dbs) {
                o &= Restore.list(s, ctx).size() != 0;
            }
            DialogOpen.enableOK(this.buttons, Text.BUTTONRESTORE, o);
        }
        if (cmds.size() != 0) {
            DialogProgress.execute(this, "", cmds.toArray(new Command[cmds.size()]));
        }
    }

    @Override
    public void close() {
        if (this.ok || this.choice.getValue().isEmpty()) {
            this.dispose();
        }
    }
}

