/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.util.Token;

final class DialogMessage
extends Dialog {
    boolean canceled = true;
    BaseXButton yes;
    BaseXButton no;
    BaseXButton cancel;

    DialogMessage(GUI main, String txt, GUIConstants.Msg ic) {
        super(main, ic == GUIConstants.Msg.ERROR ? Text.DIALOGERR : Text.DIALOGINFO);
        BaseXBack buttons;
        BaseXBack p = new BaseXBack(new BorderLayout()).border(0, 0, 0, 16).mode(GUIConstants.Fill.NONE);
        BaseXLabel b = new BaseXLabel();
        b.setIcon(ic.large);
        p.add((Component)b, "North");
        this.set(p, "West");
        BaseXEditor text = new BaseXEditor(false, (Window)this);
        text.setFont(p.getFont());
        text.setText(Token.token(txt));
        text.setFocusable(true);
        this.set(text, "Center");
        if (ic == GUIConstants.Msg.QUESTION || ic == GUIConstants.Msg.YESNOCANCEL) {
            this.yes = new BaseXButton(Text.BUTTONYES, this);
            this.no = new BaseXButton(Text.BUTTONNO, this);
            if (ic == GUIConstants.Msg.QUESTION) {
                buttons = DialogMessage.newButtons(this, this.yes, this.no);
            } else {
                this.cancel = new BaseXButton(Text.BUTTONCANCEL, this);
                buttons = DialogMessage.newButtons(this, this.yes, this.no, this.cancel);
            }
        } else {
            this.yes = new BaseXButton(Text.BUTTONOK, this);
            buttons = DialogMessage.newButtons(this, this.yes);
        }
        this.set(buttons, "South");
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                DialogMessage.this.yes.requestFocusInWindow();
            }
        });
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        boolean bl = this.canceled = cmp != this.yes && cmp != this.no;
        if (cmp == this.yes) {
            this.close();
        } else {
            this.cancel();
        }
    }

    public boolean canceled() {
        return this.canceled;
    }
}

