/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXRadio;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;

public final class DialogInsert
extends Dialog {
    public final StringList result = new StringList();
    public int kind;
    private final BaseXBack buttons;
    private final BaseXBack back;
    private final BaseXLabel info;
    private final BaseXTextField input1;
    private final BaseXEditor input2;
    private final BaseXLabel label1 = new BaseXLabel(String.valueOf(Text.EDITNAME) + ": ", true, true).border(0, 0, 0, 0);
    private final BaseXLabel label2 = new BaseXLabel(String.valueOf(Text.EDITVALUE) + ": ", true, true).border(0, 0, 0, 0);
    private final BaseXRadio[] radio;

    public DialogInsert(GUI main) {
        super(main, Text.INSERTTITLE);
        this.input1 = new BaseXTextField(this);
        this.input1.addKeyListener(this.keys);
        BaseXLayout.setWidth(this.input1, 320);
        this.input2 = new BaseXEditor(true, (Window)this);
        this.input2.setFont(GUIConstants.mfont);
        this.input2.addKeyListener(this.keys);
        BaseXLayout.setWidth(this.input2, 320);
        BaseXBack knd = new BaseXBack(new TableLayout(1, 5));
        ButtonGroup group = new ButtonGroup();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogInsert.this.change(e.getSource());
            }
        };
        int lkind = this.gui.gprop.num(GUIProp.LASTINSERT);
        this.radio = new BaseXRadio[Text.EDITKIND.length];
        int i = 1;
        while (i < Text.EDITKIND.length) {
            this.radio[i] = new BaseXRadio(Text.EDITKIND[i], false, this);
            this.radio[i].addActionListener(al);
            this.radio[i].setSelected(i == lkind);
            this.radio[i].addKeyListener(this.keys);
            group.add(this.radio[i]);
            knd.add(this.radio[i]);
            ++i;
        }
        this.set(knd, "North");
        this.back = new BaseXBack(10, 0, 0, 0);
        this.set(this.back, "Center");
        BaseXBack pp = new BaseXBack(new BorderLayout());
        this.info = new BaseXLabel(" ").border(8, 0, 2, 0);
        pp.add((Component)this.info, "West");
        this.buttons = DialogInsert.okCancel(this);
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.setResizable(true);
        this.change(this.radio[lkind]);
        this.action(null);
        this.finish(null);
    }

    void change(Object src) {
        int n = 0;
        int r = 0;
        while (r < this.radio.length) {
            if (src == this.radio[r]) {
                n = r;
            }
            ++r;
        }
        BaseXLayout.setHeight(this.input2, n == 3 ? 25 : 200);
        this.back.removeAll();
        this.back.layout(new BorderLayout(0, 4));
        if (n != 2 && n != 4) {
            BaseXBack b = new BaseXBack(new BorderLayout(0, 4));
            b.add((Component)this.label1, "North");
            b.add((Component)this.input1, "Center");
            this.back.add((Component)b, "North");
        }
        if (n != 1) {
            BaseXBack b = new BaseXBack(new BorderLayout(0, 4));
            b.add((Component)this.label2, "North");
            b.add((Component)this.input2, "Center");
            this.back.add((Component)b, "Center");
        }
        this.pack();
    }

    @Override
    public void action(Object cmp) {
        int i = 1;
        while (i < Text.EDITKIND.length) {
            if (this.radio[i].isSelected()) {
                this.kind = i;
            }
            ++i;
        }
        this.gui.gprop.set(GUIProp.LASTINSERT, this.kind);
        String msg = null;
        boolean bl = this.ok = this.kind != 2 || this.input2.getText().length != 0;
        if (this.kind != 2 && this.kind != 4) {
            this.ok = XMLToken.isQName(Token.token(this.input1.getText()));
            if (!this.ok && !this.input1.getText().isEmpty()) {
                msg = Util.info(Text.INVALID, Text.EDITNAME);
            }
        }
        this.info.setText(msg, GUIConstants.Msg.ERROR);
        DialogInsert.enableOK(this.buttons, Text.BUTTONOK, this.ok);
    }

    @Override
    public void close() {
        super.close();
        String in1 = this.input1.getText();
        String in2 = Token.string(this.input2.getText());
        switch (this.kind) {
            case 3: 
            case 5: {
                this.result.add(in1);
                this.result.add(in2);
                break;
            }
            case 1: {
                this.result.add(in1);
                break;
            }
            case 2: 
            case 4: {
                this.result.add(in2);
            }
        }
    }
}

