/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.basex.core.AProp;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.CommandParser;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.data.Data;
import org.basex.data.Namespaces;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.gui.AGUI;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIInput;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIProp;
import org.basex.gui.GUIStatus;
import org.basex.gui.GUIToolBar;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogHelp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorView;
import org.basex.gui.view.explore.ExploreView;
import org.basex.gui.view.folder.FolderView;
import org.basex.gui.view.info.InfoView;
import org.basex.gui.view.map.MapView;
import org.basex.gui.view.plot.PlotView;
import org.basex.gui.view.table.TableView;
import org.basex.gui.view.text.TextView;
import org.basex.gui.view.tree.TreeView;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class GUI
extends AGUI {
    public final ViewNotifier notify;
    public final GUIStatus status;
    public final GUIInput input;
    public final BaseXButton filter;
    public final EditorView editor;
    public final InfoView info;
    public boolean painting;
    public boolean updating;
    public boolean fullscreen;
    public DialogHelp help;
    public final GUIMenu menu;
    public final BaseXBack buttons;
    public final BaseXBack nav;
    final ViewContainer views;
    final BaseXButton hist;
    final BaseXCombo mode;
    private final TextView text;
    private final BaseXBack top;
    private final BaseXButton go;
    private final BaseXBack control;
    private final BaseXLabel hits;
    private final GUIToolBar toolbar;
    private Command command;
    private int menuHeight;
    private JFrame fullscr;
    private int threadID;

    public GUI(Context ctx, GUIProp gprops) {
        super(ctx, gprops);
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int[] ps = this.gprop.nums(GUIProp.GUILOC);
        int[] sz = this.gprop.nums(GUIProp.GUISIZE);
        int x = Math.max(0, Math.min(scr.width - sz[0], ps[0]));
        int y = Math.max(0, Math.min(scr.height - sz[1], ps[1]));
        this.setBounds(x, y, sz[0], sz[1]);
        if (this.gprop.is(GUIProp.MAXSTATE)) {
            this.setExtendedState(2);
            this.setExtendedState(4);
            this.setExtendedState(6);
        }
        this.top = new BaseXBack(new BorderLayout());
        this.control = new BaseXBack(new BorderLayout());
        this.menu = new GUIMenu(this);
        if (this.gprop.is(GUIProp.SHOWMENU)) {
            this.setJMenuBar(this.menu);
        }
        this.buttons = new BaseXBack(new BorderLayout());
        this.toolbar = new GUIToolBar(GUIConstants.TOOLBAR, this);
        this.buttons.add((Component)this.toolbar, "West");
        this.hits = new BaseXLabel(" ");
        this.hits.setFont(this.hits.getFont().deriveFont(18.0f));
        BaseXLayout.setWidth(this.hits, 150);
        this.hits.setHorizontalAlignment(4);
        BaseXBack b = new BaseXBack();
        b.add(this.hits);
        this.buttons.add((Component)b, "East");
        if (this.gprop.is(GUIProp.SHOWBUTTONS)) {
            this.control.add((Component)this.buttons, "Center");
        }
        this.nav = new BaseXBack(new BorderLayout(5, 0)).border(2, 2, 0, 2);
        this.mode = new BaseXCombo(this, Text.BUTTONSEARCH, Text.BUTTONXQUERY, Text.BUTTONCMD);
        this.mode.setSelectedIndex(2);
        this.mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int s = GUI.this.mode.getSelectedIndex();
                if (s == GUI.this.gprop.num(GUIProp.SEARCHMODE) || !GUI.this.mode.isEnabled()) {
                    return;
                }
                GUI.this.gprop.set(GUIProp.SEARCHMODE, s);
                GUI.this.input.setText("");
                GUI.this.refreshControls();
            }
        });
        this.nav.add((Component)this.mode, "West");
        this.input = new GUIInput(this);
        this.hist = new BaseXButton(this, "hist", Text.HELPHIST);
        this.hist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] hs;
                final JPopupMenu pop = new JPopupMenu();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        (this).GUI.this.input.setText(ac.getActionCommand());
                        (this).GUI.this.input.requestFocusInWindow();
                        pop.setVisible(false);
                    }
                };
                int i = GUI.this.context.data == null ? 2 : GUI.this.gprop.num(GUIProp.SEARCHMODE);
                String[] stringArray = hs = GUI.this.gprop.strings(i == 0 ? GUIProp.SEARCH : (i == 1 ? GUIProp.XQUERY : GUIProp.COMMANDS));
                int n = hs.length;
                int n2 = 0;
                while (n2 < n) {
                    String en = stringArray[n2];
                    JMenuItem jmi = new JMenuItem(en);
                    jmi.addActionListener(al);
                    pop.add(jmi);
                    ++n2;
                }
                pop.show(GUI.this.hist, 0, GUI.this.hist.getHeight());
            }
        });
        b = new BaseXBack(new BorderLayout(5, 0));
        b.add((Component)this.hist, "West");
        b.add((Component)this.input, "Center");
        this.nav.add((Component)b, "Center");
        this.go = new BaseXButton(this, "go", Text.HELPGO);
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.execute();
            }
        });
        this.filter = BaseXButton.command(GUICommands.FILTER, this);
        b = new BaseXBack(new TableLayout(1, 3));
        b.add(this.go);
        b.add(Box.createHorizontalStrut(1));
        b.add(this.filter);
        this.nav.add((Component)b, "East");
        if (this.gprop.is(GUIProp.SHOWINPUT)) {
            this.control.add((Component)this.nav, "South");
        }
        this.top.add((Component)this.control, "North");
        this.notify = new ViewNotifier(this);
        this.text = new TextView(this.notify);
        this.editor = new EditorView(this.notify);
        this.info = new InfoView(this.notify);
        this.views = new ViewContainer(this, this.text, this.editor, this.info, new FolderView(this.notify), new PlotView(this.notify), new TableView(this.notify), new MapView(this.notify), new TreeView(this.notify), new ExploreView(this.notify));
        this.top.add((Component)this.views, "Center");
        this.setContentBorder();
        this.status = new GUIStatus(this);
        if (this.gprop.is(GUIProp.SHOWSTATUS)) {
            this.top.add((Component)this.status, "South");
        }
        this.setDefaultCloseOperation(2);
        this.add(this.top);
        this.setVisible(true);
        this.views.updateViews();
        this.refreshControls();
        new Thread(){

            @Override
            public void run() {
                GUI.this.views.run();
            }
        }.start();
        this.input.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        if (!this.editor.confirm()) {
            return;
        }
        boolean max = this.getExtendedState() == 6;
        this.gprop.set(GUIProp.MAXSTATE, max);
        if (!max) {
            this.gprop.set(GUIProp.GUILOC, new int[]{this.getX(), this.getY()});
            this.gprop.set(GUIProp.GUISIZE, new int[]{this.getWidth(), this.getHeight()});
        }
        super.dispose();
        this.gprop.write();
        this.context.close();
    }

    void execute() {
        boolean cmd;
        String in = this.input.getText().trim();
        boolean bl = cmd = this.mode.getSelectedIndex() == 2;
        if (cmd || in.startsWith("!")) {
            int i;
            int n = i = cmd ? 0 : 1;
            if (i == in.length()) {
                return;
            }
            try {
                this.execute(true, new CommandParser(in.substring(i), this.context).parse());
            }
            catch (QueryException ex) {
                if (!this.info.visible()) {
                    GUICommands.SHOWINFO.execute(this);
                }
                this.info.setInfo(ex.getMessage(), null, null, false);
                this.info.reset();
            }
        } else if (this.gprop.num(GUIProp.SEARCHMODE) == 1 || in.startsWith("/")) {
            this.xquery(in, true);
        } else {
            String qu = Find.find(in, this.context, this.gprop.is(GUIProp.FILTERRT));
            this.execute(true, new XQuery(qu));
        }
    }

    public void xquery(String qu, boolean main) {
        Namespaces ns = this.context.data.ns;
        String in = qu.trim().isEmpty() ? "()" : qu;
        int u = ns.uri(Token.EMPTY, 0);
        if (u != 0) {
            in = Util.info("declare default element namespace \"%\"; %", ns.uri(u), in);
        }
        this.execute(main, new XQuery(in));
    }

    public void execute(Command cmd) {
        this.execute(true, cmd);
    }

    public void execute(final boolean main, final Command ... cmd) {
        if (this.updating) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Command[] commandArray = cmd;
                int n = cmd.length;
                int n2 = 0;
                while (n2 < n) {
                    Command c = commandArray[n2];
                    if (!GUI.this.exec(c, main)) break;
                    ++n2;
                }
            }
        }.start();
    }

    boolean exec(Command c, boolean main) {
        boolean ok;
        block27: {
            Result result;
            String time;
            block28: {
                Nodes nodes;
                String inf;
                boolean up;
                ArrayOutput ao;
                Nodes current;
                Data data;
                Performance perf;
                int thread;
                block26: {
                    thread = ++this.threadID;
                    while (this.command != null) {
                        this.command.stop();
                        Performance.sleep(50L);
                        if (this.threadID == thread) continue;
                        return true;
                    }
                    this.cursor(GUIConstants.CURSORWAIT);
                    ok = true;
                    perf = new Performance();
                    data = this.context.data;
                    if (this.gprop.is(GUIProp.FILTERRT) && this.context.current != null && !this.context.root()) {
                        this.context.current = new Nodes(data.doc().toArray(), data).checkRoot();
                    }
                    current = this.context.current;
                    this.command = c;
                    ao = new ArrayOutput().max(this.gprop.num(GUIProp.MAXTEXT));
                    this.updating = up = c.updating(this.context);
                    if (this.editor.visible()) {
                        if (main) {
                            this.editor.reset();
                        } else if (c instanceof XQuery) {
                            this.editor.start();
                        }
                    }
                    inf = null;
                    try {
                        try {
                            c.execute(this.context, ao);
                            inf = c.info();
                        }
                        catch (BaseXException ex) {
                            ok = false;
                            inf = ex.getMessage();
                            this.updating = false;
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        this.updating = false;
                        throw throwable;
                    }
                    this.updating = false;
                }
                time = perf.getTimer();
                this.info.setInfo(inf, c, time, ok);
                this.info.reset();
                boolean feedback = main;
                if (!main && this.editor.visible() && c instanceof XQuery) {
                    this.editor.info(inf.startsWith("Interrupted.") ? "Interrupted." : inf, ok);
                    feedback = true;
                }
                if (!ok) {
                    if (!feedback && !this.info.visible()) {
                        GUICommands.SHOWINFO.execute(this);
                    }
                    break block27;
                }
                result = c.result();
                Nodes nodes2 = nodes = result instanceof Nodes && ((Nodes)result).size() != 0L ? (Nodes)result : null;
                if (nodes == null) {
                    if (!this.text.visible()) {
                        GUICommands.SHOWTEXT.execute(this);
                    }
                    this.text.setText(ao, c);
                }
                Data ndata = this.context.data;
                Nodes marked = this.context.marked;
                if (ndata != data) {
                    this.notify.init();
                    break block28;
                }
                if (up) {
                    this.notify.update();
                    break block28;
                }
                if (result == null) break block28;
                Nodes nd = this.context.current;
                boolean flt = this.gprop.is(GUIProp.FILTERRT);
                if (flt || nd != null && !nd.sameAs(current)) {
                    if (nodes != null) {
                        this.notify.context((Nodes)result, flt, null);
                    }
                    break block28;
                }
                if (marked == null) break block28;
                if (nodes != null) {
                    marked = nodes;
                } else if (marked.size() != 0L) {
                    marked = new Nodes(data);
                }
                this.notify.mark(marked, null);
                if (thread == this.threadID) break block28;
                this.command = null;
                return true;
            }
            try {
                this.setHits(result == null ? 0L : result.size());
                this.status.setText(Util.info(Text.PROCTIME, time));
            }
            catch (Exception ex) {
                Util.stack(ex);
                Dialog.error(this, Util.info(Text.PROCERR, c, !ex.toString().isEmpty() ? ex.toString() : ex.getMessage()));
                this.updating = false;
            }
        }
        this.cursor(GUIConstants.CURSORARROW, true);
        this.command = null;
        return ok;
    }

    public void stop() {
        if (this.command != null) {
            this.command.stop();
        }
        this.cursor(GUIConstants.CURSORARROW, true);
        this.command = null;
    }

    public void set(Object[] pr, Object val) {
        this.set(this.context.prop, pr, val);
    }

    public void setMain(Object[] pr, Object val) {
        this.set(this.context.mprop, pr, val);
    }

    private void set(AProp prop, Object[] pr, Object val) {
        if (!prop.sameAs(pr, val)) {
            Set cmd = new Set(pr, val);
            cmd.run(this.context);
            this.info.setInfo(cmd.info(), cmd, null, true);
        }
    }

    private void setContentBorder() {
        int n = this.control.getComponentCount();
        int n2 = this.top.getComponentCount();
        if (n == 0 && n2 == 2) {
            this.views.border(0, 0, 0, 0);
        } else {
            this.views.setBorder(new CompoundBorder(new EmptyBorder(3, 1, 3, 1), new EtchedBorder()));
        }
    }

    public void updateLayout() {
        GUIConstants.init(this.gprop);
        this.notify.layout();
        this.views.repaint();
    }

    public void updateControl(JComponent comp, boolean show, String layout) {
        if (comp == this.status) {
            if (!show) {
                this.top.remove(comp);
            } else {
                this.top.add((Component)comp, layout);
            }
        } else if (comp == this.menu) {
            if (!show) {
                this.menuHeight = this.menu.getHeight();
            }
            int s = show ? this.menuHeight : 0;
            BaseXLayout.setHeight(this.menu, s);
            this.menu.setSize(this.menu.getWidth(), s);
        } else if (!show) {
            this.control.remove(comp);
        } else {
            this.control.add((Component)comp, layout);
        }
        this.setContentBorder();
        (this.fullscr == null ? this.getRootPane() : this.fullscr).validate();
        this.refreshControls();
    }

    public void layoutViews() {
        this.views.updateViews();
        this.refreshControls();
        this.repaint();
    }

    public void refreshControls() {
        int i;
        int s;
        Nodes marked = this.context.marked;
        if (marked != null) {
            this.setHits(marked.size());
        }
        this.filter.setEnabled(marked != null && marked.size() != 0L);
        boolean inf = this.gprop.is(GUIProp.SHOWINFO);
        this.context.prop.set(Prop.QUERYINFO, inf);
        this.context.prop.set(Prop.XMLPLAN, inf);
        Data data = this.context.data;
        int t = this.mode.getSelectedIndex();
        int n = s = data == null ? 2 : this.gprop.num(GUIProp.SEARCHMODE);
        this.input.help(s == 0 ? Text.HELPSEARCHXML : (s == 1 ? Text.HELPXPATH : Text.HELPCMD));
        this.mode.setEnabled(data != null);
        this.go.setEnabled(s == 2 || !this.gprop.is(GUIProp.EXECRT));
        if (s != t) {
            this.mode.setSelectedIndex(s);
            this.input.setText("");
            this.input.requestFocusInWindow();
        }
        this.toolbar.refresh();
        this.menu.refresh();
        int n2 = i = this.context.data == null ? 2 : this.gprop.num(GUIProp.SEARCHMODE);
        String[] hs = i == 0 ? this.gprop.strings(GUIProp.SEARCH) : (i == 1 ? this.gprop.strings(GUIProp.XQUERY) : this.gprop.strings(GUIProp.COMMANDS));
        this.hist.setEnabled(hs.length != 0);
    }

    private void setHits(long n) {
        this.hits.setText(String.valueOf(n) + " " + Text.HITS);
    }

    public void fullscreen() {
        this.fullscreen ^= true;
        this.fullscreen(this.fullscreen);
    }

    public void fullscreen(boolean full) {
        if (full ^ this.fullscr == null) {
            if (!this.gprop.is(GUIProp.SHOWMENU)) {
                GUICommands.SHOWMENU.execute(this);
            }
            return;
        }
        if (full) {
            this.control.remove(this.buttons);
            this.control.remove(this.nav);
            this.getRootPane().remove(this.menu);
            this.top.remove(this.status);
            this.remove(this.top);
            this.fullscr = new JFrame();
            this.fullscr.setIconImage(this.getIconImage());
            this.fullscr.setTitle(this.getTitle());
            this.fullscr.setUndecorated(true);
            this.fullscr.setJMenuBar(this.menu);
            this.fullscr.add(this.top);
            this.fullscr.setDefaultCloseOperation(2);
        } else {
            this.fullscr.removeAll();
            this.fullscr.dispose();
            this.fullscr = null;
            if (!this.gprop.is(GUIProp.SHOWBUTTONS)) {
                this.control.add((Component)this.buttons, "Center");
            }
            if (!this.gprop.is(GUIProp.SHOWINPUT)) {
                this.control.add((Component)this.nav, "South");
            }
            if (!this.gprop.is(GUIProp.SHOWSTATUS)) {
                this.top.add((Component)this.status, "South");
            }
            this.setJMenuBar(this.menu);
            this.add(this.top);
        }
        this.gprop.set(GUIProp.SHOWMENU, !full);
        this.gprop.set(GUIProp.SHOWBUTTONS, !full);
        this.gprop.set(GUIProp.SHOWINPUT, !full);
        this.gprop.set(GUIProp.SHOWSTATUS, !full);
        this.fullscreen = full;
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.fullscr);
        this.setContentBorder();
        this.refreshControls();
        this.updateControl(this.menu, !full, "North");
        this.setVisible(!full);
    }
}

