/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.util.Util;

public final class Close
extends Command {
    public Close() {
        super(256, new String[0]);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data;
        if (data == null) {
            return true;
        }
        try {
            Close.close(data, this.context);
            this.context.closeDB();
            return this.info(Text.DBCLOSED, data.meta.name);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Text.DBCLOSEERR, data.meta.name);
        }
    }

    public static synchronized void close(Data data, Context ctx) throws IOException {
        if (ctx.unpin(data)) {
            data.close();
        }
    }
}

