/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.core.cmd.Open;

public final class AlterDB
extends Command {
    private boolean closed;

    public AlterDB(String db, String name) {
        super(4, db, name);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        String name = this.args[1];
        if (!AlterDB.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        if (!AlterDB.validName(name, false)) {
            return this.error(Text.NAMEINVALID, name);
        }
        if (!this.mprop.dbexists(db)) {
            return this.error(Text.DBNOTFOUND, db);
        }
        if (this.mprop.dbexists(name)) {
            return this.error(Text.DBEXISTS, name);
        }
        if (!this.closed) {
            this.closed = AlterDB.close(this.context, db);
        }
        if (this.context.pinned(db)) {
            return this.error(Text.DBLOCKED, db);
        }
        return AlterDB.alter(db, name, this.mprop) && (!this.closed || new Open(name).run(this.context)) ? this.info(Text.DBALTERED, db, name) : this.error(Text.DBNOTALTERED, db);
    }

    public static synchronized boolean alter(String db, String dbnew, MainProp pr) {
        return pr.dbpath(db).renameTo(pr.dbpath(dbnew));
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = AlterDB.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.ALTER) + " " + (Object)((Object)Commands.CmdAlter.DB)).args();
    }
}

