/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class Users {
    private final List<User> list;
    private File file;

    public Users(boolean global) {
        block15: {
            this.list = Collections.synchronizedList(new ArrayList(0));
            if (!global) {
                return;
            }
            this.file = new File(Prop.HOME, ".basexperm");
            if (!this.file.exists()) {
                this.list.add(new User("admin", Token.token(Token.md5("admin")), 8));
            } else {
                DataInput in = null;
                try {
                    try {
                        in = new DataInput(this.file);
                        this.read(in);
                    }
                    catch (IOException ex) {
                        Util.errln(ex, new Object[0]);
                        if (in == null) break block15;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public synchronized void read(DataInput in) throws IOException {
        int s = in.readNum();
        int u = 0;
        while (u < s) {
            User user = new User(Token.string(in.readBytes()), in.readBytes(), in.readNum());
            this.list.add(user);
            ++u;
        }
    }

    public synchronized void write() {
        if (this.file == null) {
            return;
        }
        try {
            DataOutput out = new DataOutput(this.file);
            this.write(out);
            out.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    public synchronized boolean create(String usern, String pass) {
        return this.get(usern) == null && this.create(new User(usern, Token.token(pass), 2));
    }

    public synchronized boolean create(User user) {
        this.list.add(user);
        this.write();
        return true;
    }

    public synchronized boolean alter(String usern, String pass) {
        User user = this.get(usern);
        if (user == null) {
            return false;
        }
        user.password = Token.token(pass);
        this.write();
        return true;
    }

    public synchronized boolean drop(User user) {
        if (!this.list.remove(user)) {
            return false;
        }
        this.write();
        return true;
    }

    public synchronized User get(String usern) {
        for (User user : this.list) {
            if (!user.name.equals(usern)) continue;
            return user;
        }
        return null;
    }

    public synchronized String[] find(Pattern pattern) {
        StringList sl = new StringList();
        for (User u : this.list) {
            if (!pattern.matcher(u.name).matches()) continue;
            sl.add(u.name);
        }
        return sl.toArray();
    }

    public synchronized void write(DataOutput out) throws IOException {
        out.writeNum(this.list.size());
        for (User user : this.list) {
            out.writeString(user.name);
            out.writeToken(user.password);
            out.writeNum(user.perm);
        }
    }

    public synchronized byte[] info(Users users) {
        Table table = new Table();
        table.description = Text.USERS;
        int sz = this.file == null ? 3 : 5;
        int u = 0;
        while (u < sz) {
            table.header.add(Text.USERHEAD[u]);
            ++u;
        }
        for (User user : this.list) {
            if (users != null && users.get(user.name) == null) continue;
            TokenList tl = new TokenList();
            tl.add(user.name);
            tl.add(user.perm(1) ? "X" : "");
            tl.add(user.perm(2) ? "X" : "");
            if (sz == 5) {
                tl.add(user.perm(4) ? "X" : "");
                tl.add(user.perm(8) ? "X" : "");
            }
            table.contents.add(tl);
        }
        table.sort();
        table.toTop(Token.token("admin"));
        return table.finish();
    }
}

