/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class SAXHandler
extends DefaultHandler
implements LexicalHandler {
    private final Atts atts = new Atts();
    private final Builder builder;
    private boolean dtd;
    int nodes;
    private final TokenBuilder tb = new TokenBuilder();
    private final StringBuilder sb = new StringBuilder();
    private final Atts ns = new Atts();

    static {
        System.setProperty("entityExpansionLimit", "536870912");
        System.setProperty("http.agent", "sax");
    }

    SAXHandler(Builder build) {
        this.builder = build;
    }

    @Override
    public void startElement(String uri, String ln, String qn, Attributes at) throws SAXException {
        try {
            this.finishText();
            int as = at.getLength();
            this.atts.reset();
            int a = 0;
            while (a < as) {
                this.atts.add(Token.token(at.getQName(a)), Token.token(at.getValue(a)));
                ++a;
            }
            this.builder.startElem(Token.token(qn), this.atts);
            ++this.nodes;
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }

    @Override
    public void endElement(String uri, String ln, String qn) throws SAXException {
        try {
            this.finishText();
            this.builder.endElem(Token.token(qn));
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }

    @Override
    public void characters(char[] ch, int s, int l) {
        int e = s + l;
        int i = s;
        while (i < e) {
            char c = ch[i];
            if (this.sb.length() != 0 || Character.isHighSurrogate(c)) {
                this.sb.append(c);
            } else {
                this.tb.add(c);
            }
            ++i;
        }
    }

    @Override
    public void processingInstruction(String nm, String cont) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.pi(Token.token(String.valueOf(nm) + ' ' + cont));
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }

    @Override
    public void comment(char[] ch, int s, int l) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.comment(Token.token(new String(ch, s, l)));
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }

    private void finishText() throws IOException {
        boolean sur;
        boolean bl = sur = this.sb.length() != 0;
        if (this.tb.size() != 0 || sur) {
            if (sur) {
                this.tb.add(Token.token(this.sb.toString()));
                this.sb.setLength(0);
            }
            this.builder.text(this.tb.finish());
            this.tb.reset();
        }
        int i = 0;
        while (i < this.ns.size) {
            this.builder.startNS(this.ns.key[i], this.ns.val[i]);
            ++i;
        }
        this.ns.reset();
    }

    private void error(IOException ex) throws SAXException {
        SAXException ioe = new SAXException(ex.getMessage());
        ioe.setStackTrace(ex.getStackTrace());
        throw ioe;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.ns.add(Token.token(prefix), Token.token(uri));
    }

    @Override
    public void startDTD(String n, String pid, String sid) {
        this.dtd = true;
    }

    @Override
    public void endDTD() {
        this.dtd = false;
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endEntity(String n) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startEntity(String n) {
    }
}

