/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recorder<T>
extends HiddenField<Object> {
    private static final long serialVersionUID = 1L;
    private final List<String> selectedIds;
    private final Palette<T> palette;
    private boolean attached = false;

    public Palette<T> getPalette() {
        return this.palette;
    }

    protected List<String> getSelectedIds() {
        return this.selectedIds;
    }

    public Recorder(String id, Palette<T> palette) {
        super(id);
        this.palette = palette;
        this.selectedIds = new ArrayList<String>();
        this.setDefaultModel((IModel)new Model());
        this.setOutputMarkupId(true);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.getForm().hasError()) {
            this.initIds();
        }
        this.attached = true;
    }

    private void initIds() {
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        StringBuilder modelStringBuffer = new StringBuilder();
        Collection<T> modelCollection = this.getPalette().getModelCollection();
        if (modelCollection == null) {
            throw new WicketRuntimeException("Expected getPalette().getModelCollection() to return a non-null value. Please make sure you have model object assigned to the palette");
        }
        Iterator<T> selection = modelCollection.iterator();
        int i = 0;
        while (selection.hasNext()) {
            modelStringBuffer.append(renderer.getIdValue(selection.next(), i++));
            if (!selection.hasNext()) continue;
            modelStringBuffer.append(",");
        }
        String modelString = modelStringBuffer.toString();
        this.setDefaultModel((IModel)new Model((Serializable)((Object)modelString)));
        this.updateIds(modelString);
    }

    protected void onValid() {
        super.onValid();
        if (this.attached) {
            this.updateIds();
        }
    }

    private List<T> getSelectedList() {
        if (this.getSelectedIds().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        ArrayList<T> selected = new ArrayList<T>(this.getSelectedIds().size());
        Collection<T> choices = this.getPalette().getChoices();
        HashMap<T, String> idForChoice = new HashMap<T, String>(choices.size());
        for (T choice : choices) {
            idForChoice.put(choice, renderer.getIdValue(choice, 0));
        }
        block1: for (String id : this.getSelectedIds()) {
            for (T choice : choices) {
                String idValue = (String)idForChoice.get(choice);
                if (!id.equals(idValue)) continue;
                selected.add(choice);
                continue block1;
            }
        }
        return selected;
    }

    public Iterator<T> getSelectedChoices() {
        return this.getSelectedList().iterator();
    }

    private List<T> getUnselectedList() {
        Collection<T> choices = this.getPalette().getChoices();
        if (choices.size() - this.getSelectedIds().size() == 0) {
            return Collections.emptyList();
        }
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        ArrayList<T> unselected = new ArrayList<T>(Math.max(1, choices.size() - this.getSelectedIds().size()));
        for (T choice : choices) {
            String choiceId = renderer.getIdValue(choice, 0);
            if (this.getSelectedIds().contains(choiceId)) continue;
            unselected.add(choice);
        }
        return unselected;
    }

    public Iterator<T> getUnselectedChoices() {
        return this.getUnselectedList().iterator();
    }

    protected void onInvalid() {
        super.onInvalid();
        if (this.attached) {
            this.updateIds();
        }
    }

    private void updateIds() {
        this.updateIds(this.getValue());
    }

    private void updateIds(String value) {
        this.getSelectedIds().clear();
        for (String id : Strings.split((String)value, (char)',')) {
            this.getSelectedIds().add(id);
        }
    }
}

