/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.common.expression.ExpressionFactory;
import com.evolveum.midpoint.common.valueconstruction.AsIsValueConstructor;
import com.evolveum.midpoint.common.valueconstruction.ExpressionValueConstructor;
import com.evolveum.midpoint.common.valueconstruction.GenerateValueConstructor;
import com.evolveum.midpoint.common.valueconstruction.LiteralValueConstructor;
import com.evolveum.midpoint.common.valueconstruction.PathValueConstructor;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructor;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public class ValueConstructionFactory {
    ObjectFactory objectFactory = new ObjectFactory();
    private Map<QName, ValueConstructor> constructors = null;
    private ExpressionFactory expressionFactory;
    private ObjectResolver objectResolver;
    private Protector protector;
    private PrismContext prismContext;

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public Protector getProtector() {
        return this.protector;
    }

    public void setProtector(Protector protector) {
        this.protector = protector;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver objectResolver) {
        this.objectResolver = objectResolver;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    private void initialize() {
        this.constructors = new HashMap<QName, ValueConstructor>();
        this.createLiteralConstructor();
        this.createAsIsConstructor();
        this.createPathConstructor();
        this.createExpressionConstructor();
        this.createGenerateConstructor();
    }

    private void createLiteralConstructor() {
        LiteralValueConstructor constructor = new LiteralValueConstructor();
        JAXBElement element = this.objectFactory.createValue(null);
        this.constructors.put(element.getName(), constructor);
    }

    private void createAsIsConstructor() {
        AsIsValueConstructor constructor = new AsIsValueConstructor(this.prismContext);
        JAXBElement element = this.objectFactory.createAsIs(this.objectFactory.createAsIsValueConstructorType());
        this.constructors.put(element.getName(), constructor);
        this.constructors.put(null, constructor);
    }

    private void createPathConstructor() {
        PathValueConstructor constructor = new PathValueConstructor(this.objectResolver, this.prismContext);
        JAXBElement element = this.objectFactory.createPath(new Object());
        this.constructors.put(element.getName(), constructor);
    }

    private void createExpressionConstructor() {
        ExpressionValueConstructor constructor = new ExpressionValueConstructor(this.expressionFactory);
        JAXBElement element = this.objectFactory.createExpression(this.objectFactory.createExpressionType());
        this.constructors.put(element.getName(), constructor);
    }

    private void createGenerateConstructor() {
        GenerateValueConstructor constructor = new GenerateValueConstructor(this.protector);
        JAXBElement element = this.objectFactory.createGenerate(this.objectFactory.createGenerateValueConstructorType());
        this.constructors.put(element.getName(), constructor);
    }

    public <V extends PrismValue> ValueConstruction<V> createValueConstruction(ValueConstructionType valueConstructionType, ItemDefinition outputDefinition, String shortDesc) {
        if (this.constructors == null) {
            this.initialize();
        }
        ValueConstruction construction = new ValueConstruction(valueConstructionType, outputDefinition, shortDesc, this.constructors, this.expressionFactory);
        return construction;
    }

    public <V extends PrismValue> ValueConstruction<V> createDefaultValueConstruction(ItemDefinition outputDefinition, String shortDesc) {
        if (this.constructors == null) {
            this.initialize();
        }
        ValueConstruction construction = new ValueConstruction(null, outputDefinition, shortDesc, this.constructors, this.expressionFactory);
        return construction;
    }
}

