/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructor;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.RandomString;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.GenerateValueConstructorType;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public class GenerateValueConstructor
implements ValueConstructor {
    private static final int DEFAULT_LENGTH = 8;
    private Protector protector;

    GenerateValueConstructor(Protector protector) {
        this.protector = protector;
    }

    @Override
    public <V extends PrismValue> PrismValueDeltaSetTriple<V> construct(JAXBElement<?> constructorElement, ItemDefinition outputDefinition, Item<V> input, ItemDelta<V> inputDelta, Map<QName, Object> variables, boolean conditionResultOld, boolean conditionResultNew, String contextDescription, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        Item output;
        String stringValue;
        Object constructorTypeObject = constructorElement.getValue();
        if (!(constructorTypeObject instanceof GenerateValueConstructorType)) {
            throw new IllegalArgumentException("Generate value constructor cannot handle elements of type " + constructorTypeObject.getClass().getName());
        }
        GenerateValueConstructorType constructorType = (GenerateValueConstructorType)constructorTypeObject;
        QName outputType = outputDefinition.getTypeName();
        if (!outputType.equals(DOMUtil.XSD_STRING) && !outputType.equals(SchemaConstants.R_PROTECTED_STRING_TYPE)) {
            throw new IllegalArgumentException("Generate value constructor cannot generate values for properties of type " + outputType);
        }
        int length = 8;
        if (constructorType.getLength() != null) {
            length = constructorType.getLength();
        }
        RandomString randomString = new RandomString(length);
        String value = stringValue = randomString.nextString();
        if (outputType.equals(SchemaConstants.R_PROTECTED_STRING_TYPE)) {
            try {
                value = this.protector.encryptString(stringValue);
            }
            catch (EncryptionException e) {
                throw new ExpressionEvaluationException("Crypto error: " + e.getMessage(), (Throwable)e);
            }
        }
        if (!((output = outputDefinition.instantiate()) instanceof PrismProperty)) {
            throw new UnsupportedOperationException("Can only generate values of property, not " + output.getClass());
        }
        PrismPropertyValue pValue = new PrismPropertyValue((Object)value);
        ((PrismProperty)output).add((PrismValue)pValue);
        return ItemDelta.toDeltaSetTriple((Item)output, null, (boolean)conditionResultOld, (boolean)conditionResultNew);
    }
}

