/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.refinery;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SchemaHandlingType;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class RefinedResourceSchema
extends PrismSchema
implements Dumpable,
DebugDumpable {
    private static final String USER_DATA_KEY_PARSED_RESOURCE_SCHEMA = String.valueOf(RefinedResourceSchema.class.getName()) + ".parsedResourceSchema";
    private static final String USER_DATA_KEY_REFINED_SCHEMA = String.valueOf(RefinedResourceSchema.class.getName()) + ".refinedSchema";
    private ResourceSchema originalResourceSchema;

    private RefinedResourceSchema(ResourceType resourceType, ResourceSchema originalResourceSchema, PrismContext prismContext) {
        super(ResourceTypeUtil.getResourceNamespace((ResourceType)resourceType), prismContext);
        this.originalResourceSchema = originalResourceSchema;
    }

    public Collection<RefinedAccountDefinition> getAccountDefinitions() {
        HashSet<RefinedAccountDefinition> accounts = new HashSet<RefinedAccountDefinition>();
        for (Definition def : this.definitions) {
            if (!(def instanceof RefinedAccountDefinition)) continue;
            RefinedAccountDefinition rad = (RefinedAccountDefinition)def;
            accounts.add(rad);
        }
        return accounts;
    }

    public ResourceSchema getOriginalResourceSchema() {
        return this.originalResourceSchema;
    }

    public RefinedAccountDefinition getAccountDefinition(String accountType) {
        for (RefinedAccountDefinition acctDef : this.getAccountDefinitions()) {
            if (accountType == null && acctDef.isDefault()) {
                return acctDef;
            }
            if (!acctDef.getAccountTypeName().equals(accountType)) continue;
            return acctDef;
        }
        return null;
    }

    public RefinedAccountDefinition getDefaultAccountDefinition() {
        return this.getAccountDefinition(null);
    }

    public PrismObjectDefinition<AccountShadowType> getObjectDefinition(String accountType) {
        return this.getAccountDefinition(accountType).getObjectDefinition();
    }

    public PrismObjectDefinition<AccountShadowType> getObjectDefinition(AccountShadowType shadow) {
        return this.getObjectDefinition(shadow.getAccountType());
    }

    private void add(RefinedAccountDefinition refinedAccountDefinition) {
        this.definitions.add(refinedAccountDefinition);
    }

    public RefinedAccountDefinition findAccountDefinitionByObjectClass(QName objectClass) {
        if (objectClass == null) {
            return this.getDefaultAccountDefinition();
        }
        for (RefinedAccountDefinition acctDef : this.getAccountDefinitions()) {
            if (!acctDef.getObjectClassDefinition().getTypeName().equals(objectClass)) continue;
            return acctDef;
        }
        return null;
    }

    private ObjectClassComplexTypeDefinition findObjectClassDefinition(QName objectClassQName) {
        return this.originalResourceSchema.findObjectClassDefinition(objectClassQName);
    }

    public static RefinedResourceSchema getRefinedSchema(ResourceType resourceType, PrismContext prismContext) throws SchemaException {
        PrismObject resource = resourceType.asPrismObject();
        return RefinedResourceSchema.getRefinedSchema((PrismObject<ResourceType>)resource, prismContext);
    }

    public static RefinedResourceSchema getRefinedSchema(PrismObject<ResourceType> resource, PrismContext prismContext) throws SchemaException {
        Object userDataEntry = resource.getUserData(USER_DATA_KEY_REFINED_SCHEMA);
        if (userDataEntry != null) {
            if (userDataEntry instanceof RefinedResourceSchema) {
                return (RefinedResourceSchema)((Object)userDataEntry);
            }
            throw new IllegalStateException("Expected RefinedResourceSchema under user data key " + USER_DATA_KEY_REFINED_SCHEMA + "in " + resource + ", but got " + userDataEntry.getClass());
        }
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.parse(resource, prismContext);
        resource.setUserData(USER_DATA_KEY_REFINED_SCHEMA, (Object)refinedSchema);
        return refinedSchema;
    }

    public static boolean hasRefinedSchema(ResourceType resourceType) {
        PrismObject resource = resourceType.asPrismObject();
        return resource.getUserData(USER_DATA_KEY_REFINED_SCHEMA) != null;
    }

    public static ResourceSchema getResourceSchema(ResourceType resourceType, PrismContext prismContext) throws SchemaException {
        PrismObject resource = resourceType.asPrismObject();
        return RefinedResourceSchema.getResourceSchema((PrismObject<ResourceType>)resource, prismContext);
    }

    public static ResourceSchema getResourceSchema(PrismObject<ResourceType> resource, PrismContext prismContext) throws SchemaException {
        Element resourceXsdSchema = ResourceTypeUtil.getResourceXsdSchema(resource);
        if (resourceXsdSchema == null) {
            return null;
        }
        Object userDataEntry = resource.getUserData(USER_DATA_KEY_PARSED_RESOURCE_SCHEMA);
        if (userDataEntry != null) {
            if (userDataEntry instanceof ResourceSchema) {
                return (ResourceSchema)userDataEntry;
            }
            throw new IllegalStateException("Expected ResourceSchema under user data key " + USER_DATA_KEY_PARSED_RESOURCE_SCHEMA + "in " + resource + ", but got " + userDataEntry.getClass());
        }
        ResourceSchema parsedSchema = ResourceSchema.parse((Element)resourceXsdSchema, (String)("resource schema of " + resource), (PrismContext)prismContext);
        if (parsedSchema == null) {
            throw new IllegalStateException("Parsed schema is null: most likely an internall error");
        }
        resource.setUserData(USER_DATA_KEY_PARSED_RESOURCE_SCHEMA, (Object)parsedSchema);
        return parsedSchema;
    }

    public static void setParsedResourceSchemaConditional(ResourceType resourceType, ResourceSchema parsedSchema) {
        if (RefinedResourceSchema.hasParsedSchema(resourceType)) {
            return;
        }
        PrismObject resource = resourceType.asPrismObject();
        resource.setUserData(USER_DATA_KEY_PARSED_RESOURCE_SCHEMA, (Object)parsedSchema);
    }

    public static boolean hasParsedSchema(ResourceType resourceType) {
        PrismObject resource = resourceType.asPrismObject();
        return resource.getUserData(USER_DATA_KEY_PARSED_RESOURCE_SCHEMA) != null;
    }

    public static RefinedResourceSchema parse(PrismObject<ResourceType> resource, PrismContext prismContext) throws SchemaException {
        return RefinedResourceSchema.parse((ResourceType)resource.asObjectable(), prismContext);
    }

    public static RefinedResourceSchema parse(ResourceType resourceType, PrismContext prismContext) throws SchemaException {
        ResourceSchema originalResourceSchema = RefinedResourceSchema.getResourceSchema(resourceType, prismContext);
        if (originalResourceSchema == null) {
            throw new IllegalArgumentException("Cannot determine resource schema from " + resourceType.asPrismObject());
        }
        SchemaHandlingType schemaHandling = resourceType.getSchemaHandling();
        RefinedResourceSchema rSchema = new RefinedResourceSchema(resourceType, originalResourceSchema, prismContext);
        if (schemaHandling != null) {
            if (schemaHandling.getAccountType() != null && !schemaHandling.getAccountType().isEmpty()) {
                RefinedResourceSchema.parseAccountTypesFromSchemaHandling(rSchema, resourceType, schemaHandling, prismContext, "definition of " + ObjectTypeUtil.toShortString((ObjectType)resourceType));
            } else {
                RefinedResourceSchema.parseAccountTypesFromSchema(rSchema, resourceType, prismContext, "definition of " + ObjectTypeUtil.toShortString((ObjectType)resourceType));
            }
        } else {
            RefinedResourceSchema.parseAccountTypesFromSchema(rSchema, resourceType, prismContext, "definition of " + ObjectTypeUtil.toShortString((ObjectType)resourceType));
        }
        return rSchema;
    }

    private static void parseAccountTypesFromSchemaHandling(RefinedResourceSchema rSchema, ResourceType resourceType, SchemaHandlingType schemaHandling, PrismContext prismContext, String contextDescription) throws SchemaException {
        RefinedAccountDefinition rAccountDefDefault = null;
        for (ResourceAccountTypeDefinitionType accountTypeDefType : schemaHandling.getAccountType()) {
            String accountTypeName;
            RefinedAccountDefinition rAccountDef = RefinedAccountDefinition.parse(accountTypeDefType, resourceType, rSchema, prismContext, "account type '" + (accountTypeName = accountTypeDefType.getName()) + "', in " + contextDescription);
            if (rAccountDef.isDefault()) {
                if (rAccountDefDefault == null) {
                    rAccountDefDefault = rAccountDef;
                } else {
                    throw new SchemaException("More than one default account definitions (" + (Object)((Object)rAccountDefDefault) + ", " + (Object)((Object)rAccountDef) + ") in " + contextDescription);
                }
            }
            rSchema.add(rAccountDef);
        }
    }

    private static void parseAccountTypesFromSchema(RefinedResourceSchema rSchema, ResourceType resourceType, PrismContext prismContext, String contextDescription) throws SchemaException {
        RefinedAccountDefinition rAccountDefDefault = null;
        for (ObjectClassComplexTypeDefinition objectClassDef : rSchema.getOriginalResourceSchema().getObjectClassDefinitions()) {
            if (!objectClassDef.isAccountType()) continue;
            QName objectClassname = objectClassDef.getTypeName();
            RefinedAccountDefinition rAccountDef = RefinedAccountDefinition.parse(objectClassDef, resourceType, rSchema, prismContext, "object class " + objectClassname + " (interpreted as account type definition), in " + contextDescription);
            if (rAccountDef.isDefault()) {
                if (rAccountDefDefault == null) {
                    rAccountDefDefault = rAccountDef;
                } else {
                    throw new SchemaException("More than one default account definitions (" + (Object)((Object)rAccountDefDefault) + ", " + (Object)((Object)rAccountDef) + ") in " + contextDescription);
                }
            }
            rSchema.add(rAccountDef);
        }
    }

    public <T extends ResourceObjectShadowType> PrismObject<T> refine(PrismObject<T> shadow) throws SchemaException {
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            return shadow;
        }
        ResourceObjectShadowType shadowType = (ResourceObjectShadowType)shadow.asObjectable();
        QName objectClassQName = shadowType.getObjectClass();
        Object definition = attributesContainer.getDefinition();
        if (definition != null && definition.getTypeName().equals(objectClassQName)) {
            return shadow;
        }
        if (shadowType instanceof AccountShadowType) {
            String accountType = ((AccountShadowType)shadowType).getAccountType();
            definition = this.getAccountDefinition(accountType);
            if (definition == null) {
                throw new SchemaException("No definition for account type " + accountType);
            }
        } else {
            ObjectClassComplexTypeDefinition ocDef = this.findObjectClassDefinition(objectClassQName);
            definition = new ResourceAttributeContainerDefinition(ResourceObjectShadowType.F_ATTRIBUTES, ocDef, ocDef.getPrismContext());
            if (definition == null) {
                throw new SchemaException("No definition for object class " + objectClassQName);
            }
        }
        attributesContainer.applyDefinition((ItemDefinition)definition);
        return shadow;
    }

    public String toString() {
        return "RSchema(ns=" + this.namespace + ")";
    }
}

