/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression.xpath;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.TunnelException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Node;

public class LazyXPathVariableResolver
implements XPathVariableResolver {
    private Map<QName, Object> variables = new HashMap<QName, Object>();
    private ObjectResolver objectResolver;
    private String contextDescription;
    private OperationResult result;

    public LazyXPathVariableResolver(Map<QName, Object> variables, ObjectResolver objectResolver, String contextDescription, OperationResult result) {
        this.variables = variables;
        this.objectResolver = objectResolver;
        this.result = result;
    }

    public void addVariable(QName name, Object value) {
        this.variables.put(name, value);
    }

    @Override
    public Object resolveVariable(QName name) {
        Object variableValue = this.variables.get(name);
        if (variableValue == null) {
            return null;
        }
        if (this.objectResolver != null && variableValue instanceof ObjectReferenceType) {
            ObjectReferenceType ref = (ObjectReferenceType)variableValue;
            if (ref.getOid() == null) {
                SchemaException newEx = new SchemaException("Null OID in reference in variable " + name + " in " + this.contextDescription, name);
                throw new TunnelException((Throwable)newEx);
            }
            ref.getType();
            try {
                variableValue = this.objectResolver.resolve(ref, ObjectType.class, this.contextDescription, this.result);
            }
            catch (ObjectNotFoundException e) {
                ObjectNotFoundException newEx = new ObjectNotFoundException("Object not found during variable " + name + " resolution in " + this.contextDescription + ": " + e.getMessage(), (Throwable)e, ref.getOid());
                throw new TunnelException((Throwable)newEx);
            }
            catch (SchemaException e) {
                SchemaException newEx = new SchemaException("Schema error during variable " + name + " resolution in " + this.contextDescription + ": " + e.getMessage(), (Throwable)e, name);
                throw new TunnelException((Throwable)newEx);
            }
        }
        try {
            return LazyXPathVariableResolver.convertToXml(variableValue, name);
        }
        catch (SchemaException e) {
            throw new TunnelException((Throwable)e);
        }
    }

    public static Object convertToXml(Object variableValue, QName variableName) throws SchemaException {
        if (variableValue instanceof Objectable) {
            variableValue = ((Objectable)variableValue).asPrismObject();
        }
        if (variableValue instanceof PrismObject) {
            PrismObject prismObject = (PrismObject)variableValue;
            PrismDomProcessor domProcessor = prismObject.getPrismContext().getPrismDomProcessor();
            variableValue = domProcessor.serializeToDom(prismObject);
        } else if (variableValue instanceof PrismValue) {
            PrismValue pval = (PrismValue)variableValue;
            PrismContext prismContext = pval.getPrismContext();
            PrismDomProcessor domProcessor = prismContext.getPrismDomProcessor();
            variableValue = domProcessor.serializeValueToDom(pval, variableName);
        }
        if (!(variableValue instanceof Node) && !variableValue.getClass().getPackage().getName().startsWith("java.")) {
            throw new SchemaException("Unable to convert value of variable " + variableName + " to XML, still got " + variableValue + " value at the end");
        }
        return variableValue;
    }
}

