/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryUtil {
    @Deprecated
    public static Element createTypeFilter(Document doc, String uri) {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)uri);
        Validate.notEmpty((String)uri);
        Element type = doc.createElementNS(SchemaConstantsGenerated.Q_TYPE.getNamespaceURI(), SchemaConstantsGenerated.Q_TYPE.getLocalPart());
        type.setAttributeNS(SchemaConstants.C_FILTER_TYPE_URI.getNamespaceURI(), SchemaConstants.C_FILTER_TYPE_URI.getLocalPart(), uri);
        return type;
    }

    public static Element createEqualFilterFromElements(Document doc, XPathHolder xpath, List<?> values, PrismContext prismContext) throws SchemaException {
        Validate.notNull((Object)doc);
        Validate.notNull(values);
        Validate.notEmpty(values);
        Element equal = doc.createElementNS(SchemaConstantsGenerated.Q_EQUAL.getNamespaceURI(), SchemaConstantsGenerated.Q_EQUAL.getLocalPart());
        Element value = doc.createElementNS(SchemaConstantsGenerated.Q_VALUE.getNamespaceURI(), SchemaConstantsGenerated.Q_VALUE.getLocalPart());
        for (Object val : values) {
            Element domElement;
            try {
                domElement = prismContext.getPrismJaxbProcessor().toDomElement(val, doc);
            }
            catch (JAXBException e) {
                throw new SchemaException("Unexpected JAXB problem while creating search filer for value " + val, (Throwable)e);
            }
            value.appendChild(doc.importNode(domElement, true));
        }
        if (xpath != null) {
            Element path = xpath.toElement(SchemaConstantsGenerated.Q_PATH, doc);
            equal.appendChild(doc.importNode(path, true));
        }
        equal.appendChild(doc.importNode(value, true));
        return equal;
    }

    public static Element createEqualFilter(Document doc, XPathHolder xpath, Object object) throws SchemaException {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)object);
        Element equal = doc.createElementNS(SchemaConstantsGenerated.Q_EQUAL.getNamespaceURI(), SchemaConstantsGenerated.Q_EQUAL.getLocalPart());
        Element value = doc.createElementNS(SchemaConstantsGenerated.Q_VALUE.getNamespaceURI(), SchemaConstantsGenerated.Q_VALUE.getLocalPart());
        equal.appendChild(value);
        if (!(object instanceof Element)) {
            throw new UnsupportedOperationException("Unsupported element type " + object.getClass());
        }
        Element domElement = (Element)object;
        value.appendChild(doc.importNode(domElement, true));
        if (xpath != null) {
            Element path = xpath.toElement(SchemaConstantsGenerated.Q_PATH, doc);
            equal.appendChild(path);
        }
        return equal;
    }

    public static Element createEqualFilter(Document doc, XPathHolder xpath, QName properyName, String value) throws SchemaException {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)properyName);
        Validate.notNull((Object)value);
        Element element = doc.createElementNS(properyName.getNamespaceURI(), properyName.getLocalPart());
        element.setTextContent(value);
        return QueryUtil.createEqualFilter(doc, xpath, element);
    }

    public static Element createSubstringFilter(Document document, XPathHolder xpath, QName propertyName, String searchText) throws SchemaException {
        Validate.notNull((Object)document, (String)"Document must not be null.");
        Validate.notNull((Object)propertyName, (String)"Property name must not be null.");
        Validate.notEmpty((String)searchText, (String)"Search text must not be empty.");
        Element realValue = DOMUtil.createElement((Document)document, (QName)propertyName);
        realValue.setTextContent(searchText);
        Element substring = DOMUtil.createElement((Document)document, (QName)SchemaConstantsGenerated.Q_SUBSTRING);
        if (xpath != null) {
            Element path = xpath.toElement(SchemaConstantsGenerated.Q_PATH, document);
            substring.appendChild(path);
        }
        Element value = DOMUtil.createElement((Document)document, (QName)SchemaConstantsGenerated.Q_VALUE);
        value.appendChild(realValue);
        substring.appendChild(value);
        return substring;
    }

    public static Element createEqualFilter(Document doc, XPathHolder xpath, QName propertyName, QName value) throws SchemaException {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)propertyName);
        Validate.notNull((Object)value);
        Element element = doc.createElementNS(propertyName.getNamespaceURI(), propertyName.getLocalPart());
        DOMUtil.setQNameValue((Element)element, (QName)value);
        return QueryUtil.createEqualFilter(doc, xpath, element);
    }

    public static Element createEqualRefFilter(Document doc, XPathHolder xpath, QName propertyName, String oid) throws SchemaException {
        Element value = doc.createElementNS(propertyName.getNamespaceURI(), propertyName.getLocalPart());
        value.setAttributeNS(SchemaConstants.C_OID_ATTRIBUTE.getNamespaceURI(), SchemaConstants.C_OID_ATTRIBUTE.getLocalPart(), oid);
        return QueryUtil.createEqualFilter(doc, xpath, value);
    }

    public static Element createOrFilter(Document doc, Element ... conditions) {
        return QueryUtil.createLogicFilter(doc, SchemaConstantsGenerated.Q_OR, conditions);
    }

    public static Element createAndFilter(Document doc, Element ... conditions) {
        return QueryUtil.createLogicFilter(doc, SchemaConstantsGenerated.Q_AND, conditions);
    }

    private static Element createLogicFilter(Document doc, QName filterName, Element ... conditions) {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)filterName);
        Validate.notNull((Object)conditions);
        Element logical = doc.createElementNS(filterName.getNamespaceURI(), filterName.getLocalPart());
        Element[] elementArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Element condition = elementArray[n2];
            Validate.notNull((Object)condition);
            logical.appendChild(condition);
            ++n2;
        }
        return logical;
    }

    public static QueryType createNameQuery(String name) throws SchemaException {
        Document doc = DOMUtil.getDocument();
        Element filter = QueryUtil.createEqualFilter(doc, null, SchemaConstantsGenerated.C_NAME, name);
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    public static QueryType createNameQuery(ObjectType object) throws SchemaException {
        return QueryUtil.createNameQuery(object.getName());
    }

    @Deprecated
    public static <T extends ObjectType> Element createNameAndClassFilter(Class<T> type, String name) throws SchemaException {
        Document doc = DOMUtil.getDocument();
        return QueryUtil.createEqualFilter(doc, null, SchemaConstantsGenerated.C_NAME, name);
    }

    public static QueryType createQuery(Element filter) {
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    public static QueryType createAllObjectsQuery() {
        return new QueryType();
    }

    public static QueryType createResourceAndAccountQuery(ResourceType resource, QName objectClass, String accountType) throws SchemaException {
        Document doc = DOMUtil.getDocument();
        Element filter = QueryUtil.createAndFilter(doc, QueryUtil.createEqualRefFilter(doc, null, SchemaConstants.I_RESOURCE_REF, resource.getOid()), QueryUtil.createEqualFilter(doc, null, SchemaConstants.I_OBJECT_CLASS, objectClass));
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    public static QueryType createAttributeQuery(PrismProperty<?> attribute, QName objectClass, ResourceType resourceType, PrismContext prismContext) throws SchemaException {
        Document doc = DOMUtil.getDocument();
        XPathHolder xpath = new XPathHolder(new QName[]{ResourceObjectShadowType.F_ATTRIBUTES});
        List identifierElements = prismContext.getPrismDomProcessor().serializeItemToDom(attribute, doc);
        Element filter = QueryUtil.createAndFilter(doc, QueryUtil.createEqualRefFilter(doc, null, SchemaConstants.I_RESOURCE_REF, resourceType.getOid()), QueryUtil.createEqualFilterFromElements(doc, xpath, identifierElements, prismContext));
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    public static String dump(QueryType query) {
        if (query == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("Query(");
        sb.append(query.getDescription()).append("):\n");
        if (query.getFilter() != null) {
            sb.append(DOMUtil.serializeDOMToString((Node)query.getFilter()));
        } else {
            sb.append("(no filter)");
        }
        return sb.toString();
    }
}

