/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.IOException;
import java.lang.reflect.Field;
import org.basex.api.xmldb.BXCollectionManagementService;
import org.basex.api.xmldb.BXQueryService;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public final class BXCollection
implements Collection,
BXXMLDBText {
    Context ctx;

    public BXCollection(String name, boolean open) throws XMLDBException {
        this(name, open, new Context());
    }

    public BXCollection(String name, boolean open, Context c) throws XMLDBException {
        this.ctx = c;
        try {
            this.ctx.openDB(open ? Open.open((String)name, (Context)this.ctx) : CreateDB.empty((String)name, (Context)this.ctx));
        }
        catch (IOException ex) {
            throw new XMLDBException(1, ex.getMessage());
        }
    }

    public String getName() {
        return this.ctx.data.meta.name;
    }

    public Service[] getServices() throws XMLDBException {
        this.check();
        return new Service[]{this.getService("XPathQueryService", "1.0"), this.getService("XQueryQueryService", "1.0"), this.getService("CollectionManagementService", "1.0")};
    }

    public Service getService(String nm, String ver) throws XMLDBException {
        this.check();
        if (ver.equals("1.0")) {
            if (nm.equals("XPathQueryService") || nm.equals("XQueryQueryService")) {
                return new BXQueryService(this, nm, ver);
            }
            if (nm.equals("CollectionManagementService")) {
                return new BXCollectionManagementService(this);
            }
        }
        return null;
    }

    public Collection getParentCollection() throws XMLDBException {
        this.check();
        return null;
    }

    public Collection getChildCollection(String name) throws XMLDBException {
        this.check();
        return null;
    }

    public int getChildCollectionCount() throws XMLDBException {
        this.check();
        return 0;
    }

    public String[] listChildCollections() throws XMLDBException {
        this.check();
        return new String[0];
    }

    public int getResourceCount() throws XMLDBException {
        this.check();
        return this.ctx.data.doc().size();
    }

    public String[] listResources() throws XMLDBException {
        this.check();
        StringList sl = new StringList();
        Data data = this.ctx.data;
        IntList il = data.doc();
        int i = 0;
        int is = il.size();
        while (i < is) {
            sl.add(Token.string((byte[])data.text(il.get(i), true)));
            ++i;
        }
        return sl.toArray();
    }

    public BXXMLResource createResource(String id, String type) throws XMLDBException {
        this.check();
        if (type.equals("XMLResource")) {
            String uid = id == null || id.isEmpty() ? this.createId() : id;
            return new BXXMLResource(null, 0, uid, this);
        }
        throw type.equals("BinaryResource") ? new XMLDBException(1, "Binary resources not supported.") : new XMLDBException(302, "Resource type is unknown: " + type);
    }

    public void removeResource(Resource res) throws XMLDBException {
        this.check();
        BXXMLResource del = this.checkXML(res);
        Data data = this.ctx.data;
        if (del.data != data && del.data != null) {
            throw new XMLDBException(300, "Unknown Resource: " + data.meta.name);
        }
        IntList il = new IntList();
        il.add(this.getResource((String)del.getId()).pre);
        Delete.delete((Context)this.ctx, (IntList)il);
    }

    public void storeResource(Resource res) throws XMLDBException {
        this.check();
        BXXMLResource xml = this.checkXML(res);
        if (res.getContent() == null) {
            throw new XMLDBException(301, "Resource has no contents.");
        }
        String id = res.getId();
        if (id == null) {
            throw new XMLDBException(301, "Resource has no ID.");
        }
        BXXMLResource old = this.getResource(id);
        if (old != null) {
            this.removeResource((Resource)this.getResource(id));
        }
        Object cont = xml.content;
        try {
            DOMWrapper p = cont instanceof Document ? new DOMWrapper((Document)cont, id) : Parser.xmlParser((IO)new IOContent((byte[])cont, id), (Prop)this.ctx.prop, (String)"");
            Data data = this.ctx.data;
            data.insert(data.meta.size, -1, (Data)MemBuilder.build((String)id, (Parser)p, (Prop)this.ctx.prop));
            this.ctx.update();
            data.flush();
        }
        catch (IOException ex) {
            throw new XMLDBException(301, ex.getMessage());
        }
    }

    public BXXMLResource getResource(String id) throws XMLDBException {
        this.check();
        if (id == null) {
            return null;
        }
        Data data = this.ctx.data;
        byte[] idd = Token.token((String)id);
        IntList il = data.doc();
        int i = 0;
        int is = il.size();
        while (i < is) {
            int pre = il.get(i);
            if (Token.eq((byte[])data.text(pre, true), (byte[])idd)) {
                return new BXXMLResource(data, pre, id, this);
            }
            ++i;
        }
        return null;
    }

    public String createId() throws XMLDBException {
        String[] res = this.listResources();
        String id = null;
        while (this.exists(res, id = Long.toString(System.currentTimeMillis()))) {
        }
        return id;
    }

    public boolean isOpen() {
        return this.ctx != null;
    }

    public void close() {
        if (this.ctx != null) {
            this.ctx.close();
        }
        this.ctx = null;
    }

    public String getProperty(String key) throws XMLDBException {
        this.check();
        try {
            return MetaData.class.getField(key).get(this.ctx.data.meta).toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setProperty(String key, String val) throws XMLDBException {
        this.check();
        try {
            MetaData md = this.ctx.data.meta;
            Field f = MetaData.class.getField(key);
            Object k = f.get(md);
            if (k instanceof Boolean) {
                boolean b = val == null ? !((Boolean)k).booleanValue() : val.equalsIgnoreCase("ON") || val.equalsIgnoreCase("TRUE");
                f.setBoolean(md, b);
            } else if (k instanceof Integer) {
                f.setInt(md, Integer.parseInt(val));
            } else {
                f.set(md, val);
            }
        }
        catch (Exception ex) {
            throw new XMLDBException(1, "Property could not be set: " + key);
        }
    }

    private boolean exists(String[] list, String id) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            if (l.equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void check() throws XMLDBException {
        if (this.ctx == null) {
            throw new XMLDBException(202);
        }
    }

    private BXXMLResource checkXML(Resource res) throws XMLDBException {
        if (!(res instanceof BXXMLResource)) {
            throw new XMLDBException(300, "Unknown Resource: " + res);
        }
        return (BXXMLResource)res;
    }
}

