/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.jaxrx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.ws.rs.core.StreamingOutput;
import org.basex.api.jaxrx.BXCode;
import org.basex.api.jaxrx.BXOutput;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.List;
import org.basex.core.cmd.ListDB;
import org.basex.core.cmd.Open;
import org.basex.io.IO;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.XMLSerializer;
import org.basex.server.Session;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;
import org.jaxrx.JaxRx;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.jaxrx.core.ResourcePath;

public final class BXJaxRx
implements JaxRx {
    public HashSet<QueryParameter> getParameters() {
        HashSet<QueryParameter> p = new HashSet<QueryParameter>();
        p.add(QueryParameter.COMMAND);
        p.add(QueryParameter.QUERY);
        p.add(QueryParameter.RUN);
        p.add(QueryParameter.COUNT);
        p.add(QueryParameter.OUTPUT);
        p.add(QueryParameter.START);
        p.add(QueryParameter.WRAP);
        p.add(QueryParameter.VAR);
        return p;
    }

    public StreamingOutput get(ResourcePath path) {
        return new BXOutput(path){

            @Override
            String code() throws IOException {
                XMLSerializer xml = new XMLSerializer(this.out, new SerializerProp(this.serial(this.path)));
                if (this.path.getDepth() != 0) {
                    String all = this.path.getResourcePath();
                    Table table = new Table(this.exec(new ListDB(all), null));
                    xml.openElement(Token.token((String)"jax-rx:database"), (byte[][])new byte[][]{Token.token((String)"name"), Token.token((String)this.path.getResource(0)), Token.token((String)"documents"), Token.token((int)table.contents.size())});
                    for (TokenList l : table.contents) {
                        xml.emptyElement(Token.token((String)"jax-rx:document"), (byte[][])new byte[][]{Token.token((String)"path"), l.get(0), Token.token((String)"nodes"), l.get(1)});
                    }
                    xml.closeElement();
                } else {
                    Table table = new Table(this.exec(new List(), null));
                    for (TokenList l : table.contents) {
                        xml.emptyElement(Token.token((String)"jax-rx:database"), (byte[][])new byte[][]{Token.token((String)"name"), l.get(0), Token.token((String)"documents"), l.get(1), Token.token((String)"size"), l.get(2)});
                    }
                }
                xml.close();
                return null;
            }
        };
    }

    public StreamingOutput query(final String query, ResourcePath path) {
        return new BXOutput(path){

            @Override
            String code() {
                return this.query(query);
            }
        };
    }

    public StreamingOutput run(final String file, ResourcePath path) {
        return new BXOutput(path){

            @Override
            String code() {
                String root = String.valueOf(System.getProperty("org.basex.jaxrxpath")) + '/';
                IO io = IO.get((String)(String.valueOf(root) + file.trim()));
                if (!io.exists()) {
                    throw new JaxRxException(404, Util.info((Object)Text.FILEWHICH, (Object[])new Object[]{file}));
                }
                try {
                    return this.query(Token.string((byte[])io.content()));
                }
                catch (IOException ex) {
                    throw new JaxRxException(400, ex.getMessage());
                }
            }
        };
    }

    public StreamingOutput command(final String cmd, ResourcePath path) {
        return new BXOutput(path){

            @Override
            String code() throws IOException {
                ArrayOutput ao = new ArrayOutput();
                this.exec(cmd, (OutputStream)ao);
                XMLSerializer xml = new XMLSerializer(this.out, new SerializerProp(this.serial(this.path)));
                xml.text(Token.delete((byte[])ao.toArray(), (int)13));
                xml.close();
                return this.session.info();
            }
        };
    }

    public String add(final InputStream input, final ResourcePath path) {
        return new BXCode(path){

            @Override
            String code() {
                try {
                    this.session.execute((Command)new Open(this.db(path)));
                }
                catch (BaseXException ex) {
                    throw new JaxRxException(404, ex.getMessage());
                }
                BXJaxRx.this.add(input, path, this.session);
                return this.session.info();
            }
        }.run();
    }

    void add(InputStream input, ResourcePath path, Session session) {
        int d = path.getDepth();
        String name = path.getResource(d - 1);
        StringBuilder target = new StringBuilder();
        int i = 1;
        while (i < d - 1) {
            target.append('/').append(path.getResource(i));
            ++i;
        }
        try {
            session.add(name, target.toString(), input);
        }
        catch (BaseXException ex) {
            throw new JaxRxException(400, ex.getMessage());
        }
    }

    public String update(final InputStream input, final ResourcePath path) {
        return new BXCode(path){

            @Override
            String code() {
                try {
                    int d = path.getDepth();
                    if (d == 1) {
                        this.session.create(this.db(path), input);
                    } else {
                        this.session.execute((Command)new Open(this.db(path)));
                        StringBuilder target = new StringBuilder();
                        int i = 1;
                        while (i < d) {
                            target.append('/').append(path.getResource(i));
                            ++i;
                        }
                        this.session.execute((Command)new Delete(target.toString()));
                        BXJaxRx.this.add(input, path, this.session);
                    }
                    return this.session.info();
                }
                catch (BaseXException ex) {
                    throw new JaxRxException(400, ex.getMessage());
                }
            }
        }.run();
    }

    public String delete(final ResourcePath path) {
        return new BXCode(path){

            @Override
            String code() {
                boolean root = path.getDepth() == 1;
                try {
                    if (root) {
                        this.session.execute((Command)new DropDB(this.db(path)));
                    } else {
                        this.session.execute((Command)new Open(this.db(path)));
                        this.session.execute((Command)new Delete(this.path(path)));
                    }
                    return this.session.info();
                }
                catch (BaseXException ex) {
                    if (root) {
                        throw new JaxRxException((Exception)((Object)ex));
                    }
                    throw new JaxRxException(404, ex.getMessage());
                }
            }
        }.run();
    }
}

