/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountSynchronizationSettingsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorFrameworkType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LoggingConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelHooksType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemConfigurationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.xml.namespace.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_system_configuration")
public class RSystemConfiguration
extends RObject {
    private static final Trace LOGGER = TraceManager.getTrace(RSystemConfiguration.class);
    @QueryAttribute
    private String name;
    private String globalAccountSynchronizationSettings;
    private String modelHooks;
    private String logging;
    private RObjectReference defaultUserTemplateRef;
    private String connectorFramework;

    @Type(type="org.hibernate.type.TextType")
    public String getConnectorFramework() {
        return this.connectorFramework;
    }

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public RObjectReference getDefaultUserTemplateRef() {
        return this.defaultUserTemplateRef;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getGlobalAccountSynchronizationSettings() {
        return this.globalAccountSynchronizationSettings;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getLogging() {
        return this.logging;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getModelHooks() {
        return this.modelHooks;
    }

    @Index(name="iSystemConfigurationName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnectorFramework(String connectorFramework) {
        this.connectorFramework = connectorFramework;
    }

    public void setDefaultUserTemplateRef(RObjectReference defaultUserTemplateRef) {
        this.defaultUserTemplateRef = defaultUserTemplateRef;
    }

    public void setGlobalAccountSynchronizationSettings(String globalAccountSynchronizationSettings) {
        this.globalAccountSynchronizationSettings = globalAccountSynchronizationSettings;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    public void setModelHooks(String modelHooks) {
        this.modelHooks = modelHooks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RSystemConfiguration that = (RSystemConfiguration)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.connectorFramework != null ? !this.connectorFramework.equals(that.connectorFramework) : that.connectorFramework != null) {
            return false;
        }
        if (this.defaultUserTemplateRef != null ? !this.defaultUserTemplateRef.equals(that.defaultUserTemplateRef) : that.defaultUserTemplateRef != null) {
            return false;
        }
        if (this.globalAccountSynchronizationSettings != null ? !this.globalAccountSynchronizationSettings.equals(that.globalAccountSynchronizationSettings) : that.globalAccountSynchronizationSettings != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        return !(this.modelHooks != null ? !this.modelHooks.equals(that.modelHooks) : that.modelHooks != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.globalAccountSynchronizationSettings != null ? this.globalAccountSynchronizationSettings.hashCode() : 0);
        result = 31 * result + (this.modelHooks != null ? this.modelHooks.hashCode() : 0);
        result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
        result = 31 * result + (this.connectorFramework != null ? this.connectorFramework.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RSystemConfiguration repo, SystemConfigurationType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        if (repo.getDefaultUserTemplateRef() != null) {
            jaxb.setDefaultUserTemplateRef(repo.getDefaultUserTemplateRef().toJAXB(prismContext));
        }
        try {
            jaxb.setConnectorFramework(RUtil.toJAXB(SystemConfigurationType.class, new PropertyPath(new QName[]{SystemConfigurationType.F_CONNECTOR_FRAMEWORK}), repo.getConnectorFramework(), ConnectorFrameworkType.class, prismContext));
            jaxb.setGlobalAccountSynchronizationSettings(RUtil.toJAXB(SystemConfigurationType.class, new PropertyPath(new QName[]{SystemConfigurationType.F_GLOBAL_ACCOUNT_SYNCHRONIZATION_SETTINGS}), repo.getGlobalAccountSynchronizationSettings(), AccountSynchronizationSettingsType.class, prismContext));
            jaxb.setLogging(RUtil.toJAXB(SystemConfigurationType.class, new PropertyPath(new QName[]{SystemConfigurationType.F_LOGGING}), repo.getLogging(), LoggingConfigurationType.class, prismContext));
            jaxb.setModelHooks(RUtil.toJAXB(SystemConfigurationType.class, new PropertyPath(new QName[]{SystemConfigurationType.F_MODEL_HOOKS}), repo.getModelHooks(), ModelHooksType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(SystemConfigurationType jaxb, RSystemConfiguration repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        if (jaxb.getDefaultUserTemplate() != null) {
            LOGGER.warn("Default user template from system configuration type won't be saved. It should be translated to user template reference.");
        }
        repo.setDefaultUserTemplateRef(RUtil.jaxbRefToRepo(jaxb.getDefaultUserTemplateRef(), repo, prismContext));
        try {
            repo.setConnectorFramework(RUtil.toRepo(jaxb.getConnectorFramework(), prismContext));
            repo.setGlobalAccountSynchronizationSettings(RUtil.toRepo(jaxb.getGlobalAccountSynchronizationSettings(), prismContext));
            repo.setLogging(RUtil.toRepo(jaxb.getLogging(), prismContext));
            repo.setModelHooks(RUtil.toRepo(jaxb.getModelHooks(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public SystemConfigurationType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        SystemConfigurationType object = new SystemConfigurationType();
        RUtil.revive((Objectable)object, prismContext);
        RSystemConfiguration.copyToJAXB(this, object, prismContext);
        return object;
    }
}

