/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RActivation;
import com.evolveum.midpoint.repo.sql.data.common.RAnyContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.data.common.RFailedOperationTypeType;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.ROperationResult;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.query.QueryEntity;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowAttributesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.prism.xml.ns._public.types_2.ObjectDeltaType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.xml.namespace.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@Entity
@javax.persistence.Table(name="m_resource_shadow")
@Table(appliesTo="m_resource_shadow", indexes={@Index(name="iResourceObjectShadowEnabled", columnNames={"enabled"})})
@ForeignKey(name="fk_resource_object_shadow")
public class RResourceObjectShadow
extends RObject {
    private static final Trace LOGGER = TraceManager.getTrace(RResourceObjectShadow.class);
    @QueryAttribute
    private String name;
    private QName objectClass;
    private RActivation activation;
    private ROperationResult result;
    @QueryAttribute
    private RObjectReference resourceRef;
    private String objectChange;
    private Integer attemptNumber;
    private RFailedOperationTypeType failedOperationType;
    @QueryEntity(any=true)
    private RAnyContainer attributes;

    @Columns(columns={@Column(name="class_namespace"), @Column(name="class_localPart")})
    public QName getObjectClass() {
        return this.objectClass;
    }

    @OneToOne(optional=true, orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="attrOid", referencedColumnName="owner_oid"), @JoinColumn(name="attrId", referencedColumnName="owner_id"), @JoinColumn(name="attrType", referencedColumnName="ownerType")})
    public RAnyContainer getAttributes() {
        return this.attributes;
    }

    @Embedded
    public RActivation getActivation() {
        return this.activation;
    }

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public ROperationResult getResult() {
        return this.result;
    }

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public RObjectReference getResourceRef() {
        return this.resourceRef;
    }

    @Column(nullable=true)
    public Integer getAttemptNumber() {
        return this.attemptNumber;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=true)
    public RFailedOperationTypeType getFailedOperationType() {
        return this.failedOperationType;
    }

    @Type(type="org.hibernate.type.TextType")
    @Column(nullable=true)
    public String getObjectChange() {
        return this.objectChange;
    }

    @Index(name="iResourceShadowName")
    @Column(name="objectName")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAttemptNumber(Integer attemptNumber) {
        this.attemptNumber = attemptNumber;
    }

    public void setFailedOperationType(RFailedOperationTypeType failedOperationType) {
        this.failedOperationType = failedOperationType;
    }

    public void setObjectChange(String objectChange) {
        this.objectChange = objectChange;
    }

    public void setResourceRef(RObjectReference resourceRef) {
        this.resourceRef = resourceRef;
    }

    public void setResult(ROperationResult result) {
        this.result = result;
    }

    public void setActivation(RActivation activation) {
        this.activation = activation;
    }

    public void setAttributes(RAnyContainer attributes) {
        this.attributes = attributes;
        if (this.attributes != null) {
            this.attributes.setOwnerType(RContainerType.RESOURCE_OBJECT_SHADOW);
        }
    }

    public void setObjectClass(QName objectClass) {
        this.objectClass = objectClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RResourceObjectShadow that = (RResourceObjectShadow)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.activation != null ? !this.activation.equals(that.activation) : that.activation != null) {
            return false;
        }
        if (this.attemptNumber != null ? !this.attemptNumber.equals(that.attemptNumber) : that.attemptNumber != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.failedOperationType != that.failedOperationType) {
            return false;
        }
        if (this.objectChange != null ? !this.objectChange.equals(that.objectChange) : that.objectChange != null) {
            return false;
        }
        if (this.objectClass != null ? !this.objectClass.equals(that.objectClass) : that.objectClass != null) {
            return false;
        }
        if (this.resourceRef != null ? !this.resourceRef.equals(that.resourceRef) : that.resourceRef != null) {
            return false;
        }
        return !(this.result != null ? !this.result.equals(that.result) : that.result != null);
    }

    @Override
    public int hashCode() {
        int result1 = super.hashCode();
        result1 = 31 * result1 + (this.name != null ? this.name.hashCode() : 0);
        result1 = 31 * result1 + (this.objectClass != null ? this.objectClass.hashCode() : 0);
        result1 = 31 * result1 + (this.activation != null ? this.activation.hashCode() : 0);
        result1 = 31 * result1 + (this.objectChange != null ? this.objectChange.hashCode() : 0);
        result1 = 31 * result1 + (this.attemptNumber != null ? this.attemptNumber.hashCode() : 0);
        result1 = 31 * result1 + (this.failedOperationType != null ? this.failedOperationType.hashCode() : 0);
        return result1;
    }

    public static void copyToJAXB(RResourceObjectShadow repo, ResourceObjectShadowType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setObjectClass(repo.getObjectClass());
        if (repo.getActivation() != null) {
            jaxb.setActivation(repo.getActivation().toJAXB(prismContext));
        }
        if (repo.getResult() != null) {
            jaxb.setResult(repo.getResult().toJAXB(prismContext));
        }
        if (repo.getResourceRef() != null) {
            jaxb.setResourceRef(repo.getResourceRef().toJAXB(prismContext));
        }
        jaxb.setAttemptNumber(repo.getAttemptNumber());
        if (repo.getFailedOperationType() != null) {
            jaxb.setFailedOperationType(repo.getFailedOperationType().getOperation());
        }
        try {
            jaxb.setObjectChange(RUtil.toJAXB(repo.getObjectChange(), ObjectDeltaType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
        if (repo.getAttributes() != null) {
            ResourceObjectShadowAttributesType attributes = new ResourceObjectShadowAttributesType();
            jaxb.setAttributes(attributes);
            RAnyContainer.copyToJAXB(repo.getAttributes(), attributes, prismContext);
        }
    }

    public static void copyFromJAXB(ResourceObjectShadowType jaxb, RResourceObjectShadow repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setObjectClass(jaxb.getObjectClass());
        if (jaxb.getActivation() != null) {
            RActivation activation = new RActivation();
            RActivation.copyFromJAXB(jaxb.getActivation(), activation, prismContext);
            repo.setActivation(activation);
        }
        if (jaxb.getResult() != null) {
            ROperationResult result = new ROperationResult();
            result.setOwner(repo);
            ROperationResult.copyFromJAXB(jaxb.getResult(), result, prismContext);
            repo.setResult(result);
        }
        repo.setResourceRef(RUtil.jaxbRefToRepo(jaxb.getResourceRef(), repo, prismContext));
        repo.setAttemptNumber(jaxb.getAttemptNumber());
        repo.setFailedOperationType(RFailedOperationTypeType.toRepoType(jaxb.getFailedOperationType()));
        if (jaxb.getResource() != null) {
            LOGGER.warn("Resource from resource object shadow type won't be saved. It should be translated to resource reference.");
        }
        try {
            repo.setObjectChange(RUtil.toRepo(jaxb.getObjectChange(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
        if (jaxb.getAttributes() != null) {
            RAnyContainer attributes = new RAnyContainer();
            attributes.setOwner(repo);
            repo.setAttributes(attributes);
            RAnyContainer.copyFromJAXB(jaxb.getAttributes(), attributes, prismContext);
        }
    }

    public ResourceObjectShadowType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        ResourceObjectShadowType object = new ResourceObjectShadowType();
        RUtil.revive((Objectable)object, prismContext);
        RResourceObjectShadow.copyToJAXB(this, object, prismContext);
        return object;
    }
}

