/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CachedCapabilitiesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CapabilitiesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SchemaHandlingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.xml.namespace.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_resource")
public class RResource
extends RObject {
    private static final Trace LOGGER = TraceManager.getTrace(RResource.class);
    @QueryAttribute
    private String name;
    private RObjectReference connectorRef;
    private String namespace;
    private String configuration;
    private String xmlSchema;
    private String schemaHandling;
    private String nativeCapabilities;
    private String capabilities;
    private String scripts;
    private String synchronization;

    @Type(type="org.hibernate.type.TextType")
    public String getScripts() {
        return this.scripts;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getCapabilities() {
        return this.capabilities;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getNativeCapabilities() {
        return this.nativeCapabilities;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getConfiguration() {
        return this.configuration;
    }

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public RObjectReference getConnectorRef() {
        return this.connectorRef;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getXmlSchema() {
        return this.xmlSchema;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getSchemaHandling() {
        return this.schemaHandling;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getSynchronization() {
        return this.synchronization;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Index(name="iResourceName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setXmlSchema(String xmlSchema) {
        this.xmlSchema = xmlSchema;
    }

    public void setConnectorRef(RObjectReference connectorRef) {
        this.connectorRef = connectorRef;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setSchemaHandling(String schemaHandling) {
        this.schemaHandling = schemaHandling;
    }

    public void setSynchronization(String synchronization) {
        this.synchronization = synchronization;
    }

    public void setCapabilities(String capabilities) {
        this.capabilities = capabilities;
    }

    public void setNativeCapabilities(String nativeCapabilities) {
        this.nativeCapabilities = nativeCapabilities;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RResource rResource = (RResource)o;
        if (this.name != null ? !this.name.equals(rResource.name) : rResource.name != null) {
            return false;
        }
        if (this.capabilities != null ? !this.capabilities.equals(rResource.capabilities) : rResource.capabilities != null) {
            return false;
        }
        if (this.configuration != null ? !this.configuration.equals(rResource.configuration) : rResource.configuration != null) {
            return false;
        }
        if (this.connectorRef != null ? !this.connectorRef.equals(rResource.connectorRef) : rResource.connectorRef != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(rResource.namespace) : rResource.namespace != null) {
            return false;
        }
        if (this.nativeCapabilities != null ? !this.nativeCapabilities.equals(rResource.nativeCapabilities) : rResource.nativeCapabilities != null) {
            return false;
        }
        if (this.schemaHandling != null ? !this.schemaHandling.equals(rResource.schemaHandling) : rResource.schemaHandling != null) {
            return false;
        }
        if (this.scripts != null ? !this.scripts.equals(rResource.scripts) : rResource.scripts != null) {
            return false;
        }
        if (this.synchronization != null ? !this.synchronization.equals(rResource.synchronization) : rResource.synchronization != null) {
            return false;
        }
        return !(this.xmlSchema != null ? !this.xmlSchema.equals(rResource.xmlSchema) : rResource.xmlSchema != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
        result = 31 * result + (this.xmlSchema != null ? this.xmlSchema.hashCode() : 0);
        result = 31 * result + (this.schemaHandling != null ? this.schemaHandling.hashCode() : 0);
        result = 31 * result + (this.nativeCapabilities != null ? this.nativeCapabilities.hashCode() : 0);
        result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
        result = 31 * result + (this.scripts != null ? this.scripts.hashCode() : 0);
        result = 31 * result + (this.synchronization != null ? this.synchronization.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RResource repo, ResourceType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setNamespace(repo.getNamespace());
        if (repo.getConnectorRef() != null) {
            jaxb.setConnectorRef(repo.getConnectorRef().toJAXB(prismContext));
        }
        try {
            jaxb.setConfiguration(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_CONFIGURATION}), repo.getConfiguration(), ResourceConfigurationType.class, prismContext));
            jaxb.setSchema(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_SCHEMA}), repo.getXmlSchema(), XmlSchemaType.class, prismContext));
            jaxb.setSchemaHandling(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_SCHEMA_HANDLING}), repo.getSchemaHandling(), SchemaHandlingType.class, prismContext));
            jaxb.setSynchronization(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_SYNCHRONIZATION}), repo.getSynchronization(), SynchronizationType.class, prismContext));
            jaxb.setCapabilities(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_CAPABILITIES}), repo.getCapabilities(), CapabilitiesType.class, prismContext));
            jaxb.setNativeCapabilities(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_NATIVE_CAPABILITIES}), repo.getNativeCapabilities(), CachedCapabilitiesType.class, prismContext));
            jaxb.setScripts(RUtil.toJAXB(ResourceType.class, new PropertyPath(new QName[]{ResourceType.F_SCRIPTS}), repo.getScripts(), ScriptsType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(ResourceType jaxb, RResource repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setNamespace(ResourceTypeUtil.getResourceNamespace((ResourceType)jaxb));
        repo.setConnectorRef(RUtil.jaxbRefToRepo(jaxb.getConnectorRef(), repo, prismContext));
        if (jaxb.getConnector() != null) {
            LOGGER.warn("Connector from resource type won't be saved. It should be translated to connector reference.");
        }
        try {
            repo.setConfiguration(RUtil.toRepo(jaxb.getConfiguration(), prismContext));
            repo.setXmlSchema(RUtil.toRepo(jaxb.getSchema(), prismContext));
            repo.setSchemaHandling(RUtil.toRepo(jaxb.getSchemaHandling(), prismContext));
            repo.setSynchronization(RUtil.toRepo(jaxb.getSynchronization(), prismContext));
            repo.setCapabilities(RUtil.toRepo(jaxb.getCapabilities(), prismContext));
            repo.setNativeCapabilities(RUtil.toRepo(jaxb.getNativeCapabilities(), prismContext));
            repo.setScripts(RUtil.toRepo(jaxb.getScripts(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public ResourceType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        ResourceType object = new ResourceType();
        RUtil.revive((Objectable)object, prismContext);
        RResource.copyToJAXB(this, object, prismContext);
        return object;
    }
}

