/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RAnyContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.query.QueryEntity;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExtensionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_container")
public abstract class RObject
extends RContainer {
    @QueryAttribute
    private String description;
    @QueryEntity(any=true)
    private RAnyContainer extension;
    private long version;

    @OneToOne(optional=true, orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="extOid", referencedColumnName="owner_oid"), @JoinColumn(name="extId", referencedColumnName="owner_id"), @JoinColumn(name="extType", referencedColumnName="ownerType")})
    public RAnyContainer getExtension() {
        return this.extension;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExtension(RAnyContainer extension) {
        this.extension = extension;
        if (this.extension != null) {
            this.extension.setOwnerType(RContainerType.OBJECT);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RObject rObject = (RObject)o;
        if (this.description != null ? !this.description.equals(rObject.description) : rObject.description != null) {
            return false;
        }
        return !(this.extension != null ? !this.extension.equals(rObject.extension) : rObject.extension != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RObject repo, ObjectType jaxb, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        jaxb.setDescription(repo.getDescription());
        jaxb.setOid(repo.getOid());
        jaxb.setVersion(Long.toString(repo.getVersion()));
        if (repo.getExtension() != null) {
            ExtensionType extension = new ExtensionType();
            jaxb.setExtension(extension);
            RAnyContainer.copyToJAXB(repo.getExtension(), extension, prismContext);
        }
    }

    public static void copyFromJAXB(ObjectType jaxb, RObject repo, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        repo.setDescription(jaxb.getDescription());
        repo.setOid(jaxb.getOid());
        repo.setId(0L);
        String strVersion = jaxb.getVersion();
        long version = StringUtils.isNotEmpty((String)strVersion) && strVersion.matches("[0-9]*") ? Long.parseLong(jaxb.getVersion()) : 0L;
        repo.setVersion(version);
        if (jaxb.getExtension() != null) {
            RAnyContainer extension = new RAnyContainer();
            extension.setOwner(repo);
            repo.setExtension(extension);
            RAnyContainer.copyFromJAXB(jaxb.getExtension(), extension, prismContext);
        }
    }

    public abstract <T extends ObjectType> T toJAXB(PrismContext var1) throws DtoTranslationException;
}

