/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Type;

@Embeddable
public class RCredentials {
    private String password;
    private Boolean allowedIdmAdminGuiAccess;

    @Column(nullable=true)
    public Boolean isAllowedIdmAdminGuiAccess() {
        return this.allowedIdmAdminGuiAccess;
    }

    public void setAllowedIdmAdminGuiAccess(Boolean allowedIdmAdminGuiAccess) {
        this.allowedIdmAdminGuiAccess = allowedIdmAdminGuiAccess;
    }

    @Type(type="org.hibernate.type.TextType")
    @Column(name="passwordXml", nullable=true)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RCredentials that = (RCredentials)o;
        if (this.allowedIdmAdminGuiAccess != null ? !this.allowedIdmAdminGuiAccess.equals(that.allowedIdmAdminGuiAccess) : that.allowedIdmAdminGuiAccess != null) {
            return false;
        }
        return !(this.password != null ? !this.password.equals(that.password) : that.password != null);
    }

    public int hashCode() {
        int result = this.password != null ? this.password.hashCode() : 0;
        result = 31 * result + (this.allowedIdmAdminGuiAccess != null ? this.allowedIdmAdminGuiAccess.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static void copyToJAXB(RCredentials repo, CredentialsType jaxb, ObjectType parent, PropertyPath path, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        try {
            jaxb.setAllowedIdmAdminGuiAccess(repo.isAllowedIdmAdminGuiAccess());
            PropertyPath passwordPath = new PropertyPath(path, CredentialsType.F_PASSWORD);
            jaxb.setPassword(RUtil.toJAXB(parent.getClass(), passwordPath, repo.getPassword(), PasswordType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(CredentialsType jaxb, RCredentials repo, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        try {
            repo.setAllowedIdmAdminGuiAccess(jaxb.isAllowedIdmAdminGuiAccess());
            repo.setPassword(RUtil.toRepo(jaxb.getPassword(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public CredentialsType toJAXB(ObjectType parent, PropertyPath path, PrismContext prismContext) throws DtoTranslationException {
        CredentialsType credentials = new CredentialsType();
        RCredentials.copyToJAXB(this, credentials, parent, path, prismContext);
        return credentials;
    }
}

