/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure1;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure11;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure13;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure15;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure17;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure19;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure21;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure3;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure5;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure7;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl$AjcClosure9;
import com.evolveum.midpoint.repo.sql.data.common.RAnyContainer;
import com.evolveum.midpoint.repo.sql.data.common.RAssignment;
import com.evolveum.midpoint.repo.sql.data.common.RContainerId;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.data.common.RExclusion;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.RResourceObjectShadow;
import com.evolveum.midpoint.repo.sql.data.common.RTask;
import com.evolveum.midpoint.repo.sql.data.common.RTaskExclusivityStatusType;
import com.evolveum.midpoint.repo.sql.data.common.RUser;
import com.evolveum.midpoint.repo.sql.query.Definition;
import com.evolveum.midpoint.repo.sql.query.EntityDefinition;
import com.evolveum.midpoint.repo.sql.query.QueryException;
import com.evolveum.midpoint.repo.sql.query.QueryInterpreter;
import com.evolveum.midpoint.repo.sql.query.QueryRegistry;
import com.evolveum.midpoint.repo.sql.util.ClassMapper;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.ConcurrencyException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskExclusivityStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.hibernate.Criteria;
import org.hibernate.PessimisticLockException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate4.HibernateOptimisticLockingFailureException;
import org.springframework.stereotype.Repository;

@Repository
public class SqlRepositoryServiceImpl
implements RepositoryService {
    private static final Trace LOGGER;
    private static final int LOCKING_MAX_ATTEMPTS = 10;
    private static final long LOCKING_TIMEOUT = 0L;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private SessionFactory sessionFactory;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        SqlRepositoryServiceImpl.ajc$preClinit();
        LOGGER = TraceManager.getTrace(SqlRepositoryServiceImpl.class);
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.fixCompositeIdentifierInMetaModel(RAnyContainer.class);
        this.fixCompositeIdentifierInMetaModel(RObjectReference.class);
        this.fixCompositeIdentifierInMetaModel(RAssignment.class);
        this.fixCompositeIdentifierInMetaModel(RExclusion.class);
        for (RContainerType type : ClassMapper.getKnownTypes()) {
            this.fixCompositeIdentifierInMetaModel(type.getClazz());
        }
        this.sessionFactory = sessionFactory;
    }

    private void fixCompositeIdentifierInMetaModel(Class clazz) {
        ClassMetadata classMetadata = this.sessionFactory.getClassMetadata(clazz);
        if (classMetadata instanceof AbstractEntityPersister) {
            AbstractEntityPersister persister = (AbstractEntityPersister)classMetadata;
            EntityMetamodel model = persister.getEntityMetamodel();
            IdentifierProperty identifier = model.getIdentifierProperty();
            try {
                Field field = IdentifierProperty.class.getDeclaredField("hasIdentifierMapper");
                field.setAccessible(true);
                field.set(identifier, true);
                field.setAccessible(false);
            }
            catch (Exception ex) {
                throw new SystemException("Attempt to fix entity meta model with hack failed, reason: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private <T extends ObjectType> PrismObject<T> getObject(Session session, Class<T> type, String oid) throws ObjectNotFoundException, SchemaException, DtoTranslationException {
        Criteria query = session.createCriteria(ClassMapper.getHQLTypeClass(type));
        query.add((Criterion)Restrictions.eq((String)"oid", (Object)oid));
        query.add((Criterion)Restrictions.eq((String)"id", (Object)0L));
        RObject object = (RObject)query.uniqueResult();
        if (object == null) {
            throw new ObjectNotFoundException("Object of type '" + type.getSimpleName() + "' with oid '" + oid + "' was not found.", null, oid);
        }
        LOGGER.debug("Transforming data to JAXB type.");
        PrismObject objectType = object.toJAXB(this.prismContext).asPrismObject();
        this.validateObjectType(objectType, type);
        return objectType;
    }

    public <T extends ObjectType> PrismObject<T> getObject(Class<T> type, String oid, OperationResult result) throws ObjectNotFoundException, SchemaException {
        Class<T> clazz = type;
        String string = oid;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, string, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private <T extends ObjectType> PrismObject<T> getObjectAttempt(Class<T> type, String oid, OperationResult result) throws ObjectNotFoundException, SchemaException {
        PrismObject<T> objectType;
        block11: {
            LOGGER.debug("Getting object '{}' with oid '{}'.", new Object[]{type.getSimpleName(), oid});
            objectType = null;
            Session session = null;
            try {
                try {
                    session = this.beginTransaction();
                    objectType = this.getObject(session, type, oid);
                    session.getTransaction().commit();
                }
                catch (PessimisticLockException ex) {
                    this.rollbackTransaction(session);
                    throw ex;
                }
                catch (LockAcquisitionException ex) {
                    this.rollbackTransaction(session);
                    throw ex;
                }
                catch (HibernateOptimisticLockingFailureException ex) {
                    this.rollbackTransaction(session);
                    throw ex;
                }
                catch (ObjectNotFoundException ex) {
                    this.rollbackTransaction(session, (Exception)((Object)ex), result);
                    throw ex;
                }
                catch (Exception ex) {
                    if (ex instanceof SchemaException) {
                        throw (SchemaException)((Object)ex);
                    }
                    this.handleGeneralException(ex, session, result);
                    this.cleanupSessionAndResult(session, result);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.cleanupSessionAndResult(session, result);
                throw throwable;
            }
            this.cleanupSessionAndResult(session, result);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Get object:\n{}", new Object[]{objectType != null ? objectType.debugDump(3) : null});
        }
        return objectType;
    }

    @Deprecated
    public <T extends ObjectType> List<PrismObject<T>> listObjects(Class<T> type, PagingType paging, OperationResult result) {
        Class<T> clazz = type;
        PagingType pagingType = paging;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public PrismObject<UserType> listAccountShadowOwner(String accountOid, OperationResult result) throws ObjectNotFoundException {
        String string = accountOid;
        OperationResult operationResult = result;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)operationResult);
        Object[] objectArray = new Object[]{this, string, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    private PrismObject<UserType> listAccountShadowOwnerAttempt(String accountOid, OperationResult result) throws ObjectNotFoundException {
        List users;
        Session session;
        UserType userType;
        block9: {
            userType = null;
            session = null;
            session = this.beginTransaction();
            LOGGER.debug("Selecting account shadow owner for account {}.", new Object[]{accountOid});
            Query query = session.createQuery("select user from " + ClassMapper.getHQLType(UserType.class) + " as user left join user.accountRefs as ref where ref.targetOid = :oid");
            query.setString("oid", accountOid);
            users = query.list();
            LOGGER.debug("Found {} users, transforming data to JAXB types.", new Object[]{users != null ? users.size() : 0});
            if (users != null && !users.isEmpty()) break block9;
            this.cleanupSessionAndResult(session, result);
            return null;
        }
        try {
            try {
                if (users.size() > 1) {
                    LOGGER.warn("Found {} users for account oid {}, returning first user. [interface change needed]", new Object[]{users.size(), accountOid});
                }
                RUser user = (RUser)users.get(0);
                userType = user.toJAXB(this.prismContext);
                session.getTransaction().commit();
            }
            catch (PessimisticLockException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (LockAcquisitionException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (HibernateOptimisticLockingFailureException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (Exception ex) {
                this.handleGeneralException(ex, session, result);
                this.cleanupSessionAndResult(session, result);
            }
        }
        catch (Throwable throwable) {
            this.cleanupSessionAndResult(session, result);
            throw throwable;
        }
        this.cleanupSessionAndResult(session, result);
        return userType.asPrismObject();
    }

    private void validateName(PrismObject object) throws SchemaException {
        PrismProperty name = object.findProperty(ObjectType.F_NAME);
        if (name == null || StringUtils.isEmpty((String)((String)name.getRealValue()))) {
            throw new SchemaException("Attempt to add object without name.");
        }
    }

    public <T extends ObjectType> String addObject(PrismObject<T> object, OperationResult result) throws ObjectAlreadyExistsException, SchemaException {
        PrismObject<T> prismObject = object;
        OperationResult operationResult = result;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, prismObject, (Object)operationResult);
        Object[] objectArray = new Object[]{this, prismObject, operationResult, joinPoint};
        return (String)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    private <T extends ObjectType> String addObjectAttempt(PrismObject<T> object, OperationResult result) throws ObjectAlreadyExistsException, SchemaException {
        String oid;
        block14: {
            LOGGER.debug("Adding object type '{}'", new Object[]{object.getCompileTimeClass().getSimpleName()});
            oid = null;
            Session session = null;
            try {
                try {
                    ObjectType objectType = (ObjectType)object.asObjectable();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Object\n{}", new Object[]{this.prismContext.silentMarshalObject((Object)objectType)});
                    }
                    session = this.beginTransaction();
                    if (StringUtils.isNotEmpty((String)objectType.getOid())) {
                        LOGGER.debug("Checking oid uniqueness.");
                        Criteria criteria = session.createCriteria(ClassMapper.getHQLTypeClass(object.getCompileTimeClass()));
                        criteria.add((Criterion)Restrictions.eq((String)"oid", (Object)object.getOid()));
                        criteria.setProjection(Projections.rowCount());
                        Long count = (Long)criteria.uniqueResult();
                        if (count != null && count > 0L) {
                            throw new ObjectAlreadyExistsException("Object '" + object.getCompileTimeClass().getSimpleName() + "' with oid '" + object.getOid() + "' already exists.");
                        }
                    }
                    LOGGER.debug("Translating JAXB to data type.");
                    RObject rObject = this.createDataObjectFromJAXB(objectType);
                    LOGGER.debug("Saving object.");
                    RContainerId containerId = (RContainerId)session.save((Object)rObject);
                    oid = containerId.getOid();
                    session.getTransaction().commit();
                    LOGGER.debug("Saved object '{}' with oid '{}'", new Object[]{object.getCompileTimeClass().getSimpleName(), oid});
                }
                catch (PessimisticLockException ex) {
                    this.rollbackTransaction(session);
                    throw ex;
                }
                catch (LockAcquisitionException ex) {
                    this.rollbackTransaction(session);
                    throw ex;
                }
                catch (HibernateOptimisticLockingFailureException ex) {
                    this.rollbackTransaction(session);
                    throw ex;
                }
                catch (ObjectAlreadyExistsException ex) {
                    this.rollbackTransaction(session, (Exception)((Object)ex), result);
                    throw ex;
                }
                catch (ConstraintViolationException ex) {
                    this.rollbackTransaction(session, (Exception)((Object)ex), result);
                    throw new ObjectAlreadyExistsException((Throwable)ex);
                }
                catch (Exception ex) {
                    if (ex instanceof SchemaException) {
                        throw (SchemaException)((Object)ex);
                    }
                    this.handleGeneralException(ex, session, result);
                    this.cleanupSessionAndResult(session, result);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.cleanupSessionAndResult(session, result);
                throw throwable;
            }
            this.cleanupSessionAndResult(session, result);
        }
        return oid;
    }

    public <T extends ObjectType> void deleteObject(Class<T> type, String oid, OperationResult result) throws ObjectNotFoundException {
        Class<T> clazz = type;
        String string = oid;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, string, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private <T extends ObjectType> void deleteObjectAttempt(Class<T> type, String oid, OperationResult result) throws ObjectNotFoundException {
        LOGGER.debug("Deleting object type '{}' with oid '{}'", new Object[]{type.getSimpleName(), oid});
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                Criteria query = session.createCriteria(ClassMapper.getHQLTypeClass(type));
                query.add((Criterion)Restrictions.eq((String)"oid", (Object)oid));
                query.add((Criterion)Restrictions.eq((String)"id", (Object)0L));
                RObject object = (RObject)query.uniqueResult();
                if (object == null) {
                    throw new ObjectNotFoundException("Object of type '" + type.getSimpleName() + "' with oid '" + oid + "' was not found.", null, oid);
                }
                session.delete((Object)object);
                session.getTransaction().commit();
            }
            catch (PessimisticLockException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (LockAcquisitionException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (HibernateOptimisticLockingFailureException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (ObjectNotFoundException ex) {
                this.rollbackTransaction(session, (Exception)((Object)ex), result);
                throw ex;
            }
            catch (Exception ex) {
                this.handleGeneralException(ex, session, result);
                this.cleanupSessionAndResult(session, result);
            }
        }
        finally {
            this.cleanupSessionAndResult(session, result);
        }
    }

    @Deprecated
    public void claimTask(String oid, OperationResult result) throws ObjectNotFoundException, ConcurrencyException, SchemaException {
        String string = oid;
        OperationResult operationResult = result;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)operationResult);
        Object[] objectArray = new Object[]{this, string, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Deprecated
    public void releaseTask(String oid, OperationResult result) throws ObjectNotFoundException, SchemaException {
        String string = oid;
        OperationResult operationResult = result;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)operationResult);
        Object[] objectArray = new Object[]{this, string, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> int countObjects(Class<T> type, QueryType query, OperationResult result) {
        Class<T> clazz = type;
        QueryType queryType = query;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, queryType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, operationResult, joinPoint};
        return Conversions.intValue((Object)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    private <T extends ObjectType> int countObjectsAttempt(Class<T> type, QueryType query, OperationResult result) {
        int count = 0;
        Session session = null;
        try {
            try {
                Criteria criteria;
                session = this.beginTransaction();
                LOGGER.debug("Updating query criteria.");
                if (query != null && query.getFilter() != null) {
                    QueryInterpreter interpreter = new QueryInterpreter(session, type, this.prismContext);
                    criteria = interpreter.interpret(query.getFilter());
                } else {
                    criteria = session.createCriteria(ClassMapper.getHQLTypeClass(type));
                }
                criteria.setProjection(Projections.rowCount());
                LOGGER.debug("Selecting total count.");
                Long longCount = (Long)criteria.uniqueResult();
                count = longCount.intValue();
            }
            catch (PessimisticLockException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (LockAcquisitionException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (HibernateOptimisticLockingFailureException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (Exception ex) {
                this.handleGeneralException(ex, session, result);
                this.cleanupSessionAndResult(session, result);
            }
        }
        finally {
            this.cleanupSessionAndResult(session, result);
        }
        return count;
    }

    public <T extends ObjectType> List<PrismObject<T>> searchObjects(Class<T> type, QueryType query, PagingType paging, OperationResult result) throws SchemaException {
        Class<T> clazz = type;
        QueryType queryType = query;
        PagingType pagingType = paging;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, queryType, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private <T extends ObjectType> List<PrismObject<T>> searchObjectsAttempt(Class<T> type, QueryType query, PagingType paging, OperationResult result) throws SchemaException {
        ArrayList<PrismObject<T>> list = new ArrayList<PrismObject<T>>();
        Session session = null;
        try {
            try {
                Criteria criteria;
                session = this.beginTransaction();
                LOGGER.debug("Updating query criteria.");
                if (query != null && query.getFilter() != null) {
                    QueryInterpreter interpreter = new QueryInterpreter(session, type, this.prismContext);
                    criteria = interpreter.interpret(query.getFilter());
                } else {
                    criteria = session.createCriteria(ClassMapper.getHQLTypeClass(type));
                }
                criteria = this.updatePagingAndSorting(criteria, type, paging);
                List objects = criteria.list();
                LOGGER.debug("Found {} objects, translating to JAXB.", new Object[]{objects != null ? objects.size() : 0});
                for (RObject object : objects) {
                    Object objectType = object.toJAXB(this.prismContext);
                    PrismObject prismObject = objectType.asPrismObject();
                    this.validateObjectType(prismObject, type);
                    list.add(prismObject);
                }
                session.getTransaction().commit();
            }
            catch (PessimisticLockException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (LockAcquisitionException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (HibernateOptimisticLockingFailureException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (Exception ex) {
                if (ex instanceof SchemaException) {
                    throw (SchemaException)((Object)ex);
                }
                this.handleGeneralException(ex, session, result);
                this.cleanupSessionAndResult(session, result);
            }
        }
        finally {
            this.cleanupSessionAndResult(session, result);
        }
        return list;
    }

    public <T extends ObjectType> void modifyObject(Class<T> type, String oid, Collection<? extends ItemDelta> modifications, OperationResult result) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        Class<T> clazz = type;
        String string = oid;
        Collection<? extends ItemDelta> collection = modifications;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, string, collection, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, collection, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private int logOperationAttempt(String oid, String operation, int attempt, RuntimeException ex, OperationResult result) {
        if (!(ex instanceof PessimisticLockException || ex instanceof LockAcquisitionException || ex instanceof HibernateOptimisticLockingFailureException)) {
            if (ex instanceof GenericJDBCException) {
                GenericJDBCException jdbcEx = (GenericJDBCException)ex;
                if (jdbcEx.getErrorCode() != 50200) {
                    throw new SystemException((Throwable)ex);
                }
            } else {
                throw ex;
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("A locking-related problem occurred when {} object with oid '{}', retrying after {}ms (this was attempt {} of {})\n{}: {}", new Object[]{operation, oid, 0L, attempt, 10, ex.getClass().getSimpleName(), ex.getMessage()});
        }
        if (attempt >= 10) {
            if (ex != null && result != null) {
                result.recordFatalError("A locking-related problem occurred.", (Throwable)ex);
            }
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
        return ++attempt;
    }

    private <T extends ObjectType> void modifyObjectAttempt(Class<T> type, String oid, Collection<? extends ItemDelta> modifications, OperationResult result) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        LOGGER.debug("Modifying object '{}' with oid '{}'.", new Object[]{type.getSimpleName(), oid});
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Modifications: {}", new Object[]{DebugUtil.prettyPrint(modifications)});
        }
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                PrismObject<T> prismObject = this.getObject(session, type, oid);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("OBJECT before:\n{}", new Object[]{prismObject.dump()});
                }
                PropertyDelta.applyTo(modifications, prismObject);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("OBJECT after:\n{}", (Object)prismObject.dump());
                }
                LOGGER.debug("Translating JAXB to data type.");
                RObject rObject = this.createDataObjectFromJAXB((ObjectType)prismObject.asObjectable());
                rObject.setVersion(rObject.getVersion() + 1L);
                session.merge((Object)rObject);
                session.getTransaction().commit();
            }
            catch (PessimisticLockException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (LockAcquisitionException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (HibernateOptimisticLockingFailureException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (ObjectNotFoundException ex) {
                this.rollbackTransaction(session, (Exception)((Object)ex), result);
                throw ex;
            }
            catch (ConstraintViolationException ex) {
                this.rollbackTransaction(session, (Exception)((Object)ex), result);
                throw new ObjectAlreadyExistsException((Throwable)ex);
            }
            catch (Exception ex) {
                if (ex instanceof SchemaException) {
                    throw (SchemaException)((Object)ex);
                }
                this.handleGeneralException(ex, session, result);
                this.cleanupSessionAndResult(session, result);
            }
        }
        finally {
            this.cleanupSessionAndResult(session, result);
        }
    }

    public <T extends ResourceObjectShadowType> List<PrismObject<T>> listResourceObjectShadows(String resourceOid, Class<T> resourceObjectShadowType, OperationResult result) throws ObjectNotFoundException {
        String string = resourceOid;
        Class<T> clazz = resourceObjectShadowType;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{string, clazz, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, clazz, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processRepositoryNdc(new SqlRepositoryServiceImpl$AjcClosure21(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private <T extends ResourceObjectShadowType> List<PrismObject<T>> listResourceObjectShadowsAttempt(String resourceOid, Class<T> resourceObjectShadowType, OperationResult result) throws ObjectNotFoundException {
        ArrayList<PrismObject<T>> list = new ArrayList<PrismObject<T>>();
        Session session = null;
        try {
            try {
                session = this.beginTransaction();
                Query query = session.createQuery("select shadow from " + ClassMapper.getHQLType(resourceObjectShadowType) + " as shadow left join shadow.resourceRef as ref where ref.oid = :oid");
                query.setString("oid", resourceOid);
                List shadows = query.list();
                LOGGER.debug("Query returned {} shadows, transforming to JAXB types.", new Object[]{shadows != null ? shadows.size() : 0});
                if (shadows != null) {
                    for (RResourceObjectShadow shadow : shadows) {
                        ResourceObjectShadowType jaxb = shadow.toJAXB(this.prismContext);
                        PrismObject prismObject = jaxb.asPrismObject();
                        this.validateObjectType(prismObject, resourceObjectShadowType);
                        list.add(prismObject);
                    }
                }
                session.getTransaction().commit();
                LOGGER.debug("Done.");
            }
            catch (PessimisticLockException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (LockAcquisitionException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (HibernateOptimisticLockingFailureException ex) {
                this.rollbackTransaction(session);
                throw ex;
            }
            catch (Exception ex) {
                this.handleGeneralException(ex, session, result);
                this.cleanupSessionAndResult(session, result);
            }
        }
        finally {
            this.cleanupSessionAndResult(session, result);
        }
        return list;
    }

    @Deprecated
    private void updateTaskExclusivity(String oid, TaskExclusivityStatusType newStatus, OperationResult result) throws ObjectNotFoundException {
        block8: {
            LOGGER.debug("Updating task '{}' exclusivity to '{}'", new Object[]{oid, newStatus});
            Session session = null;
            try {
                try {
                    LOGGER.debug("Looking for task.");
                    session = this.beginTransaction();
                    Query query = session.createQuery("from " + ClassMapper.getHQLType(TaskType.class) + " as task where task.oid = :oid and task.id = 0");
                    query.setString("oid", oid);
                    RTask task = (RTask)query.uniqueResult();
                    if (task == null) {
                        throw new ObjectNotFoundException("Task with oid '" + oid + "' was not found.");
                    }
                    LOGGER.debug("Task found, updating exclusivity status.");
                    task.setExclusivityStatus(RTaskExclusivityStatusType.toRepoType(newStatus));
                    session.save((Object)task);
                    session.getTransaction().commit();
                    LOGGER.debug("Task status updated.");
                }
                catch (HibernateOptimisticLockingFailureException ex) {
                    this.rollbackTransaction(session, (Exception)((Object)ex), result);
                    throw new SystemException(ex.getMessage(), (Throwable)ex);
                }
                catch (ObjectNotFoundException ex) {
                    this.rollbackTransaction(session, (Exception)((Object)ex), result);
                    throw ex;
                }
                catch (Exception ex) {
                    this.handleGeneralException(ex, session, result);
                    this.cleanupSessionAndResult(session, result);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.cleanupSessionAndResult(session, result);
                throw throwable;
            }
            this.cleanupSessionAndResult(session, result);
        }
    }

    private <T extends ObjectType> void validateObjectType(PrismObject<T> prismObject, Class<T> type) {
        if (prismObject == null || !type.isAssignableFrom(prismObject.getCompileTimeClass())) {
            throw new SystemException("Result ('" + prismObject.toDebugName() + "') is not assignable to '" + type.getSimpleName() + "' [really should not happen].");
        }
    }

    private <T extends ObjectType> RObject createDataObjectFromJAXB(T object) throws SchemaException {
        RObject rObject;
        Class<? extends RObject> clazz = ClassMapper.getHQLTypeClass(object.getClass());
        try {
            rObject = clazz.newInstance();
            Method method = clazz.getMethod("copyFromJAXB", object.getClass(), clazz, PrismContext.class);
            method.invoke(clazz, object, rObject, this.prismContext);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (StringUtils.isEmpty((String)message) && ex.getCause() != null) {
                message = ex.getCause().getMessage();
            }
            throw new SchemaException(message, (Throwable)ex);
        }
        return rObject;
    }

    private <T extends ObjectType> Criteria updatePagingAndSorting(Criteria query, Class<T> type, PagingType paging) {
        if (paging == null) {
            return query;
        }
        if (paging.getOffset() != null) {
            query = query.setFirstResult(paging.getOffset().intValue());
        }
        if (paging.getMaxSize() != null) {
            query = query.setMaxResults(paging.getMaxSize().intValue());
        }
        if (paging.getOrderDirection() == null && paging.getOrderBy() == null) {
            return query;
        }
        try {
            QueryRegistry registry = QueryRegistry.getInstance();
            PropertyPath path = new XPathHolder(paging.getOrderBy()).toPropertyPath();
            if (path == null || path.size() != 1) {
                LOGGER.warn("Ordering by property path with size not equal 1 is not supported '" + path + "'.");
                return query;
            }
            EntityDefinition definition = registry.findDefinition(ObjectTypes.getObjectType(type).getQName());
            Definition def = definition.findDefinition(path.first().getName());
            if (def == null) {
                LOGGER.warn("Unknown path '" + path + "', couldn't find definition for it, " + "list will not be ordered by it.");
                return query;
            }
            switch (paging.getOrderDirection()) {
                case ASCENDING: {
                    query = query.addOrder(Order.asc((String)def.getRealName()));
                    break;
                }
                case DESCENDING: {
                    query = query.addOrder(Order.desc((String)def.getRealName()));
                }
            }
        }
        catch (QueryException ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
        return query;
    }

    private Session beginTransaction() {
        Session session = this.sessionFactory.openSession();
        session.beginTransaction();
        return session;
    }

    private void rollbackTransaction(Session session) {
        this.rollbackTransaction(session, null, null);
    }

    private void rollbackTransaction(Session session, Exception ex, OperationResult result) {
        if (session == null || session.getTransaction() == null || !session.getTransaction().isActive()) {
            return;
        }
        session.getTransaction().rollback();
        if (ex != null && result != null) {
            result.recordFatalError(ex.getMessage(), (Throwable)ex);
        }
    }

    private void cleanupSessionAndResult(Session session, OperationResult result) {
        if (session != null && session.isOpen()) {
            session.close();
        }
        if (result.isUnknown()) {
            result.computeStatus();
        }
    }

    private void handleGeneralException(Exception ex, Session session, OperationResult result) {
        this.rollbackTransaction(session, ex, result);
        if (ex instanceof GenericJDBCException) {
            throw (GenericJDBCException)ex;
        }
        if (ex instanceof SystemException) {
            throw (SystemException)ex;
        }
        throw new SystemException(ex.getMessage(), (Throwable)ex);
    }

    static final /* synthetic */ PrismObject getObject_aroundBody0(SqlRepositoryServiceImpl ajc$this, Class type, String oid, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)type, (String)"Object type must not be null.");
        Validate.notEmpty((String)oid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        int attempt = 1;
        OperationResult subResult = result.createSubresult(RepositoryService.GET_OBJECT);
        subResult.addParam("type", (Object)type.getName());
        subResult.addParam("oid", (Object)oid);
        while (true) {
            try {
                return ajc$this.getObjectAttempt(type, oid, subResult);
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(oid, "getting", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ List listObjects_aroundBody2(SqlRepositoryServiceImpl ajc$this, Class type, PagingType paging, OperationResult result, JoinPoint joinPoint) {
        try {
            return ajc$this.searchObjects(type, null, paging, result);
        }
        catch (SchemaException ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    static final /* synthetic */ PrismObject listAccountShadowOwner_aroundBody4(SqlRepositoryServiceImpl ajc$this, String accountOid, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)accountOid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        int attempt = 1;
        OperationResult subResult = result.createSubresult(RepositoryService.LIST_ACCOUNT_SHADOW);
        subResult.addParam("accountOid", (Object)accountOid);
        while (true) {
            try {
                return ajc$this.listAccountShadowOwnerAttempt(accountOid, subResult);
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(accountOid, "listing account shadow owner", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ String addObject_aroundBody6(SqlRepositoryServiceImpl ajc$this, PrismObject object, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)object, (String)"Object must not be null.");
        ajc$this.validateName(object);
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        OperationResult subResult = result.createSubresult(RepositoryService.ADD_OBJECT);
        subResult.addParam("object", (Object)object);
        int attempt = 1;
        String oid = object.getOid();
        while (true) {
            try {
                return ajc$this.addObjectAttempt(object, subResult);
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(oid, "adding", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ void deleteObject_aroundBody8(SqlRepositoryServiceImpl ajc$this, Class type, String oid, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)type, (String)"Object type must not be null.");
        Validate.notEmpty((String)oid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        int attempt = 1;
        OperationResult subResult = result.createSubresult(RepositoryService.DELETE_OBJECT);
        subResult.addParam("type", (Object)type.getName());
        subResult.addParam("oid", (Object)oid);
        while (true) {
            try {
                ajc$this.deleteObjectAttempt(type, oid, subResult);
                return;
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(oid, "deleting", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ void claimTask_aroundBody10(SqlRepositoryServiceImpl ajc$this, String oid, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)oid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        OperationResult subResult = result.createSubresult(RepositoryService.CLAIM_TASK);
        ajc$this.updateTaskExclusivity(oid, TaskExclusivityStatusType.CLAIMED, subResult);
    }

    static final /* synthetic */ void releaseTask_aroundBody12(SqlRepositoryServiceImpl ajc$this, String oid, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)oid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        OperationResult subResult = result.createSubresult(RepositoryService.RELEASE_TASK);
        ajc$this.updateTaskExclusivity(oid, TaskExclusivityStatusType.RELEASED, subResult);
    }

    static final /* synthetic */ int countObjects_aroundBody14(SqlRepositoryServiceImpl ajc$this, Class type, QueryType query, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)type, (String)"Object type must not be null.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        LOGGER.debug("Counting objects of type '{}', query (on trace level).", new Object[]{type});
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Full query\n{}", new Object[]{query == null ? "undefined" : ajc$this.prismContext.silentMarshalObject((Object)query)});
        }
        OperationResult subResult = result.createSubresult(RepositoryService.COUNT_OBJECTS);
        subResult.addParam("type", (Object)type.getName());
        subResult.addParam("query", (Object)query);
        int attempt = 1;
        while (true) {
            try {
                return ajc$this.countObjectsAttempt(type, query, subResult);
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(null, "counting", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ List searchObjects_aroundBody16(SqlRepositoryServiceImpl ajc$this, Class type, QueryType query, PagingType paging, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)type, (String)"Object type must not be null.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        LOGGER.debug("Searching objects of type '{}', query (on trace level), offset {}, count {}.", new Object[]{type.getSimpleName(), paging == null ? "undefined" : paging.getOffset(), paging == null ? "undefined" : paging.getMaxSize()});
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Full query\n{}\nFull paging\n{}", new Object[]{query == null ? "undefined" : ajc$this.prismContext.silentMarshalObject((Object)query), paging == null ? "undefined" : ajc$this.prismContext.silentMarshalObject((Object)paging)});
        }
        OperationResult subResult = result.createSubresult(RepositoryService.SEARCH_OBJECTS);
        subResult.addParam("type", (Object)type.getName());
        subResult.addParam("query", (Object)query);
        subResult.addParam("paging", (Object)paging);
        int attempt = 1;
        while (true) {
            try {
                return ajc$this.searchObjectsAttempt(type, query, paging, subResult);
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(null, "searching", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ void modifyObject_aroundBody18(SqlRepositoryServiceImpl ajc$this, Class type, String oid, Collection modifications, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)modifications, (String)"Modifications must not be null.");
        Validate.notNull((Object)type, (String)"Object class in delta must not be null.");
        Validate.notEmpty((String)oid, (String)"Oid must not null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        OperationResult subResult = result.createSubresult(RepositoryService.MODIFY_OBJECT);
        subResult.addParam("type", (Object)type.getName());
        subResult.addParam("oid", (Object)oid);
        subResult.addParam("modifications", (Object)modifications);
        if (modifications.isEmpty()) {
            subResult.recordStatus(OperationResultStatus.SUCCESS, "Modification list is empty, nothing was modified.");
            return;
        }
        int attempt = 1;
        while (true) {
            try {
                ajc$this.modifyObjectAttempt(type, oid, modifications, subResult);
                return;
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(oid, "modifying", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    static final /* synthetic */ List listResourceObjectShadows_aroundBody20(SqlRepositoryServiceImpl ajc$this, String resourceOid, Class resourceObjectShadowType, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)resourceOid, (String)"Resource oid must not be null or empty.");
        Validate.notNull((Object)resourceObjectShadowType, (String)"Resource object shadow type must not be null.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        LOGGER.debug("Listing resource object shadows '{}' for resource '{}'.", new Object[]{resourceObjectShadowType.getSimpleName(), resourceOid});
        OperationResult subResult = result.createSubresult(RepositoryService.LIST_RESOURCE_OBJECT_SHADOWS);
        subResult.addParam("oid", (Object)resourceOid);
        subResult.addParam("resourceObjectShadowType", (Object)resourceObjectShadowType);
        int attempt = 1;
        while (true) {
            try {
                return ajc$this.listResourceObjectShadowsAttempt(resourceOid, resourceObjectShadowType, subResult);
            }
            catch (RuntimeException ex) {
                attempt = ajc$this.logOperationAttempt(resourceOid, "listing resource object shadows", attempt, ex, subResult);
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SqlRepositoryServiceImpl.java", SqlRepositoryServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.Class:java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "com.evolveum.midpoint.prism.PrismObject"), 157);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listObjects", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.Class:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "type:paging:result", "", "java.util.List"), 222);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listResourceObjectShadows", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.String:java.lang.Class:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:resourceObjectShadowType:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "java.util.List"), 754);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listAccountShadowOwner", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "accountOid:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "com.evolveum.midpoint.prism.PrismObject"), 232);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addObject", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "com.evolveum.midpoint.prism.PrismObject:com.evolveum.midpoint.schema.result.OperationResult", "object:result", "com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException:com.evolveum.midpoint.util.exception.SchemaException", "java.lang.String"), 307);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteObject", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.Class:java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "void"), 396);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "claimTask", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "oid:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.ConcurrencyException:com.evolveum.midpoint.util.exception.SchemaException", "void"), 458);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "releaseTask", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "oid:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "void"), 469);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countObjects", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.schema.result.OperationResult", "type:query:result", "", "int"), 478);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchObjects", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "type:query:paging:result", "com.evolveum.midpoint.util.exception.SchemaException", "java.util.List"), 543);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "modifyObject", "com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl", "java.lang.Class:java.lang.String:java.util.Collection:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:modifications:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException", "void"), 626);
    }
}

