/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.aggregation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.resource.aggregation.ResourceReferenceAndStringData;
import org.apache.wicket.resource.aggregation.ResourceReferenceCollection;
import org.apache.wicket.resource.dependencies.AbstractResourceDependentResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceAggregatingHeaderResponse<R extends ResourceReferenceCollection, K>
extends DecoratingHeaderResponse {
    private final List<ResourceReferenceAndStringData> topLevelReferences = new ArrayList<ResourceReferenceAndStringData>();

    public AbstractResourceAggregatingHeaderResponse(IHeaderResponse real) {
        super(real);
    }

    @Override
    public void renderJavaScriptReference(ResourceReference reference) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, null, null, null, AbstractResourceDependentResourceReference.ResourceType.JS, false, null, null));
    }

    @Override
    public void renderJavaScriptReference(ResourceReference reference, String id) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, null, null, id, AbstractResourceDependentResourceReference.ResourceType.JS, false, null, null));
    }

    @Override
    public void renderCSSReference(ResourceReference reference) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, null, null, null, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, null));
    }

    @Override
    public void renderCSSReference(ResourceReference reference, String media) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, null, null, media, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, null));
    }

    @Override
    public void close() {
        TreeMap<K, R> map = new TreeMap<K, R>(this.getGroupingKeyComparator());
        for (ResourceReferenceAndStringData ref : this.topLevelReferences) {
            K key = this.newGroupingKey(ref);
            ResourceReferenceCollection coll = (ResourceReferenceCollection)map.get(key);
            if (coll == null) {
                coll = this.newResourceReferenceCollection(key);
                map.put(key, coll);
            }
            coll.add(ref);
        }
        LinkedHashSet<ResourceReferenceAndStringData> alreadyRendered = new LinkedHashSet<ResourceReferenceAndStringData>();
        for (Map.Entry entry : map.entrySet()) {
            this.renderCollection(alreadyRendered, entry.getKey(), (ResourceReferenceCollection)entry.getValue());
        }
        this.onAllCollectionsRendered(this.topLevelReferences);
        super.close();
    }

    protected R newResourceReferenceCollection(K key) {
        return (R)new ResourceReferenceCollection();
    }

    protected abstract K newGroupingKey(ResourceReferenceAndStringData var1);

    protected Comparator<K> getGroupingKeyComparator() {
        return null;
    }

    protected void renderCollection(Set<ResourceReferenceAndStringData> alreadyRendered, K key, R coll) {
        for (ResourceReferenceAndStringData data : coll) {
            this.renderIfNotAlreadyRendered(alreadyRendered, data);
        }
    }

    protected void renderIfNotAlreadyRendered(Set<ResourceReferenceAndStringData> alreadyRendered, ResourceReferenceAndStringData data) {
        if (!alreadyRendered.contains(data)) {
            this.render(data);
            alreadyRendered.add(data);
        }
    }

    protected void render(ResourceReferenceAndStringData data) {
        ResourceUtil.renderTo(this.getRealResponse(), data);
    }

    protected void onAllCollectionsRendered(List<ResourceReferenceAndStringData> allTopLevelReferences) {
    }

    @Override
    public void renderJavaScriptReference(String url) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, null, AbstractResourceDependentResourceReference.ResourceType.JS, false, null, null));
    }

    @Override
    public void renderJavaScriptReference(String url, String id) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, id, AbstractResourceDependentResourceReference.ResourceType.JS, false, null, null));
    }

    @Override
    public void renderCSSReference(String url) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, null, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, null));
    }

    @Override
    public void renderCSSReference(String url, String media) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, media, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, null));
    }

    @Override
    public void renderJavaScriptReference(ResourceReference reference, PageParameters parameters, String id) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, parameters, null, id, AbstractResourceDependentResourceReference.ResourceType.JS, false, null, null));
    }

    @Override
    public void renderJavaScriptReference(ResourceReference reference, PageParameters parameters, String id, boolean defer) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, parameters, null, id, AbstractResourceDependentResourceReference.ResourceType.JS, defer, null, null));
    }

    @Override
    public void renderJavaScriptReference(ResourceReference reference, PageParameters parameters, String id, boolean defer, String charset) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, parameters, null, id, AbstractResourceDependentResourceReference.ResourceType.JS, defer, charset, null));
    }

    @Override
    public void renderJavaScriptReference(String url, String id, boolean defer) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, id, AbstractResourceDependentResourceReference.ResourceType.JS, defer, null, null));
    }

    @Override
    public void renderJavaScriptReference(String url, String id, boolean defer, String charset) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, id, AbstractResourceDependentResourceReference.ResourceType.JS, defer, charset, null));
    }

    @Override
    public void renderJavaScript(CharSequence javascript, String id) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(javascript, AbstractResourceDependentResourceReference.ResourceType.JS, id));
    }

    @Override
    public void renderCSS(CharSequence css, String media) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(css, AbstractResourceDependentResourceReference.ResourceType.CSS, media));
    }

    @Override
    public void renderCSSReference(ResourceReference reference, PageParameters pageParameters, String media) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, pageParameters, null, media, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, null));
    }

    @Override
    public void renderCSSReference(ResourceReference reference, PageParameters pageParameters, String media, String condition) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, pageParameters, null, media, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, condition));
    }

    @Override
    public void renderCSSReference(String url, String media, String condition) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(null, null, url, media, AbstractResourceDependentResourceReference.ResourceType.CSS, false, null, condition));
    }

    @Override
    public void renderString(CharSequence string) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(string, AbstractResourceDependentResourceReference.ResourceType.PLAIN, null));
    }

    @Override
    public void renderOnDomReadyJavaScript(String javascript) {
        super.renderOnDomReadyJavaScript(javascript);
    }

    @Override
    public void renderOnLoadJavaScript(String javascript) {
        super.renderOnLoadJavaScript(javascript);
    }

    @Override
    public void renderOnEventJavaScript(String target, String event, String javascript) {
        super.renderOnEventJavaScript(target, event, javascript);
    }
}

