/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.pages.BrowserInfoPage;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSession
extends Session {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WebSession.class);
    private static final IFeedbackMessageFilter MESSAGES_FOR_COMPONENTS = new IFeedbackMessageFilter(){
        private static final long serialVersionUID = 1L;

        public boolean accept(FeedbackMessage message) {
            return message.getReporter() != null;
        }
    };
    private static final IFeedbackMessageFilter RENDERED_SESSION_SCOPED_MESSAGES = new IFeedbackMessageFilter(){
        private static final long serialVersionUID = 1L;

        public boolean accept(FeedbackMessage message) {
            return message.getReporter() == null && message.isRendered();
        }
    };
    private static final MetaDataKey<Boolean> BROWSER_WAS_POLLED_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };

    public static WebSession get() {
        return (WebSession)Session.get();
    }

    public WebSession(Request request) {
        super(request);
    }

    public void cleanupFeedbackMessages() {
        if (Application.get().getRequestCycleSettings().getRenderStrategy() != IRequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER || ((WebRequest)RequestCycle.get().getRequest()).isAjax() || !((WebResponse)RequestCycle.get().getResponse()).isRedirect()) {
            if (this.getFeedbackMessages().clear(RENDERED_SESSION_SCOPED_MESSAGES) > 0) {
                this.dirty();
            }
            if (this.getApplication().usesDevelopmentConfig()) {
                List<FeedbackMessage> messages = this.getFeedbackMessages().messages(MESSAGES_FOR_COMPONENTS);
                for (FeedbackMessage message : messages) {
                    if (message.isRendered()) continue;
                    logger.warn("Component-targetted feedback message was left unrendered. This could be because you are missing a FeedbackPanel on the page.  Message: {}", (Object)message);
                }
            }
            this.cleanupComponentFeedbackMessages();
        }
    }

    protected void cleanupComponentFeedbackMessages() {
        this.getFeedbackMessages().clear(MESSAGES_FOR_COMPONENTS);
    }

    public void invalidate() {
        if (!this.isSessionInvalidated()) {
            this.getApplication().getSecuritySettings().getAuthenticationStrategy().remove();
            super.invalidate();
        }
    }

    public boolean authenticate(String username, String password) {
        throw new WicketRuntimeException("You must subclass WebSession and implement your own authentication method for all Wicket applications using authentication.");
    }

    public WebClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            RequestCycle requestCycle = RequestCycle.get();
            if (this.getApplication().getRequestCycleSettings().getGatherExtendedBrowserInfo()) {
                if (this.getMetaData(BROWSER_WAS_POLLED_KEY) == null) {
                    this.setMetaData(BROWSER_WAS_POLLED_KEY, Boolean.TRUE);
                    WebPage browserInfoPage = this.newBrowserInfoPage();
                    this.getPageManager().touchPage(browserInfoPage);
                    throw new RestartResponseAtInterceptPageException(browserInfoPage);
                }
                this.setMetaData(BROWSER_WAS_POLLED_KEY, null);
            }
            this.clientInfo = new WebClientInfo(requestCycle);
        }
        return (WebClientInfo)this.clientInfo;
    }

    protected WebPage newBrowserInfoPage() {
        return new BrowserInfoPage();
    }
}

