/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.IPageRendererProvider;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxRequestTargetListenerCollection;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.AutoLabelResolver;
import org.apache.wicket.markup.html.form.AutoLabelTextResolver;
import org.apache.wicket.markup.html.pages.AccessDeniedPage;
import org.apache.wicket.markup.html.pages.InternalErrorPage;
import org.apache.wicket.markup.html.pages.PageExpiredErrorPage;
import org.apache.wicket.markup.resolver.AutoLinkResolver;
import org.apache.wicket.protocol.http.AjaxEnclosureListener;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.HeaderBufferingWebResponse;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.StoredResponsesMap;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.FilterFactoryManager;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.handler.render.WebPageRenderer;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.MountedMapper;
import org.apache.wicket.request.mapper.PackageMapper;
import org.apache.wicket.request.mapper.ResourceMapper;
import org.apache.wicket.request.mapper.mount.MountMapper;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.session.HttpSessionStore;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.IContextProvider;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.file.FileCleaner;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.file.WebApplicationPath;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger(WebApplication.class);
    private ServletContext servletContext;
    private final AjaxRequestTargetListenerCollection ajaxRequestTargetListeners;
    private IContextProvider<AjaxRequestTarget, Page> ajaxRequestTargetProvider;
    private FilterFactoryManager filterFactoryManager;
    private RuntimeConfigurationType configurationType;
    private String sessionAttributePrefix;
    private WicketFilter wicketFilter;
    private final StoredResponsesMap storedResponses = new StoredResponsesMap(1000, Duration.seconds((int)60));

    public static WebApplication get() {
        Application application = Application.get();
        if (!(application instanceof WebApplication)) {
            throw new WicketRuntimeException("The application attached to the current thread is not a " + WebApplication.class.getSimpleName());
        }
        return (WebApplication)application;
    }

    public WebApplication() {
        this.ajaxRequestTargetListeners = new AjaxRequestTargetListenerCollection();
    }

    @Override
    public final String getApplicationKey() {
        return this.getName();
    }

    public String getInitParameter(String key) {
        if (this.wicketFilter != null) {
            return this.wicketFilter.getFilterConfig().getInitParameter(key);
        }
        throw new IllegalStateException("init parameter '" + key + "' is not set yet. Any code in your" + " Application object that uses the wicketServlet/Filter instance should be put" + " in the init() method instead of your constructor");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new IllegalStateException("servletContext is not set yet. Any code in your Application object that uses the wicket filter instance should be put in the init() method instead of your constructor");
        }
        return this.servletContext;
    }

    public String getSessionAttributePrefix(WebRequest request, String filterName) {
        if (this.sessionAttributePrefix == null) {
            if (filterName == null) {
                filterName = this.getWicketFilter().getFilterConfig().getFilterName();
            }
            String namespace = this.getMapperContext().getNamespace();
            this.sessionAttributePrefix = namespace + ':' + filterName + ':';
        }
        return this.sessionAttributePrefix;
    }

    public final WicketFilter getWicketFilter() {
        return this.wicketFilter;
    }

    @Override
    public void logEventTarget(IRequestHandler target) {
        super.logEventTarget(target);
        IRequestLogger rl = this.getRequestLogger();
        if (rl != null) {
            rl.logEventTarget(target);
        }
    }

    @Override
    public void logResponseTarget(IRequestHandler target) {
        super.logResponseTarget(target);
        IRequestLogger rl = this.getRequestLogger();
        if (rl != null) {
            rl.logResponseTarget(target);
        }
    }

    public final void mount(IRequestMapper mapper) {
        Args.notNull((Object)mapper, (String)"mapper");
        this.getRootRequestMapperAsCompound().add(mapper);
    }

    public final <T extends Page> void mountPage(String path, Class<T> pageClass) {
        this.mount(new MountedMapper(path, pageClass));
    }

    public final void mountResource(String path, ResourceReference reference) {
        if (reference.canBeRegistered()) {
            this.getResourceReferenceRegistry().registerResourceReference(reference);
        }
        this.mount(new ResourceMapper(path, reference));
    }

    public final <P extends Page> void mountPackage(String path, Class<P> pageClass) {
        PackageMapper packageMapper = new PackageMapper(PackageName.forClass(pageClass));
        MountMapper mountMapper = new MountMapper(path, (IRequestMapper)packageMapper);
        this.mount((IRequestMapper)mountMapper);
    }

    public final void unmount(String path) {
        this.getRootRequestMapperAsCompound().unmount(path);
    }

    public final void addIgnoreMountPath(String path) {
        throw new UnsupportedOperationException();
    }

    protected WebRequest newWebRequest(HttpServletRequest servletRequest, String filterPath) {
        return new ServletWebRequest(servletRequest, filterPath);
    }

    WebRequest createWebRequest(HttpServletRequest servletRequest, String filterPath) {
        if (servletRequest.getCharacterEncoding() == null) {
            try {
                String wicketAjaxHeader = servletRequest.getHeader("Wicket-Ajax");
                if (Strings.isTrue((String)wicketAjaxHeader)) {
                    servletRequest.setCharacterEncoding("UTF-8");
                } else {
                    String requestEncoding = this.getRequestCycleSettings().getResponseRequestEncoding();
                    servletRequest.setCharacterEncoding(requestEncoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new WicketRuntimeException(e);
            }
        }
        if (this.hasFilterFactoryManager()) {
            for (AbstractRequestWrapperFactory factory : this.getFilterFactoryManager()) {
                servletRequest = factory.getWrapper(servletRequest);
            }
        }
        WebRequest webRequest = this.newWebRequest(servletRequest, filterPath);
        return webRequest;
    }

    protected WebResponse newWebResponse(WebRequest webRequest, HttpServletResponse httpServletResponse) {
        return new ServletWebResponse((ServletWebRequest)webRequest, httpServletResponse);
    }

    WebResponse createWebResponse(WebRequest webRequest, HttpServletResponse httpServletResponse) {
        WebResponse webResponse = this.newWebResponse(webRequest, httpServletResponse);
        boolean shouldBufferResponse = this.getRequestCycleSettings().getBufferResponse();
        return shouldBufferResponse ? new HeaderBufferingWebResponse(webResponse) : webResponse;
    }

    @Override
    public Session newSession(Request request, Response response) {
        return new WebSession(request);
    }

    @Override
    public void sessionUnbound(String sessionId) {
        super.sessionUnbound(sessionId);
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            logger.sessionDestroyed(sessionId);
        }
    }

    public final void setWicketFilter(WicketFilter wicketFilter) {
        Args.notNull((Object)wicketFilter, (String)"wicketFilter");
        this.wicketFilter = wicketFilter;
        this.servletContext = wicketFilter.getFilterConfig().getServletContext();
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public void internalDestroy() {
        IFileCleaner fileCleaner;
        IModificationWatcher resourceWatcher = this.getResourceSettings().getResourceWatcher(false);
        if (resourceWatcher != null) {
            resourceWatcher.destroy();
        }
        if ((fileCleaner = this.getResourceSettings().getFileCleaner()) != null) {
            fileCleaner.destroy();
        }
        super.internalDestroy();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        this.getApplicationSettings().setPageExpiredErrorPage(PageExpiredErrorPage.class);
        this.getApplicationSettings().setInternalErrorPage(InternalErrorPage.class);
        this.getApplicationSettings().setAccessDeniedPage(AccessDeniedPage.class);
        this.getPageSettings().addComponentResolver(new AutoLinkResolver());
        this.getPageSettings().addComponentResolver(new AutoLabelResolver());
        this.getPageSettings().addComponentResolver(new AutoLabelTextResolver());
        this.getResourceSettings().setResourceFinder(this.getResourceFinder());
        this.getResourceSettings().setFileCleaner((IFileCleaner)new FileCleaner());
        String resourceFolder = this.getInitParameter("sourceFolder");
        if (resourceFolder != null) {
            this.getResourceSettings().addResourceFolder(resourceFolder);
        }
        this.setPageRendererProvider(new WebPageRendererProvider());
        this.setSessionStoreProvider(new WebSessionStoreProvider());
        this.setAjaxRequestTargetProvider(new DefaultAjaxRequestTargetProvider());
        this.getAjaxRequestTargetListeners().add(new AjaxEnclosureListener());
        this.configure();
    }

    public void setConfigurationType(RuntimeConfigurationType configurationType) {
        if (this.configurationType != null) {
            throw new IllegalStateException("Configuration type is write-once. You can not change it. Current value='" + (Object)((Object)configurationType));
        }
        this.configurationType = (RuntimeConfigurationType)((Object)Args.notNull((Object)((Object)configurationType), (String)"configurationType"));
    }

    @Override
    public RuntimeConfigurationType getConfigurationType() {
        if (this.configurationType == null) {
            String result = null;
            try {
                result = System.getProperty("wicket.configuration");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (result == null) {
                result = this.getInitParameter("wicket.configuration");
            }
            if (result == null) {
                result = this.getServletContext().getInitParameter("wicket.configuration");
            }
            if (result == null) {
                result = this.getInitParameter("configuration");
            }
            if (result == null) {
                result = this.getServletContext().getInitParameter("configuration");
            }
            if (result != null) {
                try {
                    this.configurationType = RuntimeConfigurationType.valueOf(result.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid configuration type: '" + result + "'.  Must be \"development\" or \"deployment\".");
                }
            }
        }
        if (this.configurationType == null) {
            this.configurationType = RuntimeConfigurationType.DEVELOPMENT;
        }
        return this.configurationType;
    }

    public void renderXmlDecl(WebPage page, boolean insert) {
        if (insert || "application/xhtml+xml".equalsIgnoreCase(page.getMarkupType().getMimeType())) {
            RequestCycle cycle = RequestCycle.get();
            if (!insert) {
                WebRequest request = (WebRequest)cycle.getRequest();
                String accept = request.getHeader("Accept");
                boolean bl = insert = accept == null || accept.indexOf("application/xhtml+xml") != -1;
            }
            if (insert) {
                WebResponse response = (WebResponse)cycle.getResponse();
                response.write((CharSequence)"<?xml version='1.0'");
                String encoding = this.getRequestCycleSettings().getResponseRequestEncoding();
                if (!Strings.isEmpty((CharSequence)encoding)) {
                    response.write((CharSequence)" encoding='");
                    response.write((CharSequence)encoding);
                    response.write((CharSequence)"'");
                }
                response.write((CharSequence)" ?>");
            }
        }
    }

    protected IResourceFinder getResourceFinder() {
        return new WebApplicationPath(this.getServletContext());
    }

    public final AjaxRequestTarget newAjaxRequestTarget(Page page) {
        AjaxRequestTarget target = (AjaxRequestTarget)this.getAjaxRequestTargetProvider().get((Object)page);
        Iterator i$ = this.ajaxRequestTargetListeners.iterator();
        while (i$.hasNext()) {
            AjaxRequestTarget.IListener listener = (AjaxRequestTarget.IListener)i$.next();
            target.addListener(listener);
        }
        return target;
    }

    final void logStarted() {
        if (log.isInfoEnabled()) {
            String version = this.getFrameworkSettings().getVersion();
            StringBuilder b = new StringBuilder();
            b.append("[").append(this.getName()).append("] Started Wicket ");
            if (!"n/a".equals(version)) {
                b.append("version ").append(version).append(" ");
            }
            b.append("in ").append((Object)this.getConfigurationType()).append(" mode");
            log.info(b.toString());
        }
        if (this.usesDevelopmentConfig()) {
            this.outputDevelopmentModeWarning();
        }
    }

    protected void outputDevelopmentModeWarning() {
        System.err.print("********************************************************************\n*** WARNING: Wicket is running in DEVELOPMENT mode.              ***\n***                               ^^^^^^^^^^^                    ***\n*** Do NOT deploy to your live server(s) without changing this.  ***\n*** See Application#getConfigurationType() for more information. ***\n********************************************************************\n");
    }

    public boolean hasBufferedResponse(String sessionId, Url url) {
        String key = sessionId + url.toString();
        return this.storedResponses.containsKey(key);
    }

    public BufferedWebResponse getAndRemoveBufferedResponse(String sessionId, Url url) {
        String key = sessionId + url.toString();
        return this.storedResponses.remove(key);
    }

    public void storeBufferedResponse(String sessionId, Url url, BufferedWebResponse response) {
        String key = sessionId + url.toString();
        this.storedResponses.put(key, (Object)response);
    }

    @Override
    public String getMimeType(String fileName) {
        String mimeType = this.getServletContext().getMimeType(fileName);
        return mimeType != null ? mimeType : super.getMimeType(fileName);
    }

    public IContextProvider<AjaxRequestTarget, Page> getAjaxRequestTargetProvider() {
        return this.ajaxRequestTargetProvider;
    }

    public void setAjaxRequestTargetProvider(IContextProvider<AjaxRequestTarget, Page> ajaxRequestTargetProvider) {
        this.ajaxRequestTargetProvider = ajaxRequestTargetProvider;
    }

    public AjaxRequestTargetListenerCollection getAjaxRequestTargetListeners() {
        return this.ajaxRequestTargetListeners;
    }

    public final boolean hasFilterFactoryManager() {
        return this.filterFactoryManager != null;
    }

    public final FilterFactoryManager getFilterFactoryManager() {
        if (this.filterFactoryManager == null) {
            this.filterFactoryManager = new FilterFactoryManager();
        }
        return this.filterFactoryManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultAjaxRequestTargetProvider
    implements IContextProvider<AjaxRequestTarget, Page> {
        private DefaultAjaxRequestTargetProvider() {
        }

        public AjaxRequestTarget get(Page context) {
            return new AjaxRequestTarget(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebSessionStoreProvider
    implements IProvider<ISessionStore> {
        private WebSessionStoreProvider() {
        }

        public ISessionStore get() {
            return new HttpSessionStore();
        }
    }

    private static class WebPageRendererProvider
    implements IPageRendererProvider {
        private WebPageRendererProvider() {
        }

        public PageRenderer get(RenderPageRequestHandler handler) {
            return new WebPageRenderer(handler);
        }
    }
}

