/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.Session;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.PropertyVariableInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringResourceModel
extends LoadableDetachableModel<String>
implements IComponentAssignedModel<String> {
    private static final long serialVersionUID = 1L;
    private final IModel<?> model;
    private final Object[] parameters;
    private final Component component;
    private final String resourceKey;
    private final String defaultValue;

    @Override
    public IWrapModel<String> wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component);
    }

    public StringResourceModel(String resourceKey, Component component, IModel<?> model, Object ... parameters) {
        this(resourceKey, component, model, null, parameters);
    }

    public StringResourceModel(String resourceKey, Component component, IModel<?> model, String defaultValue, Object ... parameters) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("Resource key must not be null");
        }
        this.resourceKey = resourceKey;
        this.component = component;
        this.model = model;
        this.defaultValue = defaultValue;
        this.parameters = parameters;
    }

    public StringResourceModel(String resourceKey, IModel<?> model, Object ... parameters) {
        this(resourceKey, null, model, null, parameters);
    }

    public StringResourceModel(String resourceKey, IModel<?> model, String defaultValue, Object ... parameters) {
        this(resourceKey, null, model, defaultValue, parameters);
    }

    public Localizer getLocalizer() {
        return Application.get().getResourceSettings().getLocalizer();
    }

    public final String getString() {
        return this.getString(this.component);
    }

    private String getString(Component component) {
        String value;
        Localizer localizer = this.getLocalizer();
        Locale locale = component != null ? component.getLocale() : (Session.exists() ? Session.get().getLocale() : Locale.getDefault());
        Object[] parameters = this.getParameters();
        if (parameters == null || parameters.length == 0) {
            value = localizer.getString(this.getResourceKey(), component, this.model, this.defaultValue);
            if (value == null) {
                value = this.defaultValue;
            }
        } else {
            value = localizer.getString(this.getResourceKey(), component, null, this.defaultValue);
            if (value == null) {
                value = this.defaultValue;
            }
            if (value != null) {
                Object[] realParams = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    realParams[i] = parameters[i] instanceof IModel ? ((IModel)parameters[i]).getObject() : (this.model != null && parameters[i] instanceof String ? PropertyVariableInterpolator.interpolate((String)parameters[i], this.model.getObject()) : parameters[i]);
                }
                if (value.indexOf(39) != -1) {
                    value = this.escapeQuotes(value);
                }
                if (this.model != null) {
                    value = ((Object)Strings.replaceAll((CharSequence)value, (CharSequence)"${", (CharSequence)"$'{'")).toString();
                }
                MessageFormat format = new MessageFormat(value, locale);
                value = format.format(realParams);
                if (this.model != null) {
                    value = ((Object)Strings.replaceAll((CharSequence)value, (CharSequence)"$'{'", (CharSequence)"${")).toString();
                    value = localizer.substitutePropertyExpressions(component, value, this.model);
                }
            }
        }
        return value;
    }

    private String escapeQuotes(String value) {
        StringBuilder newValue = new StringBuilder(value.length() + 10);
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '{') {
                ++count;
            } else if (ch == '}') {
                --count;
            }
            newValue.append(ch);
            if (ch != '\'' || count != 0) continue;
            newValue.append(ch);
        }
        return newValue.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StringResourceModel[");
        sb.append("key:");
        sb.append(this.resourceKey);
        sb.append(",default:");
        sb.append(this.defaultValue);
        sb.append(",params:");
        if (this.parameters != null) {
            sb.append(Arrays.asList(this.parameters));
        }
        sb.append("]");
        return sb.toString();
    }

    protected Object[] getParameters() {
        return this.parameters;
    }

    protected final String getResourceKey() {
        if (this.model != null) {
            return PropertyVariableInterpolator.interpolate(this.resourceKey, this.model.getObject());
        }
        return this.resourceKey;
    }

    @Override
    protected String load() {
        return this.getString();
    }

    @Override
    protected final void onDetach() {
        super.onDetach();
        if (this.model != null) {
            this.model.detach();
        }
        if (this.parameters != null) {
            for (Object parameter : this.parameters) {
                if (!(parameter instanceof IDetachable)) continue;
                ((IDetachable)parameter).detach();
            }
        }
    }

    @Override
    public void setObject(String object) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AssignmentWrapper
    extends LoadableDetachableModel<String>
    implements IWrapModel<String> {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(Component component) {
            this.component = component;
        }

        @Override
        public void detach() {
            super.detach();
            StringResourceModel.this.detach();
        }

        @Override
        protected void onDetach() {
            if (StringResourceModel.this.component == null) {
                StringResourceModel.this.onDetach();
            }
        }

        @Override
        protected String load() {
            if (StringResourceModel.this.component != null) {
                return (String)StringResourceModel.this.getObject();
            }
            return StringResourceModel.this.getString(this.component);
        }

        @Override
        public void setObject(String object) {
            StringResourceModel.this.setObject(object);
        }

        @Override
        public IModel<String> getWrappedModel() {
            return StringResourceModel.this;
        }
    }
}

