/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.panel.AbstractMarkupSourcingStrategy;
import org.apache.wicket.util.lang.Args;

public class FragmentMarkupSourcingStrategy
extends AbstractMarkupSourcingStrategy {
    private String markupId;
    private final MarkupContainer markupProvider;

    public FragmentMarkupSourcingStrategy(String markupId, MarkupContainer markupProvider) {
        Args.notNull((Object)markupId, (String)"markupId");
        this.markupId = markupId;
        this.markupProvider = markupProvider;
    }

    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(component, markupStream, openTag);
        MarkupStream stream = new MarkupStream(this.getMarkup((MarkupContainer)component, null));
        ComponentTag fragmentOpenTag = stream.getTag();
        if (!fragmentOpenTag.isOpenClose()) {
            stream.next();
            component.onComponentTagBody(stream, fragmentOpenTag);
        }
    }

    protected final MarkupContainer getMarkupProvider(Component component) {
        return this.markupProvider != null ? this.markupProvider : component.getParent();
    }

    public IMarkupFragment chooseMarkup(Component component) {
        return this.getMarkupProvider(component).getMarkup(null);
    }

    public IMarkupFragment getMarkup(MarkupContainer container, Component child) {
        MarkupContainer markupProvider;
        Markup associatedMarkup;
        IMarkupFragment markup = this.chooseMarkup(container);
        if (markup == null) {
            throw new MarkupException("The fragments markup provider has no associated markup. No markup to search for fragment markup with id: " + this.markupId);
        }
        IMarkupFragment childMarkup = markup.find(this.markupId);
        if (childMarkup == null && (associatedMarkup = (markupProvider = this.getMarkupProvider(container)).getAssociatedMarkup()) != null && (markup = associatedMarkup) != null) {
            childMarkup = markup.find(this.markupId);
        }
        if (childMarkup == null) {
            throw new MarkupNotFoundException("No Markup found for Fragment " + this.markupId + " in providing markup container " + this.getMarkupProvider(container));
        }
        if (child == null) {
            return childMarkup;
        }
        return childMarkup.find(child.getId());
    }
}

