/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.Locale;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarkupCacheKeyProvider
implements IMarkupCacheKeyProvider {
    @Override
    public String getCacheKey(MarkupContainer container, Class<?> clazz) {
        Locale locale;
        String classname = clazz.getName();
        StringBuilder buffer = new StringBuilder(classname.length() + 64);
        buffer.append(classname);
        if (container.getVariation() != null) {
            buffer.append('_').append(container.getVariation());
        }
        if (container.getStyle() != null) {
            buffer.append('_').append(container.getStyle());
        }
        if ((locale = container.getLocale()) != null) {
            boolean hasVariant;
            buffer.append('_').append(locale.getLanguage());
            boolean hasLocale = locale.getLanguage().length() != 0;
            boolean hasCountry = locale.getCountry().length() != 0;
            boolean bl = hasVariant = locale.getVariant().length() != 0;
            if (hasCountry || hasLocale && hasVariant) {
                buffer.append('_').append(locale.getCountry());
            }
            if (hasVariant && (hasLocale || hasCountry)) {
                buffer.append('_').append(locale.getVariant());
            }
        }
        buffer.append('.').append(container.getMarkupType().getExtension());
        return buffer.toString();
    }
}

