/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jaxrx.JaxRx;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.jaxrx.core.ResourcePath;
import org.jaxrx.core.ResponseBuilder;
import org.jaxrx.dom.DOMs;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DOMJaxRx
implements JaxRx {
    @Override
    public Set<QueryParameter> getParameters() {
        HashSet<QueryParameter> params = new HashSet<QueryParameter>();
        params.add(QueryParameter.QUERY);
        params.add(QueryParameter.WRAP);
        return params;
    }

    @Override
    public synchronized StreamingOutput get(ResourcePath path) {
        StreamingOutput sOutput = null;
        if (path.getDepth() == 0) {
            Set<String> docNames = DOMs.getAllDOMs();
            ArrayList<String> docNamesRes = new ArrayList<String>();
            for (String doc : docNames) {
                docNamesRes.add(doc);
            }
            sOutput = ResponseBuilder.buildDOMResponse(docNamesRes);
        } else {
            Document currentDoc = DOMs.getDOM(DOMJaxRx.root(path));
            if (currentDoc == null) {
                throw new JaxRxException(404, "Requested resource is not available");
            }
            sOutput = ResponseBuilder.createStream(currentDoc);
        }
        return sOutput;
    }

    @Override
    public synchronized StreamingOutput query(final String query, final ResourcePath path) {
        XPathFactory xpathFac = XPathFactory.newInstance();
        final XPath xpath = xpathFac.newXPath();
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                Document currentDoc = path.getDepth() == 0 ? null : DOMs.getDOM(DOMJaxRx.root(path));
                try {
                    NodeList resultNodeList = (NodeList)xpath.evaluate(query, currentDoc, XPathConstants.NODESET);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    Map<QueryParameter, String> params = path.getQueryParameter();
                    boolean wrap = path.getValue(QueryParameter.WRAP) == null || path.getValue(QueryParameter.WRAP).equals("yes");
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    if (wrap) {
                        output.write("<jaxrx:result xmlns:jaxrx=\"http://jaxrx.org/\">".getBytes());
                    }
                    int i = 0;
                    while (i < resultNodeList.getLength()) {
                        Node node = resultNodeList.item(i);
                        transformer.transform(new DOMSource(node), new StreamResult(output));
                        ++i;
                    }
                    if (wrap) {
                        output.write("</jaxrx:result>".getBytes());
                    }
                }
                catch (XPathExpressionException exce) {
                    throw new JaxRxException(400, exce.getMessage());
                }
                catch (TransformerConfigurationException exce) {
                    throw new JaxRxException(500, exce.getMessage());
                }
                catch (TransformerFactoryConfigurationError exce) {
                    throw new JaxRxException(500, exce.getMessage());
                }
                catch (TransformerException exce) {
                    throw new JaxRxException(500, exce.getMessage());
                }
            }
        };
    }

    @Override
    public StreamingOutput run(String file, ResourcePath path) {
        return null;
    }

    @Override
    public StreamingOutput command(String command, ResourcePath path) {
        return null;
    }

    @Override
    public synchronized String add(InputStream input, ResourcePath path) {
        return "Nothing done";
    }

    @Override
    public synchronized String update(InputStream input, ResourcePath path) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            DOMs.putDOM(document, DOMJaxRx.root(path));
            return "Document updated.";
        }
        catch (ParserConfigurationException exc) {
            throw new JaxRxException(exc);
        }
        catch (SAXException exc) {
            throw new JaxRxException(exc);
        }
        catch (IOException exc) {
            throw new JaxRxException(exc);
        }
    }

    @Override
    public String delete(ResourcePath path) {
        DOMs.deleteDOM(DOMJaxRx.root(path));
        return "Document deleted.";
    }

    static String root(ResourcePath path) {
        if (path.getDepth() == 1) {
            return path.getResourcePath();
        }
        throw new JaxRxException(404, "Resource not found: " + path);
    }
}

