/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class MiscUtil {
    private static final int BUFFER_SIZE = 2048;
    private static DatatypeFactory df = null;

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalStateException("Exception while obtaining Datatype Factory instance", dce);
        }
    }

    public static <T> Collection<T> union(Collection<T> ... sets) {
        HashSet<T> resultSet = new HashSet<T>();
        Collection<T>[] collectionArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> set = collectionArray[n2];
            if (set != null) {
                resultSet.addAll(set);
            }
            ++n2;
        }
        return resultSet;
    }

    public static boolean unorderedCollectionEquals(Collection a, Collection b) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.equals(o2) ? 0 : 1;
            }
        };
        return MiscUtil.unorderedCollectionEquals(a, b, comparator);
    }

    public static boolean unorderedCollectionEquals(Collection a, Collection b, Comparator comparator) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        ArrayList outstanding = new ArrayList(b.size());
        outstanding.addAll(b);
        for (Object ao : a) {
            boolean found = false;
            Iterator iterator = outstanding.iterator();
            while (iterator.hasNext()) {
                Object oo = iterator.next();
                if (comparator.compare(ao, oo) != 0) continue;
                iterator.remove();
                found = true;
            }
            if (found) continue;
            return false;
        }
        return outstanding.isEmpty();
    }

    public static int unorderedCollectionHashcode(Collection collection) {
        int hashcode = 0;
        for (Object item : collection) {
            hashcode += item.hashCode();
        }
        return hashcode;
    }

    public static String readFile(File file) throws IOException {
        StringBuffer fileData = new StringBuffer(2048);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[2048];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[2048];
        }
        reader.close();
        return fileData.toString();
    }

    public static <T> T getJavaProperty(Object object, String propertyName, Class<T> propetyClass) {
        Method method;
        String getterName = MiscUtil.getterName(propertyName);
        try {
            method = object.getClass().getMethod(getterName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Security error getting getter for property " + propertyName + ": " + e.getMessage(), e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No getter for property " + propertyName + " in " + object + " (" + object.getClass() + ")");
        }
        if (method == null) {
            throw new IllegalArgumentException("No getter for property " + propertyName + " in " + object + " (" + object.getClass() + ")");
        }
        if (!propetyClass.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("The getter for property " + propertyName + " returns " + method.getReturnType() + ", expected " + propetyClass + " in " + object + " (" + object.getClass() + ")");
        }
        try {
            return (T)method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error invoking getter for property " + propertyName + " in " + object + " (" + object.getClass() + "): " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error invoking getter for property " + propertyName + " in " + object + " (" + object.getClass() + "): " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error invoking getter for property " + propertyName + " in " + object + " (" + object.getClass() + "): " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    public static boolean hasJavaProperty(Object object, String propertyName) {
        return MiscUtil.findGetter(object, propertyName) != null;
    }

    public static Method findGetter(Object object, String propertyName) {
        String getterName = MiscUtil.getterName(propertyName);
        return MiscUtil.findMethod(object, getterName, 0);
    }

    public static Method findMethod(Object object, String methodName, int arity) {
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == arity && !method.isVarArgs()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static Method findVarArgsMethod(Object object, String methodName) {
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && method.isVarArgs()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static String getterName(String propertyName) {
        return "get" + StringUtils.capitalize((String)propertyName);
    }

    public static <T> Collection<T> createCollection(T ... items) {
        ArrayList<T> collection = new ArrayList<T>(items.length);
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            collection.add(item);
            ++n2;
        }
        return collection;
    }

    public static Boolean and(Boolean ... operands) {
        Boolean result = null;
        Boolean[] booleanArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean operand = booleanArray[n2];
            if (operand != null) {
                if (!operand.booleanValue()) {
                    return false;
                }
                result = true;
            }
            ++n2;
        }
        return result;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(date.getTime());
        return df.newXMLGregorianCalendar(gc);
    }

    public static Date asDate(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        return xgc.toGregorianCalendar().getTime();
    }
}

