/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.security.AccessControlException;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StdErrLog
implements Logger {
    private static DateCache _dateCache;
    private static final boolean __debug;
    private static final boolean __source;
    private boolean _debug = __debug;
    private boolean _source = __source;
    private final String _name;
    private boolean _hideStacks = false;

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String name) {
        this._name = name == null ? "" : name;
        try {
            this._debug = Boolean.parseBoolean(System.getProperty(this._name + ".DEBUG", Boolean.toString(this._debug)));
        }
        catch (AccessControlException ace) {
            this._debug = __debug;
        }
        try {
            this._source = Boolean.parseBoolean(System.getProperty(this._name + ".SOURCE", Boolean.toString(this._source)));
        }
        catch (AccessControlException ace) {
            this._source = __source;
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this._hideStacks = hideStacks;
    }

    public boolean isSource() {
        return this._source;
    }

    public void setSource(boolean source) {
        this._source = source;
    }

    public void warn(String msg, Object ... args) {
        StringBuilder buffer = new StringBuilder(64);
        this.format(buffer, ":WARN:", msg, args);
        System.err.println(buffer);
    }

    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    public void warn(String msg, Throwable thrown) {
        StringBuilder buffer = new StringBuilder(64);
        this.format(buffer, ":WARN:", msg, thrown);
        System.err.println(buffer);
    }

    public void info(String msg, Object ... args) {
        StringBuilder buffer = new StringBuilder(64);
        this.format(buffer, ":INFO:", msg, args);
        System.err.println(buffer);
    }

    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    public void info(String msg, Throwable thrown) {
        StringBuilder buffer = new StringBuilder(64);
        this.format(buffer, ":INFO:", msg, thrown);
        System.err.println(buffer);
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean enabled) {
        this._debug = enabled;
    }

    public void debug(String msg, Object ... args) {
        if (!this._debug) {
            return;
        }
        StringBuilder buffer = new StringBuilder(64);
        this.format(buffer, ":DBUG:", msg, args);
        System.err.println(buffer);
    }

    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    public void debug(String msg, Throwable thrown) {
        if (!this._debug) {
            return;
        }
        StringBuilder buffer = new StringBuilder(64);
        this.format(buffer, ":DBUG:", msg, thrown);
        System.err.println(buffer);
    }

    private void format(StringBuilder buffer, String level, String msg, Object ... args) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        this.tag(buffer, d, ms, level);
        this.format(buffer, msg, args);
    }

    private void format(StringBuilder buffer, String level, String msg, Throwable thrown) {
        this.format(buffer, level, msg, new Object[0]);
        if (this.isHideStacks()) {
            this.format(buffer, String.valueOf(thrown), new Object[0]);
        } else {
            this.format(buffer, thrown);
        }
    }

    private void tag(StringBuilder buffer, String d, int ms, String tag) {
        buffer.setLength(0);
        buffer.append(d);
        if (ms > 99) {
            buffer.append('.');
        } else if (ms > 9) {
            buffer.append(".0");
        } else {
            buffer.append(".00");
        }
        buffer.append(ms).append(tag).append(this._name).append(':');
        if (this._source) {
            Throwable source = new Throwable();
            StackTraceElement[] frames = source.getStackTrace();
            for (int i = 0; i < frames.length; ++i) {
                StackTraceElement frame = frames[i];
                String clazz = frame.getClassName();
                if (clazz.equals(StdErrLog.class.getName()) || clazz.equals(Log.class.getName())) continue;
                if (clazz.startsWith("org.eclipse.jetty.")) {
                    buffer.append("o.e.j.").append(clazz, 18, clazz.length());
                } else {
                    buffer.append(clazz);
                }
                buffer.append('#').append(frame.getMethodName());
                if (frame.getFileName() != null) {
                    buffer.append('(').append(frame.getFileName()).append(':').append(frame.getLineNumber()).append(')');
                }
                buffer.append(':');
                break;
            }
        }
    }

    private void format(StringBuilder builder, String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                this.escape(builder, msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            this.escape(builder, msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        this.escape(builder, msg.substring(start));
    }

    private void escape(StringBuilder builder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                if (c == '\n') {
                    builder.append('|');
                    continue;
                }
                if (c == '\r') {
                    builder.append('<');
                    continue;
                }
                builder.append('?');
                continue;
            }
            builder.append(c);
        }
    }

    private void format(StringBuilder buffer, Throwable thrown) {
        if (thrown == null) {
            buffer.append("null");
        } else {
            buffer.append('\n');
            this.format(buffer, thrown.toString(), new Object[0]);
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                buffer.append("\n\tat ");
                this.format(buffer, elements[i].toString(), new Object[0]);
            }
            Throwable cause = thrown.getCause();
            if (cause != null && cause != thrown) {
                buffer.append("\nCaused by: ");
                this.format(buffer, cause);
            }
        }
    }

    public Logger getLogger(String name) {
        if (name == null && this._name == null || name != null && name.equals(this._name)) {
            return this;
        }
        return new StdErrLog(this._name == null || this._name.length() == 0 ? name : this._name + "." + name);
    }

    public String toString() {
        return "StdErrLog:" + this._name + ":DEBUG=" + this._debug;
    }

    public void ignore(Throwable ignored) {
        if (Log.isIgnored()) {
            this.warn("IGNORED", ignored);
        }
    }

    static {
        __debug = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.DEBUG", System.getProperty("org.eclipse.jetty.util.log.stderr.DEBUG", "false")));
        __source = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.SOURCE", System.getProperty("org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

