/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.test;

import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.test.common.spi.TestHelpersSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHelpersImpl
implements TestHelpersSpi {
    private static final Log _log = Log.getLog(TestHelpersImpl.class);

    @Override
    public APIConfiguration createTestConfiguration(Class<? extends Connector> clazz, Configuration config) {
        LocalConnectorInfoImpl info = new LocalConnectorInfoImpl();
        info.setConnectorConfigurationClass(config.getClass());
        info.setConnectorClass(clazz);
        info.setConnectorDisplayNameKey("DUMMY_DISPLAY_NAME");
        info.setConnectorKey(new ConnectorKey(clazz.getName() + ".bundle", "1.0", clazz.getName()));
        info.setMessages(this.createDummyMessages());
        try {
            APIConfigurationImpl rv = new APIConfigurationImpl();
            rv.setConnectorPoolingSupported(PoolableConnector.class.isAssignableFrom(clazz));
            ConfigurationPropertiesImpl properties = JavaClassProperties.createConfigurationProperties(config);
            rv.setConfigurationProperties(properties);
            rv.setConnectorInfo(info);
            rv.setSupportedOperations(FrameworkUtil.getDefaultSupportedOperations(clazz));
            info.setDefaultAPIConfiguration(rv);
            return rv;
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    @Override
    public void fillConfiguration(Configuration config, Map<String, ? extends Object> configData) {
        HashMap<String, ? extends Object> configDataCopy = new HashMap<String, Object>(configData);
        ConfigurationPropertiesImpl configProps = JavaClassProperties.createConfigurationProperties(config);
        for (String propName : configProps.getPropertyNames()) {
            Object value = configDataCopy.remove(propName);
            if (value == null) continue;
            configProps.setPropertyValue(propName, value);
        }
        for (String propName : configDataCopy.keySet()) {
            _log.warn("Configuration property {0} does not exist!", propName);
        }
        JavaClassProperties.mergeIntoBean(configProps, config);
    }

    @Override
    public void search(SearchOp<?> search, ObjectClass oclass, Filter filter, ResultsHandler handler, OperationOptions options) {
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        SearchImpl.rawSearch(search, oclass, filter, handler, options);
    }

    @Override
    public ConnectorMessages createDummyMessages() {
        return new DummyConnectorMessages();
    }

    private static class DummyConnectorMessages
    implements ConnectorMessages {
        private DummyConnectorMessages() {
        }

        public String format(String key, String dflt, Object ... args) {
            StringBuilder builder = new StringBuilder();
            builder.append(key);
            builder.append(": ");
            String sep = "";
            for (Object arg : args) {
                builder.append(sep);
                builder.append(arg);
                sep = ", ";
            }
            return builder.toString();
        }
    }
}

