/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.local.ObjectPoolHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPool<T> {
    private static final Log _log = Log.getLog(ObjectPool.class);
    private final Object LOCK = new Object();
    private final Map<T, PooledObject<T>> _activeObjects = new IdentityHashMap<T, PooledObject<T>>();
    private final LinkedList<PooledObject<T>> _idleObjects = new LinkedList();
    private final ObjectPoolHandler<T> _handler;
    private final ObjectPoolConfiguration _config;
    private boolean _isShutdown;

    public ObjectPool(ObjectPoolHandler<T> handler, ObjectPoolConfiguration config) {
        Assertions.nullCheck(handler, "handler");
        Assertions.nullCheck(config, "config");
        this._handler = handler;
        this._config = (ObjectPoolConfiguration)SerializerUtil.cloneObject(config);
        this._config.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(T object) {
        Assertions.nullCheck(object, "object");
        Object object2 = this.LOCK;
        synchronized (object2) {
            PooledObject<T> pooled = this._activeObjects.remove(object);
            if (pooled == null) {
                throw new IllegalStateException("Attempt to return an object not in the pool: " + object);
            }
            pooled.setActive(false);
            pooled.setNew(false);
            this._idleObjects.add(pooled);
            this.evictIdleObjects();
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowObject() {
        while (true) {
            PooledObject<T> rv = this.borrowObjectNoTest();
            try {
                assert (!Thread.holdsLock(this.LOCK));
                this._handler.testObject(rv.getObject());
                return rv.getObject();
            }
            catch (Exception e) {
                Object object = this.LOCK;
                synchronized (object) {
                    this._activeObjects.remove(rv.getObject());
                }
                this.disposeNoException(rv.getObject());
                if (!rv.isNew()) continue;
                throw ConnectorException.wrap(e);
            }
            break;
        }
    }

    private PooledObject<T> borrowObjectNoTest() {
        long startTime = System.currentTimeMillis();
        Object object = this.LOCK;
        synchronized (object) {
            this.evictIdleObjects();
            while (true) {
                if (this._isShutdown) {
                    throw new IllegalStateException("Object pool already shutdown");
                }
                PooledObject<T> pooledConn = null;
                if (this._idleObjects.size() > 0) {
                    pooledConn = this._idleObjects.removeFirst();
                } else if (this._activeObjects.size() < this._config.getMaxObjects()) {
                    pooledConn = new PooledObject<T>(this._handler.newObject());
                }
                if (pooledConn != null) {
                    pooledConn.setActive(true);
                    this._activeObjects.put(pooledConn.getObject(), pooledConn);
                    return pooledConn;
                }
                long elapsed = System.currentTimeMillis() - startTime;
                long remaining = this._config.getMaxWait() - elapsed;
                if (remaining <= 0L) break;
                try {
                    this.LOCK.wait(remaining);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ConnectorException(e);
                }
            }
            throw new ConnectorException("Max objects exceeded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this._isShutdown = true;
            this.evictIdleObjects();
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatistics() {
        Object object = this.LOCK;
        synchronized (object) {
            return new Statistics(this._idleObjects.size(), this._activeObjects.size());
        }
    }

    private void evictIdleObjects() {
        assert (Thread.holdsLock(this.LOCK));
        while (this.tooManyIdleObjects()) {
            PooledObject<T> conn = this._idleObjects.removeFirst();
            this.disposeNoException(conn.getObject());
        }
    }

    private boolean tooManyIdleObjects() {
        assert (Thread.holdsLock(this.LOCK));
        if (this._isShutdown && this._idleObjects.size() > 0) {
            return true;
        }
        if (this._config.getMaxIdle() < this._idleObjects.size()) {
            return true;
        }
        if (this._config.getMinIdle() >= this._idleObjects.size()) {
            return false;
        }
        PooledObject<T> oldest = this._idleObjects.getFirst();
        long age = System.currentTimeMillis() - oldest.getLastStateChangeTimestamp();
        return age > this._config.getMinEvictableIdleTimeMillis();
    }

    private void disposeNoException(T object) {
        try {
            this._handler.disposeObject(object);
        }
        catch (Exception e) {
            _log.warn(e, "disposeObject() is not supposed to throw", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PooledObject<T> {
        private final T _object;
        private boolean _isActive;
        private long _lastStateChangeTimestamp;
        private boolean _isNew;

        public PooledObject(T object) {
            this._object = object;
            this._isNew = true;
            this.touch();
        }

        public T getObject() {
            return this._object;
        }

        public boolean isNew() {
            return this._isNew;
        }

        public void setNew(boolean n) {
            this._isNew = n;
        }

        public void setActive(boolean v) {
            if (this._isActive != v) {
                this.touch();
                this._isActive = v;
            }
        }

        private void touch() {
            this._lastStateChangeTimestamp = System.currentTimeMillis();
        }

        public long getLastStateChangeTimestamp() {
            return this._lastStateChangeTimestamp;
        }
    }

    public static final class Statistics {
        private final int _numIdle;
        private final int _numActive;

        private Statistics(int numIdle, int numActive) {
            this._numIdle = numIdle;
            this._numActive = numActive;
        }

        public int getNumIdle() {
            return this._numIdle;
        }

        public int getNumActive() {
            return this._numActive;
        }
    }
}

