/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.handlers;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.List;
import javax.xml.namespace.QName;

public class NoOpTaskHandler
implements TaskHandler {
    private static final transient Trace LOGGER = TraceManager.getTrace(NoOpTaskHandler.class);
    private static final String HANDLER_URI = "http://midpoint.evolveum.com/repo/noop-handler-1";
    public static final String EXT_SCHEMA_URI = "http://midpoint.evolveum.com/repo/noop-handler-1";
    public static final QName DELAY_QNAME = new QName("http://midpoint.evolveum.com/repo/noop-handler-1", "delay");
    public static final QName STEPS_QNAME = new QName("http://midpoint.evolveum.com/repo/noop-handler-1", "steps");
    private static NoOpTaskHandler instance = null;
    private TaskManagerQuartzImpl taskManagerImpl;

    private NoOpTaskHandler() {
    }

    public static void instantiateAndRegister(TaskManager taskManager) {
        if (instance == null) {
            instance = new NoOpTaskHandler();
        }
        taskManager.registerHandler("http://midpoint.evolveum.com/repo/noop-handler-1", (TaskHandler)instance);
        NoOpTaskHandler.instance.taskManagerImpl = (TaskManagerQuartzImpl)taskManager;
    }

    public TaskRunResult run(Task task) {
        long progress = task.getProgress();
        OperationResult opResult = new OperationResult(String.valueOf(NoOpTaskHandler.class.getName()) + ".run");
        TaskRunResult runResult = new TaskRunResult();
        runResult.setOperationResult(opResult);
        PrismContainer taskExtension = task.getExtension();
        PrismProperty delayProp = taskExtension != null ? taskExtension.findProperty(DELAY_QNAME) : null;
        PrismProperty stepsProp = taskExtension != null ? taskExtension.findProperty(STEPS_QNAME) : null;
        PrismPropertyDefinition delayPropDef = new PrismPropertyDefinition(DELAY_QNAME, DELAY_QNAME, DOMUtil.XSD_INT, this.taskManagerImpl.getPrismContext());
        PrismPropertyDefinition stepsPropDef = new PrismPropertyDefinition(STEPS_QNAME, STEPS_QNAME, DOMUtil.XSD_INT, this.taskManagerImpl.getPrismContext());
        try {
            if (delayProp != null) {
                delayProp.applyDefinition((ItemDefinition)delayPropDef);
            }
            if (stepsProp != null) {
                stepsProp.applyDefinition((ItemDefinition)stepsPropDef);
            }
        }
        catch (SchemaException se) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot apply Prism definition to delay and/or steps property, exiting immediately.", (Throwable)se, (Object[])new Object[0]);
            opResult.recordFatalError("Cannot apply Prism definition to delay and/or steps property, exiting immediately.", (Throwable)se);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        long delay = delayProp != null && !delayProp.getValues().isEmpty() ? (long)((Integer)((PrismPropertyValue)delayProp.getValues().get(0)).getValue()).intValue() : 0L;
        int steps = stepsProp != null && !stepsProp.getValues().isEmpty() ? (Integer)((PrismPropertyValue)stepsProp.getValues().get(0)).getValue() : 1;
        LOGGER.info("NoOpTaskHandler run starting; progress = " + progress + ", steps to be executed = " + steps + ", delay for one step = " + delay + " in task " + task.getName());
        int i = 0;
        while (i < steps) {
            long delta;
            LOGGER.info("NoOpTaskHandler: executing step " + (i + 1) + " of " + steps + " in task " + task.getName());
            ++progress;
            long sleepUntil = System.currentTimeMillis() + delay;
            while ((delta = sleepUntil - System.currentTimeMillis()) > 0L) {
                try {
                    Thread.sleep(delta);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!task.canRun()) {
                LOGGER.info("NoOpTaskHandler: got a shutdown request, finishing task " + task.getName());
                break;
            }
            ++i;
        }
        opResult.recordSuccess();
        runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        runResult.setProgress(progress);
        LOGGER.info("NoOpTaskHandler run finishing; progress = " + progress + " in task " + task.getName());
        return runResult;
    }

    public Long heartbeat(Task task) {
        return null;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "Demo";
    }

    public List<String> getCategoryNames() {
        return null;
    }
}

