/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedKeyTokenSTRParser
implements STRParser {
    private byte[] secretKey;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        WSSecurityEngineResult result;
        boolean bspCompliant = true;
        Crypto crypto = data.getDecCrypto();
        WSSConfig config = data.getWssConfig();
        if (config != null) {
            bspCompliant = config.isWsiBSPCompliant();
        }
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, bspCompliant);
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
        }
        if ((result = wsDocInfo.getResult(uri)) != null) {
            this.processPreviousResult(result, secRef, data, wsDocInfo, bspCompliant);
        } else if (secRef.containsReference()) {
            this.secretKey = this.getSecretKeyFromToken(uri, null, 6, data);
            if (this.secretKey == null) {
                throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
            }
        } else if (secRef.containsKeyIdentifier()) {
            String keyIdentifierValueType = secRef.getKeyIdentifierValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(keyIdentifierValueType)) {
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), keyIdentifierValueType, 9, data);
                if (this.secretKey == null) {
                    byte[] keyBytes = secRef.getSKIBytes();
                    List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                    for (WSSecurityEngineResult bstResult : resultsList) {
                        BinarySecurity bstToken = (BinarySecurity)bstResult.get("binary-security-token");
                        byte[] tokenDigest = WSSecurityUtil.generateDigest(bstToken.getToken());
                        if (!Arrays.equals(tokenDigest, keyBytes)) continue;
                        this.secretKey = (byte[])bstResult.get("secret");
                        break;
                    }
                }
                if (this.secretKey == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
                }
            } else {
                X509Certificate[] certs;
                if (bspCompliant && keyIdentifierValueType.equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                    BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                }
                if ((certs = secRef.getKeyIdentifier(crypto)) == null || certs.length < 1 || certs[0] == null) {
                    this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), keyIdentifierValueType, 9, data);
                    if (this.secretKey == null) {
                        throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
                    }
                } else {
                    this.secretKey = crypto.getPrivateKey(certs[0], data.getCallbackHandler()).getEncoded();
                }
            }
        } else {
            throw new WSSecurityException(6, "unsupportedKeyId");
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    private byte[] getSecretKeyFromToken(String id, String type, int identifier, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, identifier, data);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            if (data.getCallbackHandler() != null) {
                data.getCallbackHandler().handle(callbacks);
                return pwcb.getKey();
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
        }
        return null;
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, WSDocInfo wsDocInfo, boolean bspCompliant) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (8192 == action || 1 == action) {
            if (bspCompliant) {
                BSPEnforcer.checkUsernameTokenBSPCompliance(secRef);
            }
            UsernameToken usernameToken = (UsernameToken)result.get("username-token");
            usernameToken.setRawPassword(data);
            this.secretKey = usernameToken.getDerivedKey();
        } else if (4 == action) {
            if (bspCompliant) {
                BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
            }
            this.secretKey = (byte[])result.get("secret");
        } else if (1024 == action || 4096 == action) {
            this.secretKey = (byte[])result.get("secret");
        } else if (8 == action || 16 == action) {
            AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
            if (bspCompliant) {
                BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
            }
            SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
            this.secretKey = keyInfo.getSecret();
        } else {
            throw new WSSecurityException(6, "unsupportedKeyId");
        }
    }
}

