/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xjc;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.xjc.AnyArrayList;
import com.evolveum.midpoint.prism.xjc.JaxbTypeConverter;
import com.evolveum.midpoint.prism.xjc.PropertyArrayList;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;

public final class PrismForJAXBUtil {
    private PrismForJAXBUtil() {
    }

    public static <T> List<T> getPropertyValues(PrismContainer container, QName name, Class<T> clazz) {
        PrismProperty property;
        Validate.notNull((Object)container, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        Validate.notNull(clazz, (String)"Class type must not be null.");
        try {
            property = container.findOrCreateProperty(name);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        return new PropertyArrayList(property);
    }

    public static <T> T getPropertyValue(PrismContainerValue container, QName name, Class<T> clazz) {
        Validate.notNull((Object)container, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        Validate.notNull(clazz, (String)"Class type must not be null.");
        PrismProperty property = container.findProperty(name);
        return PrismForJAXBUtil.getPropertyValue(property, clazz);
    }

    public static <T> T getPropertyValue(PrismContainer container, QName name, Class<T> clazz) {
        Validate.notNull((Object)container, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        Validate.notNull(clazz, (String)"Class type must not be null.");
        PrismProperty property = container.findProperty(name);
        return PrismForJAXBUtil.getPropertyValue(property, clazz);
    }

    private static <T> T getPropertyValue(PrismProperty<?> property, Class<T> requestedType) {
        if (property == null) {
            return null;
        }
        PrismPropertyValue<?> value = property.getValue();
        if (value == null) {
            return null;
        }
        Object propertyRealValue = value.getValue();
        return JaxbTypeConverter.mapPropertyRealValueToJaxb(propertyRealValue);
    }

    public static <T> List<T> getPropertyValues(PrismContainerValue container, QName name, Class<T> clazz) {
        PrismProperty property;
        Validate.notNull((Object)container, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        Validate.notNull(clazz, (String)"Class type must not be null.");
        try {
            property = container.findOrCreateProperty(name);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        return new PropertyArrayList(property);
    }

    public static <T> void setPropertyValue(PrismContainerValue container, QName name, T value) {
        PrismProperty property;
        Validate.notNull((Object)container, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        try {
            property = container.findOrCreateProperty(name);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        if (value == null) {
            property.clear();
        } else {
            Object propertyRealValue = JaxbTypeConverter.mapJaxbToPropertyRealValue(value);
            property.setValue(new PrismPropertyValue<Object>(propertyRealValue));
        }
    }

    public static <T> void setPropertyValue(PrismContainer container, QName name, T value) {
        PrismForJAXBUtil.setPropertyValue(container.getValue(), name, value);
    }

    public static <T extends Containerable> PrismContainerValue<T> getFieldContainerValue(PrismContainer<?> parent, QName fieldName) {
        Validate.notNull(parent, (String)"Container must not be null.");
        Validate.notNull((Object)fieldName, (String)"Field QName must not be null.");
        return PrismForJAXBUtil.getFieldContainerValue(parent.getValue(), fieldName);
    }

    public static <T extends Containerable> PrismContainerValue<T> getFieldContainerValue(PrismContainerValue<?> parent, QName fieldName) {
        Validate.notNull(parent, (String)"Container value must not be null.");
        Validate.notNull((Object)fieldName, (String)"Field QName must not be null.");
        PrismContainer container = parent.findItem(fieldName, PrismContainer.class);
        return container != null ? container.getValue() : null;
    }

    public static <T extends Containerable> T getFieldSingleContainerable(PrismContainerValue<?> parent, QName fieldName, Class<T> fieldClass) {
        PrismContainerValue<T> fieldContainerValue = PrismForJAXBUtil.getFieldContainerValue(parent, fieldName);
        if (fieldContainerValue == null) {
            return null;
        }
        return fieldContainerValue.asContainerable(fieldClass);
    }

    public static <T extends PrismContainer<?>> T getContainer(PrismContainerValue value, QName name) {
        Validate.notNull((Object)value, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        return PrismForJAXBUtil.getContainer(value.getContainer(), name);
    }

    public static <T extends PrismContainer<?>> T getContainer(PrismContainer<?> parent, QName name) {
        Validate.notNull(parent, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        try {
            return (T)parent.findOrCreateContainer(name);
        }
        catch (SchemaException ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static <T extends Containerable> boolean setFieldContainerValue(PrismContainerValue<?> parent, QName fieldName, PrismContainerValue<T> fieldContainerValue) {
        Validate.notNull(parent, (String)"Prism container value must not be null.");
        Validate.notNull((Object)fieldName, (String)"QName must not be null.");
        try {
            PrismContainer<Object> fieldContainer = null;
            if (fieldContainerValue == null) {
                fieldContainer = parent.findOrCreateContainer(fieldName);
                if (fieldContainer != null) {
                    fieldContainer.clear();
                }
            } else {
                fieldContainer = new PrismContainer(fieldName);
                fieldContainer.add(fieldContainerValue);
                if (parent.getContainer() == null) {
                    parent.add(fieldContainer);
                } else {
                    parent.getContainer().getValue().addReplaceExisting(fieldContainer);
                }
            }
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        return true;
    }

    public static boolean setFieldContainerValue(PrismContainer<?> parent, QName fieldName, PrismContainerValue<?> fieldContainerValue) {
        return PrismForJAXBUtil.setFieldContainerValue(parent.getValue(), fieldName, fieldContainerValue);
    }

    public static PrismReferenceValue getReferenceValue(PrismContainerValue<?> parent, QName name) {
        Validate.notNull(parent, (String)"Prism container value must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        PrismReference reference = parent.findItem(name, PrismReference.class);
        return reference != null ? reference.getValue() : null;
    }

    public static PrismReferenceValue getReferenceValue(PrismContainer parent, QName name) {
        Validate.notNull((Object)parent, (String)"Prism container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        PrismReference reference = PrismForJAXBUtil.getReference(parent, name);
        return reference != null ? reference.getValue() : null;
    }

    public static PrismReference getReference(PrismContainer parent, QName name) {
        Validate.notNull((Object)parent, (String)"Prism container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        return parent.findReference(name);
    }

    public static void setReferenceValueAsRef(PrismContainerValue<?> parentValue, QName referenceName, PrismReferenceValue value) {
        PrismReference reference;
        Validate.notNull(parentValue, (String)"Prism container value must not be null.");
        Validate.notNull((Object)referenceName, (String)"QName must not be null.");
        try {
            reference = parentValue.findOrCreateItem(referenceName, PrismReference.class);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        if (reference == null) {
            throw new IllegalArgumentException("No reference " + referenceName + " in " + parentValue);
        }
        if (reference.isEmpty()) {
            reference.add(value);
        } else if (value == null) {
            reference.getValue().setOid(null);
            reference.getValue().setTargetType(null);
            reference.getValue().setFilter(null);
            reference.getValue().setDescription(null);
        } else {
            reference.getValue().setOid(value.getOid());
            reference.getValue().setTargetType(value.getTargetType());
            reference.getValue().setFilter(value.getFilter());
            reference.getValue().setDescription(value.getDescription());
        }
    }

    public static void setReferenceValueAsRef(PrismContainer parent, QName name, PrismReferenceValue value) {
        PrismForJAXBUtil.setReferenceValueAsRef(parent.getValue(), name, value);
    }

    public static void setReferenceValueAsObject(PrismContainerValue parentValue, QName referenceQName, PrismObject targetObject) {
        PrismReference reference;
        Validate.notNull((Object)parentValue, (String)"Prism container value must not be null.");
        Validate.notNull((Object)referenceQName, (String)"QName must not be null.");
        try {
            reference = parentValue.findOrCreateReference(referenceQName);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        if (reference == null) {
            throw new IllegalArgumentException("No reference " + referenceQName + " in " + parentValue);
        }
        PrismReferenceValue referenceValue = reference.getValue();
        referenceValue.setObject(targetObject);
    }

    public static void setReferenceValueAsObject(PrismContainer parent, QName referenceQName, PrismObject targetObject) {
        PrismForJAXBUtil.setReferenceValueAsObject(parent.getValue(), referenceQName, targetObject);
    }

    public static <T extends Objectable> PrismReferenceValue objectableAsReferenceValue(T objectable, PrismReference reference) {
        PrismObject object = objectable.asPrismObject();
        for (PrismReferenceValue refValue : reference.getValues()) {
            if (object != refValue.getObject()) continue;
            return refValue;
        }
        PrismReferenceValue referenceValue = new PrismReferenceValue();
        referenceValue.setObject(object);
        return referenceValue;
    }

    public static <T extends Containerable> List<PrismContainerValue<T>> getContainerValues(PrismContainerValue<T> parent, QName name, Class<T> clazz) {
        return PrismForJAXBUtil.getContainerValues(parent.getContainer(), name, clazz);
    }

    public static <T extends Containerable> List<PrismContainerValue<T>> getContainerValues(PrismContainer<T> parent, QName name, Class<T> clazz) {
        PrismContainer container;
        Validate.notNull(parent, (String)"Container must not be null.");
        Validate.notNull((Object)name, (String)"QName must not be null.");
        try {
            container = parent.findOrCreateContainer(name);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        return container.getValues();
    }

    public static <T> List<T> getAny(PrismContainerValue value, Class<T> clazz) {
        return new AnyArrayList(value);
    }

    public static PrismObject setupContainerValue(PrismObject prismObject, PrismContainerValue containerValue) {
        Itemable parent = containerValue.getParent();
        if (parent != null && parent instanceof PrismObject) {
            return (PrismObject)parent;
        }
        try {
            prismObject.setValue(containerValue);
            return prismObject;
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    public static PrismReference getReference(PrismContainerValue parent, QName fieldName) {
        try {
            return parent.findOrCreateReference(fieldName);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }
}

