/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.util;

import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.util.DOMUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PrismUtil {
    public static void fortifyNamespaceDeclarations(Element definitionElement) {
        for (Element childElement : DOMUtil.listChildElements((Node)definitionElement)) {
            PrismUtil.fortifyNamespaceDeclarations(definitionElement, childElement);
        }
    }

    private static void fortifyNamespaceDeclarations(Element definitionElement, Element childElement) {
        Document doc = definitionElement.getOwnerDocument();
        NamedNodeMap attributes = childElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            if (DOMUtil.isNamespaceDefinition((Attr)attr)) {
                String prefix = DOMUtil.getNamespaceDeclarationPrefix((Attr)attr);
                String namespace = DOMUtil.getNamespaceDeclarationNamespace((Attr)attr);
                Element namespaceElement = doc.createElementNS(PrismConstants.A_NAMESPACE.getNamespaceURI(), PrismConstants.A_NAMESPACE.getLocalPart());
                namespaceElement.setAttribute("prefix", prefix);
                namespaceElement.setAttribute("url", namespace);
                definitionElement.insertBefore(namespaceElement, childElement);
            }
            ++i;
        }
    }

    public static void unfortifyNamespaceDeclarations(Element definitionElement) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (Element childElement : DOMUtil.listChildElements((Node)definitionElement)) {
            if (PrismConstants.A_NAMESPACE.equals(DOMUtil.getQName((Node)childElement))) {
                String prefix = childElement.getAttribute("prefix");
                String namespace = childElement.getAttribute("url");
                namespaces.put(prefix, namespace);
                definitionElement.removeChild(childElement);
                continue;
            }
            PrismUtil.unfortifyNamespaceDeclarations(definitionElement, childElement, namespaces);
            namespaces = new HashMap();
        }
    }

    private static void unfortifyNamespaceDeclarations(Element definitionElement, Element childElement, Map<String, String> namespaces) {
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            String prefix = entry.getKey();
            String namespace = entry.getValue();
            String declaredNamespace = DOMUtil.getNamespaceDeclarationForPrefix((Element)childElement, (String)prefix);
            if (declaredNamespace == null) {
                DOMUtil.setNamespaceDeclaration((Element)childElement, (String)prefix, (String)namespace);
                continue;
            }
            if (namespace.equals(declaredNamespace)) continue;
            throw new IllegalStateException("Namespace declaration with prefix '" + prefix + "' that was used to declare " + "namespace '" + namespace + "' is now used for namespace '" + declaredNamespace + "', cannot unfortify.");
        }
    }
}

