/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.dom;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.dom.ElementPrismAbstractImpl;
import com.evolveum.midpoint.prism.dom.NamedNodeMapEmptyImpl;
import com.evolveum.midpoint.prism.dom.NodeListEmptyImpl;
import com.evolveum.midpoint.prism.dom.NodeListPrismPropertyImpl;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementPrismPropertyImpl<T>
extends ElementPrismAbstractImpl {
    private PrismPropertyValue value;
    private NodeList valueNodeList;
    private Element delegateElement;

    public ElementPrismPropertyImpl(PrismPropertyValue value) {
        super(value);
        this.value = value;
    }

    private void lazyInit() {
        if (this.valueNodeList != null || this.delegateElement != null) {
            return;
        }
        Class<?> type = this.value.getValue().getClass();
        if (XmlTypeConverter.canConvert(type)) {
            this.valueNodeList = new NodeListPrismPropertyImpl(this);
        } else {
            PrismContext prismContext = this.getItem().getPrismContext();
            PrismJaxbProcessor jaxbProcessor = prismContext.getPrismJaxbProcessor();
            if (jaxbProcessor.canConvert(type)) {
                try {
                    this.delegateElement = jaxbProcessor.marshalObjectToDom(this.value.getValue(), this.getItem().getName(), (Document)null);
                }
                catch (JAXBException e) {
                    DOMException domException = new DOMException(11, "Error converting the value of type " + type + ": " + e.getMessage());
                    domException.initCause(e);
                    throw domException;
                }
            } else {
                throw new DOMException(11, "The value of type " + type + " cannot be converted to DOM");
            }
        }
    }

    private boolean isDelegate() {
        return this.delegateElement != null;
    }

    @Override
    protected PrismPropertyValue getValue() {
        return (PrismPropertyValue)super.getValue();
    }

    protected PrismProperty getProperty() {
        return (PrismProperty)this.getItem();
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getXmlValue();
    }

    String getXmlValue() {
        PrismPropertyValue propertyValue = this.getValue();
        String xmlStringValue = XmlTypeConverter.toXmlTextContent(propertyValue.getValue(), this.getElementName());
        return xmlStringValue;
    }

    void setXmlValue(String newValue) {
        PrismPropertyValue propertyValue = this.getValue();
        PrismProperty property = this.getProperty();
        Class type = property.getValueClass();
        Object javaValue = XmlTypeConverter.toJavaValue(newValue, type);
        propertyValue.setValue(javaValue);
    }

    @Override
    protected NodeList getValueNodeList() {
        this.lazyInit();
        if (this.isDelegate()) {
            return this.delegateElement.getChildNodes();
        }
        return this.valueNodeList;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return NodeListEmptyImpl.IMMUTABLE_EMPTY_NODELIST;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public boolean hasChildNodes() {
        this.lazyInit();
        if (this.isDelegate()) {
            return this.delegateElement.hasChildNodes();
        }
        return this.getValue().getValue() != null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw new DOMException(9, "DOM clonning is not supported (yet)");
    }

    @Override
    public NamedNodeMap getAttributes() {
        return NamedNodeMapEmptyImpl.IMMUTABLE_EMPTY_NAMED_NODE_MAP;
    }

    @Override
    public String getAttribute(String name) {
        return null;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Attr getAttributeNode(String name) {
        return null;
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public boolean hasAttribute(String name) {
        return false;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return false;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }
}

