/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.dom;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.util.PrismUtil;
import com.evolveum.midpoint.prism.xml.DynamicNamespacePrefixMapper;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomSerializer {
    private PrismContext prismContext;
    private Document doc;
    private Element topElement;
    private boolean serializeCompositeObjects = false;

    DomSerializer(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public boolean isSerializeCompositeObjects() {
        return this.serializeCompositeObjects;
    }

    public void setSerializeCompositeObjects(boolean serializeCompositeObjects) {
        this.serializeCompositeObjects = serializeCompositeObjects;
    }

    private DynamicNamespacePrefixMapper getNamespacePrefixMapper() {
        return this.prismContext.getSchemaRegistry().getNamespacePrefixMapper();
    }

    public Element serialize(PrismObject<?> object) throws SchemaException {
        this.initialize();
        Element topElement = this.createElement(object.getName());
        this.serialize(object, topElement);
        return topElement;
    }

    private void serialize(PrismObject<?> object, QName elementName, Element parentElement) throws SchemaException {
        Element topElement = this.createElement(elementName);
        parentElement.appendChild(topElement);
        this.serialize(object, topElement);
    }

    private void serialize(PrismObject<?> object, Element topElement) throws SchemaException {
        this.serializeItems(object.getValue().getItems(), object.getDefinition(), topElement);
        if (object.getOid() != null) {
            topElement.setAttribute("oid", object.getOid());
        }
        if (object.getVersion() != null) {
            topElement.setAttribute("version", object.getVersion());
        }
        if (object.getDefinition() != null && !this.prismContext.getSchemaRegistry().hasImplicitTypeDefinition(object.getName(), object.getDefinition().getTypeName())) {
            DOMUtil.setXsiType((Element)topElement, (QName)object.getDefinition().getTypeName());
        }
    }

    private void initialize() {
        this.doc = DOMUtil.getDocument();
        this.topElement = null;
    }

    public Element serializeContainerValue(PrismContainerValue<?> value, Element parentElement) throws SchemaException {
        this.initialize();
        this.doc = parentElement.getOwnerDocument();
        this.serialize(value, parentElement);
        return parentElement;
    }

    private void serialize(PrismContainerValue<?> value, Element parentElement) throws SchemaException {
        Itemable parent = value.getParent();
        QName elementQName = parent.getName();
        Element element = this.createElement(elementQName);
        parentElement.appendChild(element);
        this.serializeItems(value.getItems(), parent.getDefinition(), element);
        if (value.getId() != null) {
            element.setAttribute("id", value.getId());
        }
    }

    private void serialize(PrismPropertyValue<?> value, Element parentElement) throws SchemaException {
        Itemable parent = value.getParent();
        QName elementName = parent.getName();
        if (value.getRawElement() != null) {
            this.serializeRawElement(value.getRawElement(), parentElement);
            return;
        }
        Class<?> type = value.getValue().getClass();
        if (value.getValue() instanceof Element) {
            Element originalValueElement = (Element)value.getValue();
            DOMUtil.fixNamespaceDeclarations((Element)originalValueElement);
            Element adoptedElement = (Element)parentElement.getOwnerDocument().importNode(originalValueElement, true);
            parentElement.appendChild(adoptedElement);
            PrismUtil.fortifyNamespaceDeclarations(adoptedElement);
        } else if (XmlTypeConverter.canConvert(type)) {
            Element element = this.createElement(elementName);
            parentElement.appendChild(element);
            XmlTypeConverter.toXsdElement(value.getValue(), element, false);
            ItemDefinition definition = parent.getDefinition();
            if (definition != null && definition.isDynamic()) {
                DOMUtil.setXsiType((Element)element, (QName)definition.getTypeName());
            }
        } else {
            PrismJaxbProcessor jaxbProcessor = this.prismContext.getPrismJaxbProcessor();
            if (jaxbProcessor.canConvert(type)) {
                try {
                    jaxbProcessor.marshalObjectToDom(value.getValue(), elementName, parentElement);
                }
                catch (JAXBException e) {
                    throw new SchemaException("Cannot process value of property " + elementName + ": " + value + ": " + e.getMessage(), (Throwable)e);
                }
            } else {
                throw new SchemaException("Cannot process value of property " + elementName + ": " + value + ": No processor available");
            }
        }
    }

    private String multiplicityToString(int maxOccurs) {
        if (maxOccurs < 0) {
            return "unbounded";
        }
        return String.valueOf(maxOccurs);
    }

    private void serializeRawElement(Object rawElement, Element parentElement) throws SchemaException {
        if (rawElement instanceof Element) {
            Document ownerDocument = parentElement.getOwnerDocument();
            Element adoptedElement = (Element)ownerDocument.adoptNode((Element)rawElement);
            parentElement.appendChild(adoptedElement);
        } else if (rawElement instanceof JAXBElement) {
            PrismJaxbProcessor jaxbProcessor = this.prismContext.getPrismJaxbProcessor();
            try {
                jaxbProcessor.marshalElementToDom((JAXBElement)rawElement, parentElement);
            }
            catch (JAXBException e) {
                throw new SchemaException("Error processing element " + rawElement + ": " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Cannot process raw element " + rawElement + " of type " + rawElement.getClass());
        }
    }

    private void serialize(PrismReferenceValue value, Element parentElement) throws SchemaException {
        if (this.serializeCompositeObjects && value.getObject() != null) {
            this.serializeObject(value, parentElement);
        } else {
            this.serializeRef(value, parentElement);
        }
    }

    private void serializeRef(PrismReferenceValue value, Element parentElement) throws SchemaException {
        Document doc;
        String namespace;
        Itemable parent = value.getParent();
        Element element = this.createElement(parent.getName());
        parentElement.appendChild(element);
        element.setAttribute("oid", value.getOid());
        if (value.getTargetType() != null) {
            QName targetType = value.getTargetType();
            targetType = this.getNamespacePrefixMapper().setQNamePrefixExplicit(targetType);
            try {
                DOMUtil.setQNameAttribute((Element)element, (String)"type", (QName)targetType);
            }
            catch (IllegalArgumentException e) {
                throw new SchemaException(String.valueOf(e.getMessage()) + " in type field of reference " + parent.getName());
            }
        }
        if (value.getDescription() != null) {
            namespace = this.prismContext.getPrismDomProcessor().determineElementNamespace(parent, "description");
            doc = element.getOwnerDocument();
            Element descriptionElement = doc.createElementNS(namespace, "description");
            element.appendChild(descriptionElement);
            descriptionElement.setTextContent(value.getDescription());
        }
        if (value.getFilter() != null) {
            namespace = this.prismContext.getPrismDomProcessor().determineElementNamespace(parent, "filter");
            doc = element.getOwnerDocument();
            Element filterElement = doc.createElementNS(namespace, "filter");
            element.appendChild(filterElement);
            Element adoptedElement = (Element)doc.adoptNode(value.getFilter().cloneNode(true));
            filterElement.appendChild(adoptedElement);
        }
    }

    private void serializeObject(PrismReferenceValue value, Element parentElement) throws SchemaException {
        Itemable parent = value.getParent();
        PrismReferenceDefinition definition = (PrismReferenceDefinition)parent.getDefinition();
        if (definition == null) {
            throw new SchemaException("Cannot serialize object in reference " + parent + " as the reference has no definition");
        }
        QName compositeObjectElementName = definition.getCompositeObjectElementName();
        if (compositeObjectElementName == null) {
            throw new SchemaException("Cannot serialize composite object in " + DOMUtil.getQName((Node)parentElement) + " because the composite element" + "name for reference " + definition + " is not defined");
        }
        this.serialize(value.getObject(), compositeObjectElementName, parentElement);
    }

    private void serializeItems(List<Item<?>> items, PrismContainerDefinition definition, Element parentElement) throws SchemaException {
        ComplexTypeDefinition complexTypeDefinition;
        if (definition != null && !definition.isDynamic() && (complexTypeDefinition = definition.getComplexTypeDefinition()) != null) {
            this.serializeItemsUsingDefinition(items, complexTypeDefinition, parentElement);
            return;
        }
        for (Item<?> item : items) {
            this.serialize(item, parentElement);
        }
    }

    private void serializeItemsUsingDefinition(List<Item<?>> items, ComplexTypeDefinition definition, Element parentElement) throws SchemaException {
        for (ItemDefinition itemDef : definition.getDefinitions()) {
            Item<?> item = this.findItem(items, itemDef);
            if (item == null) continue;
            this.serialize(item, parentElement);
        }
    }

    private Item<?> findItem(List<Item<?>> items, ItemDefinition itemDef) {
        QName itemName = itemDef.getName();
        for (Item<?> item : items) {
            if (!itemName.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    <V extends PrismValue> void serialize(Item<V> item, Element parentElement) throws SchemaException {
        if (item instanceof PrismReference) {
            this.serialize((PrismReference)item, parentElement);
        } else {
            for (PrismValue pval : item.getValues()) {
                if (!item.equals(pval.getParent())) {
                    throw new IllegalArgumentException("The parent for value " + pval + " of item " + item + " is incorrect");
                }
                this.serialize(pval, parentElement);
            }
        }
    }

    private void serialize(PrismReference item, Element parentElement) throws SchemaException {
        for (PrismReferenceValue pval : item.getValues()) {
            if (pval.getObject() == null) continue;
            if (!item.equals(pval.getParent())) {
                throw new IllegalArgumentException("The parent for value " + pval + " of item " + item + " is incorrect");
            }
            this.serialize(pval, parentElement);
        }
        for (PrismReferenceValue pval : item.getValues()) {
            if (pval.getObject() != null) continue;
            if (!item.equals(pval.getParent())) {
                throw new IllegalArgumentException("The parent for value " + pval + " of item " + item + " is incorrect");
            }
            this.serialize(pval, parentElement);
        }
    }

    void serialize(PrismValue pval, Element parentElement) throws SchemaException {
        if (this.doc == null) {
            this.doc = parentElement.getOwnerDocument();
        }
        if (pval instanceof PrismContainerValue) {
            this.serialize((PrismContainerValue)pval, parentElement);
        } else if (pval instanceof PrismPropertyValue) {
            this.serialize((PrismPropertyValue)pval, parentElement);
        } else if (pval instanceof PrismReferenceValue) {
            this.serialize((PrismReferenceValue)pval, parentElement);
        } else {
            throw new IllegalArgumentException("Unknown value type " + pval);
        }
    }

    private Element createElement(QName qname) {
        QName qnameWithPrefix = this.getNamespacePrefixMapper().setQNamePrefix(qname);
        if (this.topElement != null) {
            return DOMUtil.createElement((Document)this.doc, (QName)qnameWithPrefix, (Element)this.topElement, (Element)this.topElement);
        }
        return DOMUtil.createElement((Document)this.doc, (QName)qnameWithPrefix);
    }
}

