/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;

public class PropertyDelta<T>
extends ItemDelta<PrismPropertyValue<T>> {
    public PropertyDelta(PrismPropertyDefinition propertyDefinition) {
        super(propertyDefinition);
    }

    public PropertyDelta(QName name, PrismPropertyDefinition propertyDefinition) {
        super(name, (ItemDefinition)propertyDefinition);
    }

    public PropertyDelta(PropertyPath parentPath, QName name, PrismPropertyDefinition propertyDefinition) {
        super(parentPath, name, propertyDefinition);
    }

    public PropertyDelta(PropertyPath propertyPath, PrismPropertyDefinition propertyDefinition) {
        super(propertyPath, (ItemDefinition)propertyDefinition);
    }

    PrismPropertyDefinition getPropertyDefinition() {
        return (PrismPropertyDefinition)super.getDefinition();
    }

    void setPropertyDefinition(PrismPropertyDefinition propertyDefinition) {
        super.setDefinition(propertyDefinition);
    }

    @Override
    public void setDefinition(ItemDefinition definition) {
        if (!(definition instanceof PrismPropertyDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to property delta");
        }
        super.setDefinition(definition);
    }

    @Override
    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        if (!(definition instanceof PrismPropertyDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to a property delta " + this);
        }
        super.applyDefinition(definition);
    }

    @Override
    public Class<PrismProperty> getItemClass() {
        return PrismProperty.class;
    }

    public <T> Collection<PrismPropertyValue<T>> getValues(Class<T> type) {
        this.checkConsistence();
        if (this.valuesToReplace != null) {
            return this.valuesToReplace;
        }
        return MiscUtil.union((Collection[])new Collection[]{this.valuesToAdd, this.valuesToDelete});
    }

    public <P extends PrismProperty> P instantiateEmptyProperty() {
        PrismPropertyDefinition propertyDefinition = this.getPropertyDefinition();
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Cannot instantiate property " + this.getName() + " from delta " + this + ": no definition");
        }
        return (P)propertyDefinition.instantiate(this.getName());
    }

    @Override
    public void applyTo(Item item) throws SchemaException {
        if (!(item instanceof PrismProperty)) {
            throw new SchemaException("Cannot apply property delta " + this + " to item " + item + " of type " + item.getClass());
        }
        super.applyTo(item);
    }

    @Override
    public PropertyDelta<T> clone() {
        PropertyDelta<T> clone = new PropertyDelta<T>(this.getName(), this.getPropertyDefinition());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PropertyDelta<T> clone) {
        super.copyValues(clone);
    }

    public static <O extends Objectable> PropertyDelta createReplaceDelta(PrismContainerDefinition<O> containerDefinition, QName propertyName, Object ... realValues) {
        PrismPropertyDefinition propertyDefinition = containerDefinition.findPropertyDefinition(propertyName);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("No definition for " + propertyName + " in " + containerDefinition);
        }
        PropertyDelta delta = new PropertyDelta(propertyName, propertyDefinition);
        Collection valuesToReplace = delta.getValuesToReplace();
        if (valuesToReplace == null) {
            valuesToReplace = new ArrayList(realValues.length);
        }
        Object[] objectArray = realValues;
        int n = realValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object realVal = objectArray[n2];
            valuesToReplace.add(new PrismPropertyValue<Object>(realVal));
            ++n2;
        }
        delta.setValuesToReplace(valuesToReplace);
        return delta;
    }

    public static <O extends Objectable> PropertyDelta createReplaceEmptyDelta(PrismObjectDefinition<O> objectDefinition, QName propertyName) {
        PrismPropertyDefinition propertyDefinition = objectDefinition.findPropertyDefinition(propertyName);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("No definition for " + propertyName + " in " + objectDefinition);
        }
        PropertyDelta delta = new PropertyDelta(propertyName, propertyDefinition);
        delta.setValuesToReplace(new ArrayList());
        return delta;
    }

    public static <O extends Objectable> PropertyDelta<?> createReplaceDeltaOrEmptyDelta(PrismObjectDefinition<O> objectDefinition, QName propertyName, Object realValue) {
        if (realValue != null) {
            return PropertyDelta.createReplaceDelta(objectDefinition, propertyName, realValue);
        }
        return PropertyDelta.createReplaceEmptyDelta(objectDefinition, propertyName);
    }

    public boolean isRealValueToAdd(PrismPropertyValue<?> value) {
        if (this.valuesToAdd == null) {
            return false;
        }
        for (PrismPropertyValue valueToAdd : this.valuesToAdd) {
            if (!valueToAdd.equalsRealValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isRealValueToDelete(PrismPropertyValue<?> value) {
        if (this.valuesToDelete == null) {
            return false;
        }
        for (PrismPropertyValue valueToAdd : this.valuesToDelete) {
            if (!valueToAdd.equalsRealValue(value)) continue;
            return true;
        }
        return false;
    }

    public PrismProperty<T> getPropertyNew() {
        return (PrismProperty)super.getItemNew();
    }

    public static PropertyDelta createDelta(PropertyPath propertyPath, PrismObjectDefinition<?> objectDefinition) {
        PrismPropertyDefinition propDef = objectDefinition.findPropertyDefinition(propertyPath);
        return new PropertyDelta(propertyPath, propDef);
    }

    public static <T extends Objectable> PropertyDelta createDelta(PropertyPath propertyPath, Class<T> compileTimeClass, PrismContext prismContext) {
        PrismObjectDefinition<T> objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(compileTimeClass);
        PrismPropertyDefinition propDef = objectDefinition.findPropertyDefinition(propertyPath);
        return new PropertyDelta<T>(propertyPath, propDef);
    }

    public static PropertyDelta createModificationReplaceProperty(QName propertyName, PrismObjectDefinition<?> objectDefinition, Object ... propertyValues) {
        PrismPropertyDefinition propDef = objectDefinition.findPropertyDefinition(propertyName);
        PropertyDelta propertyDelta = new PropertyDelta(propertyName, propDef);
        ArrayList<PrismPropertyValue<Object>> pValues = new ArrayList<PrismPropertyValue<Object>>(propertyValues.length);
        Object[] objectArray = propertyValues;
        int n = propertyValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            pValues.add(new PrismPropertyValue<Object>(val));
            ++n2;
        }
        propertyDelta.setValuesToReplace(pValues);
        return propertyDelta;
    }

    public static Collection<? extends ItemDelta> createModificationReplacePropertyCollection(QName propertyName, PrismObjectDefinition<?> objectDefinition, Object ... propertyValues) {
        ArrayList<PropertyDelta> modifications = new ArrayList<PropertyDelta>(1);
        PropertyDelta delta = PropertyDelta.createModificationReplaceProperty(propertyName, objectDefinition, propertyValues);
        modifications.add(delta);
        return modifications;
    }

    public static PropertyDelta findPropertyDelta(Collection<? extends ItemDelta> modifications, PropertyPath propertyPath) {
        for (ItemDelta itemDelta : modifications) {
            if (!(itemDelta instanceof PropertyDelta) || !itemDelta.getPath().equals(propertyPath)) continue;
            return (PropertyDelta)itemDelta;
        }
        return null;
    }

    public static PropertyDelta findPropertyDelta(Collection<? extends ItemDelta> modifications, QName propertyName) {
        for (ItemDelta itemDelta : modifications) {
            if (!(itemDelta instanceof PropertyDelta) || !itemDelta.getParentPath().isEmpty() || !itemDelta.getName().equals(propertyName)) continue;
            return (PropertyDelta)itemDelta;
        }
        return null;
    }
}

