/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;

public abstract class ItemDelta<V extends PrismValue>
implements Itemable,
Dumpable,
DebugDumpable,
Serializable {
    protected QName name;
    protected PropertyPath parentPath;
    protected ItemDefinition definition;
    protected Collection<V> valuesToReplace = null;
    protected Collection<V> valuesToAdd = null;
    protected Collection<V> valuesToDelete = null;

    public ItemDelta(ItemDefinition itemDefinition) {
        this.name = itemDefinition.getName();
        this.parentPath = new PropertyPath();
        this.definition = itemDefinition;
    }

    public ItemDelta(QName name, ItemDefinition itemDefinition) {
        this.name = name;
        this.parentPath = new PropertyPath();
        this.definition = itemDefinition;
    }

    public ItemDelta(PropertyPath parentPath, QName name, ItemDefinition itemDefinition) {
        this.name = name;
        this.parentPath = parentPath;
        this.definition = itemDefinition;
    }

    public ItemDelta(PropertyPath propertyPath, ItemDefinition itemDefinition) {
        this.name = propertyPath.last().getName();
        this.parentPath = propertyPath.allExceptLast();
        this.definition = itemDefinition;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public PropertyPath getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(PropertyPath parentPath) {
        this.parentPath = parentPath;
    }

    public PropertyPath getPath() {
        return this.getParentPath().subPath(this.name);
    }

    @Override
    public PropertyPath getPath(PropertyPath pathPrefix) {
        return pathPrefix.subPath(this.name);
    }

    @Override
    public ItemDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ItemDefinition definition) {
        this.definition = definition;
    }

    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        this.definition = definition;
        if (this.getValuesToAdd() != null) {
            for (PrismValue pval : this.getValuesToAdd()) {
                pval.applyDefinition(definition);
            }
        }
        if (this.getValuesToDelete() != null) {
            for (PrismValue pval : this.getValuesToDelete()) {
                pval.applyDefinition(definition);
            }
        }
        if (this.getValuesToReplace() != null) {
            for (PrismValue pval : this.getValuesToReplace()) {
                pval.applyDefinition(definition);
            }
        }
    }

    public static void applyDefinition(Collection<? extends ItemDelta> deltas, PrismObjectDefinition definition) throws SchemaException {
        for (ItemDelta itemDelta : deltas) {
            PropertyPath path = itemDelta.getPath();
            ItemDefinition itemDefinition = definition.findItemDefinition(path, ItemDefinition.class);
            itemDelta.applyDefinition(itemDefinition);
        }
    }

    @Override
    public PrismContext getPrismContext() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getPrismContext();
    }

    public abstract Class<? extends Item> getItemClass();

    public Collection<V> getValuesToAdd() {
        return this.valuesToAdd;
    }

    public void clearValuesToAdd() {
        this.valuesToAdd = null;
    }

    public Collection<V> getValuesToDelete() {
        return this.valuesToDelete;
    }

    public void clearValuesToDelete() {
        this.valuesToDelete = null;
    }

    public Collection<V> getValuesToReplace() {
        return this.valuesToReplace;
    }

    public void clearValuesToReplace() {
        this.valuesToReplace = null;
    }

    public void addValuesToAdd(Collection<V> newValues) {
        for (PrismValue val : newValues) {
            this.addValueToAdd(val);
        }
    }

    public void addValuesToAdd(V[] newValues) {
        V[] VArray = newValues;
        int n = newValues.length;
        int n2 = 0;
        while (n2 < n) {
            V val = VArray[n2];
            this.addValueToAdd(val);
            ++n2;
        }
    }

    public void addValueToAdd(V newValue) {
        if (this.valuesToReplace != null) {
            throw new IllegalStateException("Delta " + this + " already has values to replace, attempt to add value to add");
        }
        if (this.valuesToAdd == null) {
            this.valuesToAdd = this.newValueCollection();
        }
        this.valuesToAdd.add(newValue);
        ((PrismValue)newValue).setParent(this);
    }

    public void addValuesToDelete(Collection<V> newValues) {
        for (PrismValue val : newValues) {
            this.addValueToDelete(val);
        }
    }

    public void addValuesToDelete(V[] newValues) {
        V[] VArray = newValues;
        int n = newValues.length;
        int n2 = 0;
        while (n2 < n) {
            V val = VArray[n2];
            this.addValueToDelete(val);
            ++n2;
        }
    }

    public void addValueToDelete(V newValue) {
        if (this.valuesToReplace != null) {
            throw new IllegalStateException("Delta " + this + " already has values to replace, attempt to add value to delete");
        }
        if (this.valuesToDelete == null) {
            this.valuesToDelete = this.newValueCollection();
        }
        this.valuesToDelete.add(newValue);
        ((PrismValue)newValue).setParent(this);
    }

    public void setValuesToReplace(Collection<V> newValues) {
        if (this.valuesToAdd != null) {
            throw new IllegalStateException("Delta " + this + " already has values to add, attempt to set value to replace");
        }
        if (this.valuesToDelete != null) {
            throw new IllegalStateException("Delta " + this + " already has values to delete, attempt to set value to replace");
        }
        if (this.valuesToReplace == null) {
            this.valuesToReplace = this.newValueCollection();
        } else {
            this.valuesToReplace.clear();
        }
        for (PrismValue val : newValues) {
            this.valuesToReplace.add(val);
            val.setParent(this);
        }
    }

    public void setValuesToReplace(V[] newValues) {
        if (this.valuesToAdd != null) {
            throw new IllegalStateException("Delta " + this + " already has values to add, attempt to set value to replace");
        }
        if (this.valuesToDelete != null) {
            throw new IllegalStateException("Delta " + this + " already has values to delete, attempt to set value to replace");
        }
        if (this.valuesToReplace == null) {
            this.valuesToReplace = this.newValueCollection();
        } else {
            this.valuesToReplace.clear();
        }
        V[] VArray = newValues;
        int n = newValues.length;
        int n2 = 0;
        while (n2 < n) {
            V val = VArray[n2];
            this.valuesToReplace.add(val);
            ((PrismValue)val).setParent(this);
            ++n2;
        }
    }

    public void setValueToReplace(V newValue) {
        if (this.valuesToAdd != null) {
            throw new IllegalStateException("Delta " + this + " already has values to add, attempt to set value to replace");
        }
        if (this.valuesToDelete != null) {
            throw new IllegalStateException("Delta " + this + " already has values to delete, attempt to set value to replace");
        }
        if (this.valuesToReplace == null) {
            this.valuesToReplace = this.newValueCollection();
        } else {
            this.valuesToReplace.clear();
        }
        this.valuesToReplace.add(newValue);
        ((PrismValue)newValue).setParent(this);
    }

    private Collection<V> newValueCollection() {
        return new ArrayList();
    }

    public boolean isValueToAdd(V value) {
        if (this.valuesToAdd == null) {
            return false;
        }
        return this.valuesToAdd.contains(value);
    }

    public boolean isValueToDelete(V value) {
        if (this.valuesToDelete == null) {
            return false;
        }
        return this.valuesToDelete.contains(value);
    }

    public boolean isEmpty() {
        return this.valuesToAdd == null && this.valuesToDelete == null && this.valuesToReplace == null;
    }

    public boolean isReplace() {
        return this.valuesToReplace != null;
    }

    public boolean isAdd() {
        return this.valuesToAdd != null && !this.valuesToAdd.isEmpty();
    }

    public boolean isDelete() {
        return this.valuesToDelete != null && !this.valuesToDelete.isEmpty();
    }

    public void clear() {
        this.valuesToReplace = null;
        this.valuesToAdd = null;
        this.valuesToDelete = null;
    }

    public static void checkConsistence(Collection<? extends ItemDelta> deltas) {
        for (ItemDelta itemDelta : deltas) {
            itemDelta.checkConsistence();
        }
    }

    public void checkConsistence() {
        if (this.parentPath == null) {
            throw new IllegalStateException("Null parent path in " + this);
        }
        if (this.valuesToReplace != null && (this.valuesToAdd != null || this.valuesToDelete != null)) {
            throw new IllegalStateException("The delta cannot be both 'replace' and 'add/delete' at the same time");
        }
        this.assertSetConsistence(this.valuesToReplace, "replace");
        this.assertSetConsistence(this.valuesToAdd, "add");
        this.assertSetConsistence(this.valuesToDelete, "delete");
    }

    private void assertSetConsistence(Collection<V> values, String type) {
        if (values == null) {
            return;
        }
        for (PrismValue val : values) {
            if (val == null) {
                throw new IllegalStateException("Null value in the " + type + " values set in " + this);
            }
            val.checkConsistenceInternal(this, this.parentPath);
        }
    }

    public void distributeReplace(Collection<V> existingValues) {
        Collection<V> origValuesToReplace = this.getValuesToReplace();
        this.clearValuesToReplace();
        if (existingValues != null) {
            for (PrismValue existingVal : existingValues) {
                if (this.isIn(origValuesToReplace, existingVal)) continue;
                this.addValueToDelete(existingVal.clone());
            }
        }
        for (PrismValue replaceVal : origValuesToReplace) {
            if (this.isIn(existingValues, replaceVal) || this.isIn(this.getValuesToAdd(), replaceVal)) continue;
            this.addValueToAdd(replaceVal);
        }
    }

    private boolean isIn(Collection<V> values, V val) {
        if (values == null) {
            return false;
        }
        for (PrismValue v : values) {
            if (!v.equalsRealValue((PrismValue)val)) continue;
            return true;
        }
        return false;
    }

    public void merge(ItemDelta deltaToMerge) {
        this.checkConsistence();
        deltaToMerge.checkConsistence();
        if (deltaToMerge.isEmpty()) {
            return;
        }
        if (deltaToMerge.valuesToReplace != null) {
            if (this.valuesToReplace != null) {
                this.valuesToReplace.clear();
                this.valuesToReplace.addAll(deltaToMerge.valuesToReplace);
            }
            this.valuesToReplace = this.newValueCollection();
            this.valuesToReplace.addAll(deltaToMerge.valuesToReplace);
        } else {
            if (deltaToMerge.valuesToAdd != null) {
                this.addValuesToAdd(deltaToMerge.valuesToAdd);
            }
            if (deltaToMerge.valuesToDelete != null) {
                this.addValuesToDelete(deltaToMerge.valuesToDelete);
            }
        }
    }

    public void simplify() {
        ItemDefinition itemDefinition = this.getDefinition();
        if (itemDefinition == null) {
            throw new IllegalStateException("Attempt to simplify delta without a definition");
        }
        if (itemDefinition.isSingleValue() && this.isAdd()) {
            this.valuesToReplace = this.valuesToAdd;
            this.valuesToAdd = null;
            this.valuesToDelete = null;
        }
    }

    public void applyTo(PrismContainer<?> propertyContainer) throws SchemaException {
        Item item = propertyContainer.findOrCreateItem(this.getPath(), this.getItemClass(), this.getDefinition());
        this.applyTo(item);
        if (item.isEmpty()) {
            propertyContainer.remove(item);
        }
    }

    public static void applyTo(Collection<? extends ItemDelta> deltas, PrismContainer propertyContainer) throws SchemaException {
        for (ItemDelta itemDelta : deltas) {
            itemDelta.applyTo(propertyContainer);
        }
    }

    public void applyTo(Item item) throws SchemaException {
        if (this.valuesToReplace != null) {
            item.replaceAll(this.valuesToReplace);
            return;
        }
        if (this.valuesToAdd != null) {
            if (item.getDefinition() != null && item.getDefinition().isSingleValue()) {
                item.replaceAll(this.valuesToAdd);
            } else {
                item.addAll(this.valuesToAdd);
            }
        }
        if (this.valuesToDelete != null) {
            item.removeAll(this.valuesToDelete);
        }
    }

    public Item getItemNew() {
        if (this.definition == null) {
            throw new IllegalStateException("No definition in " + this);
        }
        if (this.valuesToDelete != null) {
            throw new IllegalStateException("Cannot fetch new item state from DELETE delta: " + this);
        }
        Item item = this.definition.instantiate();
        if (this.valuesToAdd != null) {
            if (this.definition.isSingleValue()) {
                item.getValues().addAll(this.valuesToAdd);
            } else {
                throw new IllegalStateException("Cannot fetch new item state from ADD delta of multivalue property: " + this);
            }
        }
        if (this.valuesToReplace == null || this.valuesToReplace.isEmpty()) {
            return item;
        }
        item.getValues().addAll(this.valuesToReplace);
        return item;
    }

    public abstract ItemDelta clone();

    protected void copyValues(ItemDelta clone) {
        clone.definition = this.definition;
        clone.name = this.name;
        clone.parentPath = this.parentPath;
        clone.valuesToAdd = this.cloneSet(this.valuesToAdd);
        clone.valuesToDelete = this.cloneSet(this.valuesToDelete);
        clone.valuesToReplace = this.cloneSet(this.valuesToReplace);
    }

    private Collection<V> cloneSet(Collection<V> thisSet) {
        if (thisSet == null) {
            return null;
        }
        Collection<V> clonedSet = this.newValueCollection();
        for (PrismValue thisVal : thisSet) {
            PrismValue clonedVal = thisVal.clone();
            clonedVal.setParent(this);
            clonedSet.add(clonedVal);
        }
        return clonedSet;
    }

    public static <T extends PrismValue> PrismValueDeltaSetTriple<T> toDeltaSetTriple(Item<T> item, ItemDelta<T> delta, boolean oldValuesValid, boolean newValuesValid) {
        if (item == null && delta == null) {
            return null;
        }
        if (!oldValuesValid && !newValuesValid) {
            return null;
        }
        if (oldValuesValid && !newValuesValid) {
            PrismValueDeltaSetTriple triple = new PrismValueDeltaSetTriple();
            if (item != null) {
                triple.addAllToMinusSet((Collection)item.getValues());
            }
            return triple;
        }
        if (item == null && delta != null) {
            return delta.toDeltaSetTriple(item);
        }
        if (delta == null || !oldValuesValid && newValuesValid) {
            PrismValueDeltaSetTriple triple = new PrismValueDeltaSetTriple();
            if (item != null) {
                triple.addAllToZeroSet((Collection)item.getValues());
            }
            return triple;
        }
        return delta.toDeltaSetTriple(item);
    }

    public PrismValueDeltaSetTriple<V> toDeltaSetTriple() {
        return this.toDeltaSetTriple(null);
    }

    public PrismValueDeltaSetTriple<V> toDeltaSetTriple(Item<V> item) {
        PrismValueDeltaSetTriple triple = new PrismValueDeltaSetTriple();
        if (this.isReplace()) {
            triple.getPlusSet().addAll(this.getValuesToReplace());
            if (item != null) {
                triple.getMinusSet().addAll((Collection)item.getValues());
            }
            return triple;
        }
        if (this.isAdd()) {
            triple.getPlusSet().addAll(this.getValuesToAdd());
        }
        if (this.isDelete()) {
            triple.getMinusSet().addAll(this.getValuesToDelete());
        }
        if (item != null && item.getValues() != null) {
            for (PrismValue itemVal : item.getValues()) {
                if (PrismValue.containsRealValue(this.valuesToDelete, itemVal)) continue;
                triple.getZeroSet().add(itemVal);
            }
        }
        return triple;
    }

    public void assertDefinitions(String sourceDescription) throws SchemaException {
        this.assertDefinitions(false, sourceDescription);
    }

    public void assertDefinitions(boolean tolarateRawValues, String sourceDescription) throws SchemaException {
        if (tolarateRawValues && this.isRaw()) {
            return;
        }
        if (this.definition == null) {
            throw new SchemaException("No definition in " + this + " in " + sourceDescription);
        }
        this.assertDefinitions(tolarateRawValues, this.valuesToAdd, "values to add in " + sourceDescription);
        this.assertDefinitions(tolarateRawValues, this.valuesToReplace, "values to replace in " + sourceDescription);
        this.assertDefinitions(tolarateRawValues, this.valuesToDelete, "values to delete in " + sourceDescription);
    }

    private void assertDefinitions(boolean tolarateRawValues, Collection<V> values, String sourceDescription) throws SchemaException {
        if (values == null) {
            return;
        }
        for (PrismValue val : values) {
            if (!(val instanceof PrismContainerValue)) continue;
            PrismContainerValue cval = (PrismContainerValue)val;
            for (Item<?> item : cval.getItems()) {
                item.assertDefinitions(tolarateRawValues, String.valueOf(cval.toString()) + " in " + sourceDescription);
            }
        }
    }

    public boolean isRaw() {
        Boolean isRaw = MiscUtil.and((Boolean[])new Boolean[]{this.isRawSet(this.valuesToAdd), this.isRawSet(this.valuesToReplace), this.isRawSet(this.valuesToDelete)});
        if (isRaw == null) {
            return false;
        }
        return isRaw;
    }

    private Boolean isRawSet(Collection<V> set) {
        if (set == null) {
            return null;
        }
        for (PrismValue val : set) {
            if (val.isRaw()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(");
        sb.append(this.parentPath).append(" / ").append(DebugUtil.prettyPrint((QName)this.name));
        if (this.valuesToReplace != null) {
            sb.append(", REPLACE");
        }
        if (this.valuesToAdd != null) {
            sb.append(", ADD");
        }
        if (this.valuesToDelete != null) {
            sb.append(", DELETE");
        }
        sb.append(")");
        return sb.toString();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.getClass().getSimpleName()).append("(");
        sb.append(this.parentPath).append(" / ").append(DebugUtil.prettyPrint((QName)this.name)).append(")");
        if (this.definition != null) {
            sb.append(" def");
        }
        if (this.valuesToReplace != null) {
            sb.append("\n");
            this.dumpValues(sb, "REPLACE", this.valuesToReplace, indent + 1);
        }
        if (this.valuesToAdd != null) {
            sb.append("\n");
            this.dumpValues(sb, "ADD", this.valuesToAdd, indent + 1);
        }
        if (this.valuesToDelete != null) {
            sb.append("\n");
            this.dumpValues(sb, "DELETE", this.valuesToDelete, indent + 1);
        }
        return sb.toString();
    }

    public String dump() {
        return this.debugDump();
    }

    protected void dumpValues(StringBuilder sb, String label, Collection<V> values, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(label).append(": ");
        if (values == null) {
            sb.append("(null)");
        } else {
            Iterator<V> i2 = values.iterator();
            while (i2.hasNext()) {
                sb.append(i2.next());
                if (!i2.hasNext()) continue;
                sb.append(", ");
            }
        }
    }
}

