/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContainerable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ContainerDelta<V extends Containerable>
extends ItemDelta<PrismContainerValue<V>>
implements PrismContainerable<V> {
    public ContainerDelta(PrismContainerDefinition itemDefinition) {
        super(itemDefinition);
    }

    public ContainerDelta(PropertyPath propertyPath, PrismContainerDefinition itemDefinition) {
        super(propertyPath, (ItemDefinition)itemDefinition);
        if (itemDefinition instanceof PrismObjectDefinition) {
            throw new IllegalArgumentException("Cannot apply " + this.definition + " to container delta");
        }
    }

    public ContainerDelta(PropertyPath parentPath, QName name, PrismContainerDefinition itemDefinition) {
        super(parentPath, name, itemDefinition);
        if (itemDefinition instanceof PrismObjectDefinition) {
            throw new IllegalArgumentException("Cannot apply " + this.definition + " to container delta");
        }
    }

    public ContainerDelta(QName name, PrismContainerDefinition itemDefinition) {
        super(name, (ItemDefinition)itemDefinition);
        if (itemDefinition instanceof PrismObjectDefinition) {
            throw new IllegalArgumentException("Cannot apply " + this.definition + " to container delta");
        }
    }

    @Override
    public Class<PrismContainer> getItemClass() {
        return PrismContainer.class;
    }

    public <T extends Containerable> Collection<PrismContainerValue<T>> getValues(Class<T> type) {
        this.checkConsistence();
        if (this.valuesToReplace != null) {
            return this.valuesToReplace;
        }
        return MiscUtil.union((Collection[])new Collection[]{this.valuesToAdd, this.valuesToDelete});
    }

    @Override
    public PrismContainerDefinition<V> getDefinition() {
        return (PrismContainerDefinition)super.getDefinition();
    }

    @Override
    public void setDefinition(ItemDefinition definition) {
        if (!(definition instanceof PrismContainerDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to container delta");
        }
        if (definition instanceof PrismObjectDefinition) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to container delta");
        }
        super.setDefinition(definition);
    }

    @Override
    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        if (!(definition instanceof PrismContainerDefinition)) {
            throw new IllegalArgumentException("Cannot apply definition " + definition + " to container delta " + this);
        }
        super.applyDefinition(definition);
    }

    @Override
    public Class<V> getCompileTimeClass() {
        if (this.getDefinition() != null) {
            return ((PrismContainerDefinition)this.getDefinition()).getCompileTimeClass();
        }
        return null;
    }

    @Override
    public void applyTo(Item item) throws SchemaException {
        if (!(item instanceof PrismContainer)) {
            throw new SchemaException("Cannot apply container delta " + this + " to item " + item + " of type " + item.getClass());
        }
        super.applyTo(item);
    }

    @Override
    public ContainerDelta<V> clone() {
        ContainerDelta<V> clone = new ContainerDelta<V>(this.getName(), (PrismContainerDefinition)this.getDefinition());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(ContainerDelta<V> clone) {
        super.copyValues(clone);
    }

    public static <T extends Containerable, O extends Objectable> ContainerDelta<T> createDelta(PrismContext prismContext, Class<O> type, QName containerName) {
        PrismObjectDefinition<O> objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        return ContainerDelta.createDelta(objectDefinition, containerName);
    }

    public static <T extends Containerable, O extends Objectable> ContainerDelta<T> createDelta(PrismObjectDefinition<O> objectDefinition, QName containerName) {
        PrismContainerDefinition containerDefinition = objectDefinition.findContainerDefinition(containerName);
        if (containerDefinition == null) {
            throw new IllegalArgumentException("No definition for " + containerName + " in " + objectDefinition);
        }
        ContainerDelta delta = new ContainerDelta(containerName, containerDefinition);
        return delta;
    }

    @Override
    protected void dumpValues(StringBuilder sb, String label, Collection<PrismContainerValue<V>> values, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(label).append(":");
        if (values == null) {
            sb.append(" (null)");
        } else {
            sb.append("\n");
            Iterator<PrismContainerValue<V>> i2 = values.iterator();
            while (i2.hasNext()) {
                sb.append(i2.next().debugDump(indent + 1));
                if (!i2.hasNext()) continue;
                sb.append("\n");
            }
        }
    }
}

