/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import java.util.Arrays;
import javax.xml.namespace.QName;

public class PrismPropertyDefinition
extends ItemDefinition {
    private static final long serialVersionUID = 7259761997904371009L;
    private QName valueType;
    private Object[] allowedValues;
    private boolean create = true;
    private boolean read = true;
    private boolean update = true;
    private Boolean indexed = null;

    public PrismPropertyDefinition(QName name, QName defaultName, QName typeName, PrismContext prismContext) {
        super(name, defaultName, typeName, prismContext);
    }

    public Object[] getAllowedValues() {
        return this.allowedValues;
    }

    public boolean canRead() {
        return this.read;
    }

    public boolean canUpdate() {
        return this.update;
    }

    public void setReadOnly() {
        this.create = false;
        this.read = true;
        this.update = false;
    }

    public QName getValueType() {
        return this.valueType;
    }

    void setValueType(QName valueType) {
        this.valueType = valueType;
    }

    public Boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public PrismProperty instantiate() {
        return this.instantiate(this.getNameOrDefaultName());
    }

    @Override
    public PrismProperty instantiate(QName name) {
        return new PrismProperty(name, this, this.prismContext);
    }

    @Override
    public PrismPropertyDefinition clone() {
        PrismPropertyDefinition clone = new PrismPropertyDefinition(this.getName(), this.getDefaultName(), this.getValueType(), this.getPrismContext());
        this.copyDefinitionData(clone);
        return clone;
    }

    protected void copyDefinitionData(PrismPropertyDefinition clone) {
        super.copyDefinitionData(clone);
        clone.allowedValues = this.allowedValues;
        clone.valueType = this.valueType;
        clone.create = this.create;
        clone.read = this.read;
        clone.update = this.update;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean canCreate() {
        return this.create;
    }

    @Override
    protected void extendToString(StringBuilder sb) {
        super.extendToString(sb);
        sb.append(",");
        if (this.canRead()) {
            sb.append("R");
        } else {
            sb.append("-");
        }
        if (this.canCreate()) {
            sb.append("C");
        } else {
            sb.append("-");
        }
        if (this.canUpdate()) {
            sb.append("U");
        } else {
            sb.append("-");
        }
        if (this.indexed != null && this.indexed.booleanValue()) {
            sb.append(",I");
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.allowedValues);
        result = 31 * result + (this.create ? 1231 : 1237);
        result = 31 * result + (this.read ? 1231 : 1237);
        result = 31 * result + (this.update ? 1231 : 1237);
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismPropertyDefinition other = (PrismPropertyDefinition)obj;
        if (!Arrays.equals(this.allowedValues, other.allowedValues)) {
            return false;
        }
        if (this.create != other.create) {
            return false;
        }
        if (this.read != other.read) {
            return false;
        }
        if (this.update != other.update) {
            return false;
        }
        return !(this.valueType == null ? other.valueType != null : !this.valueType.equals(other.valueType));
    }

    @Override
    protected String getDebugDumpClassName() {
        return "PPD";
    }
}

