/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.xml.XsdTypeMapper;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import java.io.Serializable;
import javax.xml.namespace.QName;

public abstract class Definition
implements Serializable,
Dumpable,
DebugDumpable {
    private static final long serialVersionUID = -2643332934312107274L;
    protected QName defaultName;
    protected QName typeName;
    protected boolean ignored = false;
    protected String displayName;
    protected Integer displayOrder;
    protected String help;
    protected transient PrismContext prismContext;

    Definition(QName defaultName, QName typeName, PrismContext prismContext) {
        if (typeName == null) {
            throw new IllegalArgumentException("Type name can't be null.");
        }
        this.defaultName = defaultName;
        this.typeName = typeName;
        this.prismContext = prismContext;
    }

    public QName getDefaultName() {
        return this.defaultName;
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(QName typeName) {
        this.typeName = typeName;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    protected SchemaRegistry getSchemaRegistry() {
        return this.prismContext.getSchemaRegistry();
    }

    public Class getTypeClass() {
        return XsdTypeMapper.toJavaType(this.getTypeName());
    }

    abstract void revive(PrismContext var1);

    protected void copyDefinitionData(Definition clone) {
        clone.defaultName = this.defaultName;
        clone.ignored = this.ignored;
        clone.typeName = this.typeName;
        clone.displayName = this.displayName;
        clone.displayOrder = this.displayOrder;
        clone.help = this.help;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ignored ? 1231 : 1237);
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Definition other = (Definition)obj;
        if (this.ignored != other.ignored) {
            return false;
        }
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }

    public String toString() {
        return String.valueOf(this.getDebugDumpClassName()) + " (" + this.getTypeName() + ")";
    }

    public String dump() {
        return this.debugDump();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.toString());
        return sb.toString();
    }

    protected abstract String getDebugDumpClassName();
}

